/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.nio;

import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.transport.AbstractSender;
import org.apache.catalina.tribes.transport.MultiPointSender;
import org.apache.catalina.tribes.transport.SenderState;
import org.apache.catalina.tribes.transport.nio.NioSender;
import org.apache.catalina.tribes.util.Logs;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ParallelNioSender
extends AbstractSender
implements MultiPointSender {
    private static final Log log = LogFactory.getLog(ParallelNioSender.class);
    protected long selectTimeout = 5000L;
    protected Selector selector;
    protected HashMap<Member, NioSender> nioSenders = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParallelNioSender() throws IOException {
        Class<Selector> clazz = Selector.class;
        synchronized (Selector.class) {
            this.selector = Selector.open();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.setConnected(true);
            return;
        }
    }

    @Override
    public synchronized void sendMessage(Member[] memberArray, ChannelMessage channelMessage) throws ChannelException {
        long l = System.currentTimeMillis();
        this.setUdpBased((channelMessage.getOptions() & 0x20) == 32);
        byte[] byArray = XByteBuffer.createDataPackage((ChannelData)channelMessage);
        NioSender[] nioSenderArray = this.setupForSend(memberArray);
        this.connect(nioSenderArray);
        this.setData(nioSenderArray, byArray);
        int n = nioSenderArray.length;
        ChannelException channelException = null;
        try {
            Object object;
            boolean bl;
            long l2 = System.currentTimeMillis() - l;
            boolean bl2 = bl = (2 & channelMessage.getOptions()) == 2;
            while (n > 0 && l2 < this.getTimeout()) {
                try {
                    object = this.doLoop(this.selectTimeout, this.getMaxRetryAttempts(), bl, channelMessage);
                    n -= ((SendResult)object).getCompleted();
                    if (((SendResult)object).getFailed() != null) {
                        n -= ((SendResult)object).getFailed().getFaultyMembers().length;
                        if (channelException == null) {
                            channelException = ((SendResult)object).getFailed();
                        } else {
                            channelException.addFaultyMember(((SendResult)object).getFailed().getFaultyMembers());
                        }
                    }
                }
                catch (Exception exception) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"Error sending message", (Throwable)exception);
                    }
                    if (channelException == null) {
                        channelException = exception instanceof ChannelException ? (ChannelException)exception : new ChannelException("Parallel NIO send failed.", exception);
                    }
                    for (NioSender nioSender : nioSenderArray) {
                        if (nioSender.isComplete()) continue;
                        channelException.addFaultyMember(nioSender.getDestination(), exception);
                    }
                    throw channelException;
                }
                l2 = System.currentTimeMillis() - l;
            }
            if (n > 0) {
                object = new ChannelException("Operation has timed out(" + this.getTimeout() + " ms.).");
                if (channelException == null) {
                    channelException = new ChannelException("Operation has timed out(" + this.getTimeout() + " ms.).");
                }
                for (NioSender nioSender : nioSenderArray) {
                    if (nioSender.isComplete()) continue;
                    channelException.addFaultyMember(nioSender.getDestination(), (Exception)object);
                }
                throw channelException;
            }
            if (channelException != null) {
                throw channelException;
            }
        }
        catch (Exception exception) {
            try {
                this.disconnect();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            if (exception instanceof ChannelException) {
                throw (ChannelException)exception;
            }
            throw new ChannelException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SendResult doLoop(long l, int n, boolean bl, ChannelMessage channelMessage) throws ChannelException {
        int n2;
        SendResult sendResult = new SendResult();
        try {
            n2 = this.selector.select(l);
        }
        catch (IOException iOException) {
            throw new ChannelException("Parallel NIO send failed.", iOException);
        }
        if (n2 == 0) {
            return sendResult;
        }
        Iterator<SelectionKey> iterator = this.selector.selectedKeys().iterator();
        while (iterator.hasNext()) {
            SelectionKey selectionKey = iterator.next();
            iterator.remove();
            int n3 = selectionKey.readyOps();
            selectionKey.interestOps(selectionKey.interestOps() & ~n3);
            NioSender nioSender = (NioSender)selectionKey.attachment();
            try {
                if (!nioSender.process(selectionKey, bl)) continue;
                nioSender.setComplete(true);
                sendResult.complete(nioSender);
                if (Logs.MESSAGES.isTraceEnabled()) {
                    Logs.MESSAGES.trace((Object)("ParallelNioSender - Sent msg:" + new UniqueId(channelMessage.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis()) + " to " + nioSender.getDestination().getName()));
                }
                SenderState.getSenderState(nioSender.getDestination()).setReady();
            }
            catch (Exception exception) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Error while processing send to " + nioSender.getDestination().getName()), (Throwable)exception);
                }
                SenderState senderState = SenderState.getSenderState(nioSender.getDestination());
                int n4 = nioSender.getAttempt() + 1;
                boolean bl2 = n4 <= n && n > 0;
                Object object = senderState;
                synchronized (object) {
                    if (senderState.isSuspect()) {
                        senderState.setFailing();
                    }
                    if (senderState.isReady()) {
                        senderState.setSuspect();
                        if (bl2) {
                            log.warn((Object)("Member send is failing for:" + nioSender.getDestination().getName() + " ; Setting to suspect and retrying."));
                        } else {
                            log.warn((Object)("Member send is failing for:" + nioSender.getDestination().getName() + " ; Setting to suspect."), (Throwable)exception);
                        }
                    }
                }
                if (!this.isConnected()) {
                    log.warn((Object)("Not retrying send for:" + nioSender.getDestination().getName() + "; Sender is disconnected."));
                    object = new ChannelException("Send failed, and sender is disconnected. Not retrying.", exception);
                    ((ChannelException)object).addFaultyMember(nioSender.getDestination(), exception);
                    sendResult.failed((ChannelException)object);
                    break;
                }
                object = nioSender.getMessage();
                if (bl2) {
                    try {
                        nioSender.disconnect();
                        nioSender.connect();
                        nioSender.setAttempt(n4);
                        nioSender.setMessage((byte[])object);
                    }
                    catch (Exception exception2) {
                        senderState.setFailing();
                    }
                    continue;
                }
                ChannelException channelException = new ChannelException("Send failed, attempt:" + nioSender.getAttempt() + " max:" + n, exception);
                channelException.addFaultyMember(nioSender.getDestination(), exception);
                sendResult.failed(channelException);
            }
        }
        return sendResult;
    }

    private void connect(NioSender[] nioSenderArray) throws ChannelException {
        ChannelException channelException = null;
        for (NioSender nioSender : nioSenderArray) {
            try {
                nioSender.connect();
            }
            catch (IOException iOException) {
                if (channelException == null) {
                    channelException = new ChannelException(iOException);
                }
                channelException.addFaultyMember(nioSender.getDestination(), iOException);
            }
        }
        if (channelException != null) {
            throw channelException;
        }
    }

    private void setData(NioSender[] nioSenderArray, byte[] byArray) throws ChannelException {
        ChannelException channelException = null;
        for (NioSender nioSender : nioSenderArray) {
            try {
                nioSender.setMessage(byArray);
            }
            catch (IOException iOException) {
                if (channelException == null) {
                    channelException = new ChannelException(iOException);
                }
                channelException.addFaultyMember(nioSender.getDestination(), iOException);
            }
        }
        if (channelException != null) {
            throw channelException;
        }
    }

    private NioSender[] setupForSend(Member[] memberArray) throws ChannelException {
        ChannelException channelException = null;
        NioSender[] nioSenderArray = new NioSender[memberArray.length];
        for (int i = 0; i < memberArray.length; ++i) {
            NioSender nioSender = this.nioSenders.get(memberArray[i]);
            try {
                if (nioSender == null) {
                    nioSender = new NioSender();
                    AbstractSender.transferProperties(this, nioSender);
                    this.nioSenders.put(memberArray[i], nioSender);
                }
                nioSender.reset();
                nioSender.setDestination(memberArray[i]);
                nioSender.setSelector(this.selector);
                nioSender.setUdpBased(this.isUdpBased());
                nioSenderArray[i] = nioSender;
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                if (channelException == null) {
                    channelException = new ChannelException("Unable to setup NioSender.", unknownHostException);
                }
                channelException.addFaultyMember(memberArray[i], unknownHostException);
            }
        }
        if (channelException != null) {
            throw channelException;
        }
        return nioSenderArray;
    }

    @Override
    public void connect() {
        this.setConnected(true);
    }

    private synchronized void close() throws ChannelException {
        Object[] objectArray;
        ChannelException channelException = null;
        for (Object object : objectArray = this.nioSenders.keySet().toArray()) {
            Member member = (Member)object;
            try {
                NioSender nioSender = this.nioSenders.get(member);
                nioSender.disconnect();
            }
            catch (Exception exception) {
                if (channelException == null) {
                    channelException = new ChannelException(exception);
                }
                channelException.addFaultyMember(member, exception);
            }
            this.nioSenders.remove(member);
        }
        if (channelException != null) {
            throw channelException;
        }
    }

    @Override
    public void add(Member member) {
    }

    @Override
    public void remove(Member member) {
        NioSender nioSender = this.nioSenders.remove(member);
        if (nioSender != null) {
            nioSender.disconnect();
        }
    }

    @Override
    public synchronized void disconnect() {
        this.setConnected(false);
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void finalize() throws Throwable {
        block4: {
            try {
                this.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.selector.close();
            }
            catch (Exception exception) {
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"Failed to close selector", (Throwable)exception);
            }
        }
        super.finalize();
    }

    @Override
    public boolean keepalive() {
        boolean bl = false;
        Iterator<Map.Entry<Member, NioSender>> iterator = this.nioSenders.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Member, NioSender> entry = iterator.next();
            NioSender nioSender = entry.getValue();
            if (nioSender.keepalive()) {
                iterator.remove();
                bl = true;
                continue;
            }
            try {
                nioSender.read(null);
            }
            catch (IOException iOException) {
                nioSender.disconnect();
                nioSender.reset();
                iterator.remove();
                bl = true;
            }
            catch (Exception exception) {
                log.warn((Object)("Error during keepalive test for sender:" + nioSender), (Throwable)exception);
            }
        }
        if (bl) {
            try {
                this.selector.selectNow();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    private static class SendResult {
        private List<NioSender> completeSenders = new ArrayList<NioSender>();
        private ChannelException exception = null;

        private SendResult() {
        }

        private void complete(NioSender nioSender) {
            if (!this.completeSenders.contains(nioSender)) {
                this.completeSenders.add(nioSender);
            }
        }

        private int getCompleted() {
            return this.completeSenders.size();
        }

        private void failed(ChannelException channelException) {
            if (this.exception == null) {
                this.exception = channelException;
            }
            this.exception.addFaultyMember(channelException.getFaultyMembers());
        }

        private ChannelException getFailed() {
            return this.exception;
        }
    }
}

