/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries.ui;

import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.ContributedLibraryReleases;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class ContributedLibraryReleasesComparator
implements Comparator<ContributedLibraryReleases> {
    private final String firstType;

    public ContributedLibraryReleasesComparator(String firstType) {
        this.firstType = firstType;
    }

    @Override
    public int compare(ContributedLibraryReleases o1, ContributedLibraryReleases o2) {
        ContributedLibrary lib1 = o1.getLatest();
        ContributedLibrary lib2 = o2.getLatest();
        List<String> types1 = lib1.getTypes();
        List<String> types2 = lib2.getTypes();
        if (types1 == null) {
            types1 = Arrays.asList(new String[0]);
        }
        if (types2 == null) {
            types2 = Arrays.asList(new String[0]);
        }
        if (lib1.getTypes().contains(this.firstType) && lib2.getTypes().contains(this.firstType)) {
            return this.compareName(lib1, lib2);
        }
        if (lib1.getTypes().contains(this.firstType)) {
            return -1;
        }
        if (lib2.getTypes().contains(this.firstType)) {
            return 1;
        }
        return this.compareName(lib1, lib2);
    }

    private int compareName(ContributedLibrary lib1, ContributedLibrary lib2) {
        return lib1.getName().compareToIgnoreCase(lib2.getName());
    }
}

