/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization.signature;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureComputer;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.overrides.IrOverridingUtilKt;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001c\u0010\u001e\u001a\u00020\u0016*\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001c\u0010 \u001a\u00020\u0016*\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0014R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureSerializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/IdSignatureComputer;", "publicSignatureBuilder", "Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;", "table", "Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;", "(Lorg/jetbrains/kotlin/backend/common/serialization/signature/PublicIdSignatureComputer;Lorg/jetbrains/kotlin/backend/common/serialization/DeclarationTable;)V", "localIndex", "", "getLocalIndex", "()J", "setLocalIndex", "(J)V", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "scopeIndex", "", "getScopeIndex", "()I", "setScopeIndex", "(I)V", "composeContainerIdSignature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "composeFileLocalIdSignature", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "composeSignatureForDeclaration", "computeSignature", "createFileLocalSignature", "parentSignature", "createScopeLocalSignature", "description", "", "ir.serialization.common"})
public class IdSignatureSerializer
implements IdSignatureComputer {
    @NotNull
    private final PublicIdSignatureComputer publicSignatureBuilder;
    @NotNull
    private final DeclarationTable table;
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    private long localIndex;
    private int scopeIndex;

    public IdSignatureSerializer(@NotNull PublicIdSignatureComputer publicSignatureBuilder, @NotNull DeclarationTable table) {
        Intrinsics.checkNotNullParameter(publicSignatureBuilder, "publicSignatureBuilder");
        Intrinsics.checkNotNullParameter(table, "table");
        this.publicSignatureBuilder = publicSignatureBuilder;
        this.table = table;
        this.mangler = this.publicSignatureBuilder.getMangler();
    }

    @Override
    @Nullable
    public IdSignature computeSignature(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        KotlinMangler.IrMangler irMangler = this.mangler;
        boolean bl = false;
        boolean bl2 = false;
        KotlinMangler.IrMangler $this$computeSignature_u24lambda_u2d0 = irMangler;
        boolean bl3 = false;
        return $this$computeSignature_u24lambda_u2d0.isExported(declaration2) ? this.publicSignatureBuilder.composePublicIdSignature(declaration2) : null;
    }

    @NotNull
    public final IdSignature composeSignatureForDeclaration(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        KotlinMangler.IrMangler irMangler = this.mangler;
        boolean bl = false;
        boolean bl2 = false;
        KotlinMangler.IrMangler $this$composeSignatureForDeclaration_u24lambda_u2d1 = irMangler;
        boolean bl3 = false;
        return $this$composeSignatureForDeclaration_u24lambda_u2d1.isExported(declaration2) ? this.publicSignatureBuilder.composePublicIdSignature(declaration2) : this.composeFileLocalIdSignature(declaration2);
    }

    protected final long getLocalIndex() {
        return this.localIndex;
    }

    protected final void setLocalIndex(long l) {
        this.localIndex = l;
    }

    protected final int getScopeIndex() {
        return this.scopeIndex;
    }

    protected final void setScopeIndex(int n) {
        this.scopeIndex = n;
    }

    private final IdSignature composeContainerIdSignature(IrDeclarationParent container2) {
        IdSignature idSignature;
        IrDeclarationParent irDeclarationParent = container2;
        if (irDeclarationParent instanceof IrPackageFragment) {
            String string2 = ((IrPackageFragment)container2).getFqName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "container.fqName.asString()");
            idSignature = new IdSignature.PublicSignature(string2, "", null, 0L);
        } else if (irDeclarationParent instanceof IrDeclaration) {
            idSignature = this.table.signatureByDeclaration((IrDeclaration)((Object)container2));
        } else {
            String string3 = Intrinsics.stringPlus("Unexpected container ", RenderIrElementKt.render(container2));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        return idSignature;
    }

    @NotNull
    public final IdSignature composeFileLocalIdSignature(@NotNull IrDeclaration declaration2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        KotlinMangler.IrMangler irMangler = this.mangler;
        boolean bl = false;
        boolean bl2 = false;
        KotlinMangler.IrMangler $this$composeFileLocalIdSignature_u24lambda_u2d2 = irMangler;
        boolean bl3 = false;
        boolean bl4 = !$this$composeFileLocalIdSignature_u24lambda_u2d2.isExported(declaration2);
        bl = false;
        bl2 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean bl5 = false;
            String string2 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        return this.table.privateDeclarationSignature(declaration2, (Function0<? extends IdSignature>)new Function0<IdSignature>(declaration2, this){
            final /* synthetic */ IrDeclaration $declaration;
            final /* synthetic */ IdSignatureSerializer this$0;
            {
                this.$declaration = $declaration;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IdSignature invoke() {
                IdSignature idSignature;
                IrDeclaration irDeclaration2 = this.$declaration;
                if (irDeclaration2 instanceof IrValueDeclaration) {
                    Object object = this.this$0;
                    int n = ((IdSignatureSerializer)object).getScopeIndex();
                    ((IdSignatureSerializer)object).setScopeIndex(n + 1);
                    object = ((IrValueDeclaration)this.$declaration).getName().asString();
                    Intrinsics.checkNotNullExpressionValue(object, "declaration.name.asString()");
                    idSignature = this.this$0.createScopeLocalSignature(this.$declaration, n, (String)object);
                } else if (irDeclaration2 instanceof IrField) {
                    IdSignature idSignature2;
                    IrPropertySymbol irPropertySymbol = ((IrField)this.$declaration).getCorrespondingPropertySymbol();
                    if (irPropertySymbol == null) {
                        idSignature2 = null;
                    } else {
                        IrPropertySymbol irPropertySymbol2 = irPropertySymbol;
                        IdSignatureSerializer idSignatureSerializer = this.this$0;
                        boolean bl = false;
                        boolean bl2 = false;
                        IrPropertySymbol it = irPropertySymbol2;
                        boolean bl3 = false;
                        idSignature2 = idSignatureSerializer.composeSignatureForDeclaration((IrDeclaration)it.getOwner());
                    }
                    Object object = idSignature2;
                    IdSignature p = object == null ? IdSignatureSerializer.access$composeContainerIdSignature(this.this$0, this.$declaration.getParent()) : object;
                    object = this.this$0;
                    ((IdSignatureSerializer)object).setLocalIndex(((IdSignatureSerializer)object).getLocalIndex() + 1L);
                    idSignature = this.this$0.createFileLocalSignature(this.$declaration, p, ((IdSignatureSerializer)object).getLocalIndex());
                } else if (irDeclaration2 instanceof IrSimpleFunction) {
                    long l;
                    IdSignature idSignature3;
                    IrDeclarationParent parent2 = this.$declaration.getParent();
                    Object object = ((IrSimpleFunction)this.$declaration).getCorrespondingPropertySymbol();
                    if (object == null) {
                        idSignature3 = null;
                    } else {
                        IrPropertySymbol irPropertySymbol = object;
                        IdSignatureSerializer idSignatureSerializer = this.this$0;
                        boolean bl = false;
                        boolean it = false;
                        IrPropertySymbol it2 = irPropertySymbol;
                        boolean bl4 = false;
                        idSignature3 = idSignatureSerializer.composeSignatureForDeclaration((IrDeclaration)it2.getOwner());
                    }
                    Object object2 = idSignature3;
                    IdSignature p = object2 == null ? IdSignatureSerializer.access$composeContainerIdSignature(this.this$0, parent2) : object2;
                    IdSignatureSerializer idSignatureSerializer = this.this$0;
                    IrDeclaration irDeclaration3 = this.$declaration;
                    IdSignature idSignature4 = p;
                    if (IrOverridingUtilKt.isOverridableFunction((IrSimpleFunction)this.$declaration)) {
                        void $this$invoke_u24lambda_u2d2;
                        object2 = IdSignatureSerializer.access$getMangler$p(this.this$0);
                        object = this.$declaration;
                        boolean bl = false;
                        boolean bl5 = false;
                        Object object3 = object2;
                        IdSignature idSignature5 = idSignature4;
                        IrDeclaration irDeclaration4 = irDeclaration3;
                        IdSignatureSerializer idSignatureSerializer2 = idSignatureSerializer;
                        boolean bl6 = false;
                        long l2 = $this$invoke_u24lambda_u2d2.getSignatureMangle(object);
                        idSignatureSerializer = idSignatureSerializer2;
                        irDeclaration3 = irDeclaration4;
                        idSignature4 = idSignature5;
                        l = l2;
                    } else {
                        object2 = this.this$0;
                        ((IdSignatureSerializer)object2).setLocalIndex(((IdSignatureSerializer)object2).getLocalIndex() + 1L);
                        l = ((IdSignatureSerializer)object2).getLocalIndex();
                    }
                    idSignature = idSignatureSerializer.createFileLocalSignature(irDeclaration3, idSignature4, l);
                } else if (irDeclaration2 instanceof IrProperty) {
                    long l;
                    IrDeclarationParent parent3 = this.$declaration.getParent();
                    IdSignatureSerializer idSignatureSerializer = this.this$0;
                    IrDeclaration irDeclaration5 = this.$declaration;
                    IdSignature idSignature6 = IdSignatureSerializer.access$composeContainerIdSignature(this.this$0, parent3);
                    if (IrOverridingUtilKt.isOverridableProperty((IrProperty)this.$declaration)) {
                        void $this$invoke_u24lambda_u2d3;
                        KotlinMangler.IrMangler irMangler = IdSignatureSerializer.access$getMangler$p(this.this$0);
                        IrDeclaration irDeclaration6 = this.$declaration;
                        boolean bl = false;
                        boolean bl7 = false;
                        KotlinMangler.IrMangler irMangler2 = irMangler;
                        IdSignature idSignature7 = idSignature6;
                        IrDeclaration irDeclaration7 = irDeclaration5;
                        IdSignatureSerializer idSignatureSerializer3 = idSignatureSerializer;
                        boolean bl8 = false;
                        long l3 = $this$invoke_u24lambda_u2d3.getSignatureMangle(irDeclaration6);
                        idSignatureSerializer = idSignatureSerializer3;
                        irDeclaration5 = irDeclaration7;
                        idSignature6 = idSignature7;
                        l = l3;
                    } else {
                        IdSignatureSerializer idSignatureSerializer4 = this.this$0;
                        idSignatureSerializer4.setLocalIndex(idSignatureSerializer4.getLocalIndex() + 1L);
                        l = idSignatureSerializer4.getLocalIndex();
                    }
                    idSignature = idSignatureSerializer.createFileLocalSignature(irDeclaration5, idSignature6, l);
                } else {
                    IdSignature idSignature8 = IdSignatureSerializer.access$composeContainerIdSignature(this.this$0, this.$declaration.getParent());
                    IdSignatureSerializer idSignatureSerializer = this.this$0;
                    idSignatureSerializer.setLocalIndex(idSignatureSerializer.getLocalIndex() + 1L);
                    idSignature = this.this$0.createFileLocalSignature(this.$declaration, idSignature8, idSignatureSerializer.getLocalIndex());
                }
                return idSignature;
            }
        });
    }

    @NotNull
    protected IdSignature createFileLocalSignature(@NotNull IrDeclaration $this$createFileLocalSignature, @NotNull IdSignature parentSignature, long localIndex) {
        Intrinsics.checkNotNullParameter($this$createFileLocalSignature, "<this>");
        Intrinsics.checkNotNullParameter(parentSignature, "parentSignature");
        return new IdSignature.FileLocalSignature(parentSignature, localIndex);
    }

    @NotNull
    protected IdSignature createScopeLocalSignature(@NotNull IrDeclaration $this$createScopeLocalSignature, int scopeIndex, @NotNull String description2) {
        Intrinsics.checkNotNullParameter($this$createScopeLocalSignature, "<this>");
        Intrinsics.checkNotNullParameter(description2, "description");
        return new IdSignature.ScopeLocalDeclaration(scopeIndex, description2);
    }

    public static final /* synthetic */ IdSignature access$composeContainerIdSignature(IdSignatureSerializer $this, IrDeclarationParent container2) {
        return $this.composeContainerIdSignature(container2);
    }

    public static final /* synthetic */ KotlinMangler.IrMangler access$getMangler$p(IdSignatureSerializer $this) {
        return $this.mangler;
    }
}

