/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirModuleDataKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.FirSyntheticFunctionSymbol;
import org.jetbrains.kotlin.fir.resolve.calls.ReceiverValue;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J0\u0010\f\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0004J.\u0010\f\u001a\u00020\u00042\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002JM\u0010\u0011\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0012*\u00020\u0013*\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u0002H\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0019J-\u0010\u0011\u001a\u00020\u0004\"\u0010\b\u0000\u0010\u0012*\u00020\u0013*\u0006\u0012\u0002\b\u00030\u00142\u0006\u0010\u0015\u001a\u0002H\u00122\u0006\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\u0002\u0010\u001cJD\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000bH$J\f\u0010\"\u001a\u00020\u0004*\u00020#H\u0002J\u0014\u0010$\u001a\u00020\u0004*\u00020\t2\u0006\u0010%\u001a\u00020\tH\u0002J \u0010&\u001a\u00020\u0004*\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010'\u001a\u0004\u0018\u00010\t*\u0004\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0016\u0010'\u001a\u0004\u0018\u00010\t*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010(\u001a\u00020)*\u0006\u0012\u0002\b\u00030!H\u0004\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/FirVisibilityChecker;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "()V", "canSeePrivateMemberOf", "", "containingDeclarationOfUseSite", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "ownerId", "Lorg/jetbrains/kotlin/name/ClassId;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "canSeeProtectedMemberOf", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "containingUseSiteClass", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "isVisible", "T", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "Lorg/jetbrains/kotlin/fir/FirSymbolOwner;", "declaration", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingDeclarations", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/util/List;Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;)Z", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "(Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;)Z", "platformVisibilityCheck", "declarationVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "isAllowedToBeAccessedFromOutside", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "isSame", "other", "isSubClass", "ownerIfCompanion", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "Default", "resolve"})
public abstract class FirVisibilityChecker
implements FirSessionComponent {
    public final <T extends FirMemberDeclaration & FirSymbolOwner<?>> boolean isVisible(@NotNull T declaration2, @NotNull Candidate candidate2) {
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(candidate2, "candidate");
        if (declaration2 instanceof FirCallableDeclaration && (ClassMembersKt.isIntersectionOverride((FirCallableDeclaration)declaration2) || ClassMembersKt.isSubstitutionOverride((FirCallableDeclaration)declaration2))) {
            FirCallableDeclaration firCallableDeclaration;
            FirCallableDeclaration firCallableDeclaration2;
            FirCallableDeclaration firCallableDeclaration3;
            FirCallableDeclaration $this$originalIfFakeOverride$iv = (FirCallableDeclaration)declaration2;
            boolean $i$f$originalIfFakeOverride = false;
            FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = $this$originalIfFakeOverride$iv;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration firCallableDeclaration4 = firCallableDeclaration3 = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
            if (firCallableDeclaration3 == null) {
                FirCallableDeclaration $this$baseForIntersectionOverride$iv$iv = $this$originalIfFakeOverride$iv;
                boolean $i$f$getBaseForIntersectionOverride = false;
                firCallableDeclaration2 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv) : null;
            } else {
                firCallableDeclaration2 = firCallableDeclaration = firCallableDeclaration3;
            }
            if (firCallableDeclaration == null) {
                throw new NullPointerException("null cannot be cast to non-null type T of org.jetbrains.kotlin.fir.FirVisibilityChecker.isVisible");
            }
            return this.isVisible((FirMemberDeclaration)((Object)firCallableDeclaration), candidate2);
        }
        CallInfo callInfo = candidate2.getCallInfo();
        FirFile useSiteFile = callInfo.getContainingFile();
        List<FirDeclaration> containingDeclarations = callInfo.getContainingDeclarations();
        FirSession session2 = callInfo.getSession();
        return this.isVisible(declaration2, session2, useSiteFile, (List<? extends FirDeclaration>)containingDeclarations, candidate2.getDispatchReceiverValue());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final <T extends FirMemberDeclaration & FirSymbolOwner<?>> boolean isVisible(@NotNull T declaration2, @NotNull FirSession session2, @NotNull FirFile useSiteFile, @NotNull List<? extends FirDeclaration> containingDeclarations, @Nullable ReceiverValue dispatchReceiver) {
        boolean bl;
        ClassId ownerId;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(session2, "session");
        Intrinsics.checkNotNullParameter(useSiteFile, "useSiteFile");
        Intrinsics.checkNotNullParameter(containingDeclarations, "containingDeclarations");
        FirProvider provider2 = MainSessionComponentsKt.getFirProvider(session2);
        AbstractFirBasedSymbol<?> symbol2 = ((FirSymbolOwner<?>)declaration2).getSymbol();
        Object $this$visibility$iv = declaration2;
        boolean $i$f$getVisibility = false;
        Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
        if (Intrinsics.areEqual(visibility2, Visibilities.Internal.INSTANCE)) {
            if (Intrinsics.areEqual(declaration2.getModuleData(), FirModuleDataKt.getModuleData(session2))) return true;
            $this$visibility$iv = FirVisibilityCheckerKt.getModuleVisibilityChecker(session2);
            if ($this$visibility$iv == null) {
                return false;
            }
            if (!$this$visibility$iv.isInFriendModule(declaration2)) return false;
            return true;
        }
        if (Intrinsics.areEqual(visibility2, Visibilities.Private.INSTANCE) ? true : Intrinsics.areEqual(visibility2, Visibilities.PrivateToThis.INSTANCE)) {
            ownerId = FirVisibilityCheckerKt.getOwnerId(symbol2);
            if (Intrinsics.areEqual(declaration2.getModuleData(), FirModuleDataKt.getModuleData(session2))) {
                if (ownerId == null) {
                    FirFile firFile;
                    AbstractFirBasedSymbol<?> abstractFirBasedSymbol = symbol2;
                    if (abstractFirBasedSymbol instanceof FirSyntheticFunctionSymbol) {
                        ClassId classId = new ClassId(((FirSyntheticFunctionSymbol)symbol2).getCallableId().getPackageName(), ((FirSyntheticFunctionSymbol)symbol2).getCallableId().getCallableName());
                        firFile = provider2.getFirClassifierContainerFile(classId);
                    } else {
                        firFile = abstractFirBasedSymbol instanceof FirClassLikeSymbol ? provider2.getFirClassifierContainerFileIfAny((FirClassLikeSymbol)symbol2) : (abstractFirBasedSymbol instanceof FirCallableSymbol ? provider2.getFirCallableContainerFile((FirCallableSymbol)symbol2) : null);
                    }
                    FirFile candidateFile = firFile;
                    bl = Intrinsics.areEqual(candidateFile, useSiteFile);
                    return bl;
                }
                if (declaration2 instanceof FirConstructor) {
                    T $this$isFromSealedClass$iv = declaration2;
                    boolean $i$f$isFromSealedClass = false;
                    if ($this$isFromSealedClass$iv.getStatus().isFromSealedClass()) {
                        bl = Intrinsics.areEqual(((FirConstructor)declaration2).getSymbol().getCallableId().getPackageName(), useSiteFile.getPackageFqName());
                        return bl;
                    }
                }
                bl = this.canSeePrivateMemberOf(containingDeclarations, ownerId, session2);
                return bl;
            }
            if (!(declaration2 instanceof FirSimpleFunction)) return false;
            if (!this.isAllowedToBeAccessedFromOutside((FirSimpleFunction)declaration2)) return false;
            return true;
        }
        if (!Intrinsics.areEqual(visibility2, Visibilities.Protected.INSTANCE)) {
            $this$visibility$iv = declaration2;
            $i$f$getVisibility = false;
            bl = this.platformVisibilityCheck($this$visibility$iv.getStatus().getVisibility(), symbol2, useSiteFile, containingDeclarations, dispatchReceiver, session2);
            return bl;
        }
        ownerId = FirVisibilityCheckerKt.getOwnerId(symbol2);
        if (ownerId == null) return false;
        if (!this.canSeeProtectedMemberOf(containingDeclarations, dispatchReceiver, ownerId, session2)) return false;
        return true;
    }

    protected abstract boolean platformVisibilityCheck(@NotNull Visibility var1, @NotNull AbstractFirBasedSymbol<?> var2, @NotNull FirFile var3, @NotNull List<? extends FirDeclaration> var4, @Nullable ReceiverValue var5, @NotNull FirSession var6);

    private final boolean canSeePrivateMemberOf(List<? extends FirDeclaration> containingDeclarationOfUseSite, ClassId ownerId, FirSession session2) {
        ClassId classId = this.ownerIfCompanion(ownerId, session2);
        if (classId != null) {
            ClassId classId2 = classId;
            boolean bl = false;
            boolean bl2 = false;
            ClassId companionOwnerClassId = classId2;
            boolean bl3 = false;
            return this.canSeePrivateMemberOf(containingDeclarationOfUseSite, companionOwnerClassId, session2);
        }
        for (FirDeclaration firDeclaration : containingDeclarationOfUseSite) {
            FirClassSymbol boundSymbol;
            if (!(firDeclaration instanceof FirClass) || !this.isSame((boundSymbol = ((FirClass)firDeclaration).getSymbol()).getClassId(), ownerId)) continue;
            return true;
        }
        return false;
    }

    private final boolean isSame(ClassId $this$isSame, ClassId other) {
        return Intrinsics.areEqual($this$isSame.getPackageFqName(), other.getPackageFqName()) && Intrinsics.areEqual($this$isSame.getRelativeClassName(), other.getRelativeClassName());
    }

    private final ClassId ownerIfCompanion(ClassId $this$ownerIfCompanion, FirSession session2) {
        boolean bl;
        if ($this$ownerIfCompanion.getOuterClassId() == null || $this$ownerIfCompanion.isLocal()) {
            return null;
        }
        FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getSymbolProvider(session2).getClassLikeSymbolByFqName($this$ownerIfCompanion);
        FirRegularClassSymbol ownerSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
        firClassLikeSymbol = $this$ownerIfCompanion.getOuterClassId();
        boolean bl2 = false;
        boolean bl3 = false;
        FirClassLikeSymbol<?> it = firClassLikeSymbol;
        boolean bl4 = false;
        FirRegularClassSymbol firRegularClassSymbol = ownerSymbol;
        if (firRegularClassSymbol == null) {
            bl = false;
        } else {
            FirRegularClass firRegularClass = (FirRegularClass)firRegularClassSymbol.getFir();
            if (firRegularClass == null) {
                bl = false;
            } else {
                FirRegularClass $this$isCompanion$iv = firRegularClass;
                boolean $i$f$isCompanion = false;
                bl = $this$isCompanion$iv.getStatus().isCompanion();
            }
        }
        return bl ? firClassLikeSymbol : null;
    }

    private final boolean canSeeProtectedMemberOf(FirClass<?> containingUseSiteClass, ReceiverValue dispatchReceiver, ClassId ownerId, FirSession session2) {
        ClassId classId;
        ReceiverValue receiverValue = dispatchReceiver;
        if (receiverValue != null && (classId = this.ownerIfCompanion(receiverValue, session2)) != null) {
            ClassId classId2 = classId;
            boolean bl = false;
            boolean bl2 = false;
            ClassId companionOwnerClassId = classId2;
            boolean bl3 = false;
            if (this.isSubClass(containingUseSiteClass, companionOwnerClassId, session2)) {
                return true;
            }
        }
        return this.isSubClass(containingUseSiteClass, ownerId, session2);
    }

    private final boolean isSubClass(FirClass<?> $this$isSubClass, ClassId ownerId, FirSession session2) {
        boolean bl;
        block4: {
            if (this.isSame(FirDeclarationUtilKt.getClassId($this$isSubClass), ownerId)) {
                return true;
            }
            Iterable $this$any$iv = SupertypeUtilsKt.lookupSuperTypes$default($this$isSubClass, true, true, session2, null, false, 48, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassId classId;
                    ConeClassLikeLookupTag coneClassLikeLookupTag;
                    ConeClassLikeType coneClassLikeType;
                    ConeClassLikeType coneClassLikeType2;
                    ConeClassLikeType superType2 = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    ConeClassLikeType coneClassLikeType3 = coneClassLikeType2 = superType2 instanceof ConeClassLikeType ? superType2 : null;
                    if (!(coneClassLikeType2 == null ? false : ((coneClassLikeType = TypeExpansionUtilsKt.fullyExpandedType$default(coneClassLikeType2, session2, null, 2, null)) == null ? false : ((coneClassLikeLookupTag = coneClassLikeType.getLookupTag()) == null ? false : ((classId = coneClassLikeLookupTag.getClassId()) == null ? false : this.isSame(classId, ownerId)))))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final ClassId ownerIfCompanion(ReceiverValue $this$ownerIfCompanion, FirSession session2) {
        ConeClassLikeType coneClassLikeType;
        Object object = $this$ownerIfCompanion;
        Object object2 = object == null ? null : object.getType();
        ConeClassLikeType coneClassLikeType2 = coneClassLikeType = object2 instanceof ConeClassLikeType ? (ConeClassLikeType)object2 : null;
        return coneClassLikeType == null ? null : ((object2 = coneClassLikeType.getLookupTag()) == null ? null : ((object = ((ConeClassLikeLookupTag)object2).getClassId()) == null ? null : this.ownerIfCompanion((ClassId)object, session2)));
    }

    private final boolean isAllowedToBeAccessedFromOutside(FirSimpleFunction $this$isAllowedToBeAccessedFromOutside) {
        FirDeclaration $this$isFromLibrary$iv = $this$isAllowedToBeAccessedFromOutside;
        boolean $i$f$isFromLibrary22 = false;
        if (!Intrinsics.areEqual($this$isFromLibrary$iv.getOrigin(), FirDeclarationOrigin.Library.INSTANCE)) {
            return false;
        }
        String $i$f$isFromLibrary22 = $this$isAllowedToBeAccessedFromOutside.getSymbol().getCallableId().getPackageName().asString();
        Intrinsics.checkNotNullExpressionValue($i$f$isFromLibrary22, "symbol.callableId.packageName.asString()");
        String packageName = $i$f$isFromLibrary22;
        String string2 = $this$isAllowedToBeAccessedFromOutside.getName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "name.asString()");
        String name = string2;
        return Intrinsics.areEqual(packageName, "kotlin.jvm.internal.unsafe") && (Intrinsics.areEqual(name, "monitorEnter") || Intrinsics.areEqual(name, "monitorExit"));
    }

    protected final boolean canSeeProtectedMemberOf(@NotNull List<? extends FirDeclaration> containingDeclarationOfUseSite, @Nullable ReceiverValue dispatchReceiver, @NotNull ClassId ownerId, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(containingDeclarationOfUseSite, "containingDeclarationOfUseSite");
        Intrinsics.checkNotNullParameter(ownerId, "ownerId");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (this.canSeePrivateMemberOf(containingDeclarationOfUseSite, ownerId, session2)) {
            return true;
        }
        for (FirDeclaration firDeclaration : containingDeclarationOfUseSite) {
            FirClassSymbol boundSymbol;
            if (!(firDeclaration instanceof FirClass) || !this.canSeeProtectedMemberOf((FirClass)(boundSymbol = ((FirClass)firDeclaration).getSymbol()).getFir(), dispatchReceiver, ownerId, session2)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected final FqName packageFqName(@NotNull AbstractFirBasedSymbol<?> $this$packageFqName) {
        FqName fqName2;
        Intrinsics.checkNotNullParameter($this$packageFqName, "<this>");
        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = $this$packageFqName;
        if (abstractFirBasedSymbol instanceof FirClassLikeSymbol) {
            FqName fqName3 = ((FirClassLikeSymbol)$this$packageFqName).getClassId().getPackageFqName();
            Intrinsics.checkNotNullExpressionValue(fqName3, "classId.packageFqName");
            fqName2 = fqName3;
        } else if (abstractFirBasedSymbol instanceof FirCallableSymbol) {
            fqName2 = ((FirCallableSymbol)$this$packageFqName).getCallableId().getPackageName();
        } else {
            String string2 = Intrinsics.stringPlus("No package fq name for ", $this$packageFqName);
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return fqName2;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/FirVisibilityChecker$Default;", "Lorg/jetbrains/kotlin/fir/FirVisibilityChecker;", "()V", "platformVisibilityCheck", "", "declarationVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/AbstractFirBasedSymbol;", "useSiteFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "containingDeclarations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "dispatchReceiver", "Lorg/jetbrains/kotlin/fir/resolve/calls/ReceiverValue;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "resolve"})
    public static final class Default
    extends FirVisibilityChecker {
        @NotNull
        public static final Default INSTANCE = new Default();

        private Default() {
        }

        @Override
        protected boolean platformVisibilityCheck(@NotNull Visibility declarationVisibility, @NotNull AbstractFirBasedSymbol<?> symbol2, @NotNull FirFile useSiteFile, @NotNull List<? extends FirDeclaration> containingDeclarations, @Nullable ReceiverValue dispatchReceiver, @NotNull FirSession session2) {
            Intrinsics.checkNotNullParameter(declarationVisibility, "declarationVisibility");
            Intrinsics.checkNotNullParameter(symbol2, "symbol");
            Intrinsics.checkNotNullParameter(useSiteFile, "useSiteFile");
            Intrinsics.checkNotNullParameter(containingDeclarations, "containingDeclarations");
            Intrinsics.checkNotNullParameter(session2, "session");
            return true;
        }
    }
}

