/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extended;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirFakeSourceElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationCheckerUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.syntax.FirDeclarationSyntaxChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.analysis.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtDeclaration;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J(\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0014\u0010\u0015\u001a\u00020\u0006*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u0017H\u0002R\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extended/RedundantVisibilityModifierSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/syntax/FirDeclarationSyntaxChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "()V", "containingPropertyVisibility", "Lorg/jetbrains/kotlin/descriptors/Visibility;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getContainingPropertyVisibility", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;)Lorg/jetbrains/kotlin/descriptors/Visibility;", "checkLightTree", "", "element", "source", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "context", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "findFunctionVisibility", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "implicitVisibility", "visibility", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkers"})
public final class RedundantVisibilityModifierSyntaxChecker
extends FirDeclarationSyntaxChecker<FirDeclaration, KtDeclaration> {
    @NotNull
    public static final RedundantVisibilityModifierSyntaxChecker INSTANCE = new RedundantVisibilityModifierSyntaxChecker();

    private RedundantVisibilityModifierSyntaxChecker() {
    }

    @Override
    public void checkLightTree(@NotNull FirDeclaration element, @NotNull FirSourceElement source, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirMemberDeclaration firMemberDeclaration;
        Visibility visibility2;
        FirDeclaration firDeclaration;
        Visibility implicitVisibility;
        Visibility explicitVisibility;
        block17: {
            LighterASTNode visibilityModifier;
            LighterASTNode lighterASTNode2;
            block18: {
                block19: {
                    Intrinsics.checkNotNullParameter(element, "element");
                    Intrinsics.checkNotNullParameter(source, "source");
                    Intrinsics.checkNotNullParameter(context2, "context");
                    Intrinsics.checkNotNullParameter(reporter, "reporter");
                    if (element instanceof FirConstructor && source.getKind() instanceof FirFakeSourceElementKind) {
                        return;
                    }
                    if (source instanceof FirFakeSourceElement) {
                        return;
                    }
                    if (element instanceof FirMemberDeclaration) break block18;
                    if (!(element instanceof FirPropertyAccessor)) break block19;
                    FirPropertyAccessor $this$visibility$iv = (FirPropertyAccessor)element;
                    boolean $i$f$getVisibility = false;
                    if (Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), this.getContainingPropertyVisibility(context2))) break block18;
                }
                return;
            }
            IElementType iElementType = (lighterASTNode2 = (visibilityModifier = LightTreePositioningStrategiesKt.visibilityModifier(source.getTreeStructure(), source.getLighterASTNode()))) == null ? null : lighterASTNode2.getTokenType();
            KtModifierKeywordToken ktModifierKeywordToken = iElementType instanceof KtModifierKeywordToken ? (KtModifierKeywordToken)iElementType : null;
            explicitVisibility = ktModifierKeywordToken == null ? null : FirHelpersKt.toVisibilityOrNull(ktModifierKeywordToken);
            implicitVisibility = this.implicitVisibility(element, context2);
            CheckerContext $this$findClosest_u24default$iv = context2;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                FirDeclaration firDeclaration2;
                FirDeclaration firDeclaration3;
                FirDeclaration firDeclaration4;
                FirDeclaration firDeclaration5 = it$iv;
                if (!(firDeclaration5 instanceof FirMemberDeclaration)) {
                    firDeclaration5 = null;
                }
                if ((firDeclaration4 = (FirDeclaration)((FirMemberDeclaration)firDeclaration5)) == null) {
                    firDeclaration3 = null;
                } else {
                    FirDeclaration firDeclaration6 = firDeclaration4;
                    boolean bl = false;
                    boolean bl2 = false;
                    FirDeclaration it = firDeclaration6;
                    firDeclaration3 = firDeclaration2 = true ? firDeclaration6 : null;
                }
                if (firDeclaration2 == null) continue;
                firDeclaration = firDeclaration2;
                break block17;
            }
            firDeclaration = null;
        }
        FirMemberDeclaration containingMemberDeclaration = (FirMemberDeclaration)firDeclaration;
        if (Intrinsics.areEqual(explicitVisibility, implicitVisibility)) {
            visibility2 = implicitVisibility;
        } else if (Intrinsics.areEqual(explicitVisibility, Visibilities.Internal.INSTANCE) && ((firMemberDeclaration = containingMemberDeclaration) == null ? false : FirDeclarationCheckerUtilsKt.isLocalMember(firMemberDeclaration))) {
            visibility2 = Visibilities.Internal.INSTANCE;
        } else {
            return;
        }
        Visibility redundantVisibility = visibility2;
        if (Intrinsics.areEqual(redundantVisibility, Visibilities.Public.INSTANCE) && element instanceof FirProperty && LightTreePositioningStrategiesKt.overrideModifier(source.getTreeStructure(), source.getLighterASTNode()) != null && ((FirProperty)element).isVar()) {
            Visibility visibility3;
            firMemberDeclaration = ((FirProperty)element).getSetter();
            if (firMemberDeclaration == null) {
                visibility3 = null;
            } else {
                FirMemberDeclaration $this$visibility$iv = firMemberDeclaration;
                boolean $i$f$getVisibility = false;
                visibility3 = ((FirPropertyAccessor)$this$visibility$iv).getStatus().getVisibility();
            }
            if (Intrinsics.areEqual(visibility3, Visibilities.Public.INSTANCE)) {
                return;
            }
        }
        DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getREDUNDANT_VISIBILITY_MODIFIER(), context2, null, 8, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final Visibility implicitVisibility(FirDeclaration $this$implicitVisibility, CheckerContext context2) {
        Visibility $this$visibility$iv2;
        Visibility visibility2;
        FirDeclaration firDeclaration;
        Visibility visibility3;
        block14: {
            Iterator<FirDeclaration> iterator2;
            if ($this$implicitVisibility instanceof FirPropertyAccessor && ((FirPropertyAccessor)$this$implicitVisibility).isSetter() && ((FirPropertyAccessor)$this$implicitVisibility).getStatus().isOverride()) {
                FirPropertyAccessor $this$visibility$iv2 = (FirPropertyAccessor)$this$implicitVisibility;
                boolean $i$f$getVisibility = false;
                visibility3 = $this$visibility$iv2.getStatus().getVisibility();
                return visibility3;
            }
            if ($this$implicitVisibility instanceof FirPropertyAccessor) {
                CheckerContext $this$findClosest_u24default$iv = context2;
                boolean $i$f$findClosest = false;
                iterator2 = CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations()).iterator();
            } else {
                if ($this$implicitVisibility instanceof FirConstructor) {
                    FirClassLikeDeclaration<?> clazz = FirHelpersKt.getContainingClass((FirSymbolOwner)((Object)$this$implicitVisibility), context2);
                    if (clazz instanceof FirClass && (((FirClass)clazz).getClassKind() == ClassKind.ENUM_CLASS || FirHelpersKt.modality((FirClass)clazz) == Modality.SEALED)) {
                        visibility3 = Visibilities.Private.INSTANCE;
                        return visibility3;
                    }
                    visibility3 = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
                    return visibility3;
                }
                if ($this$implicitVisibility instanceof FirSimpleFunction && CollectionsKt.last(context2.getContainingDeclarations()) instanceof FirClass) {
                    FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)$this$implicitVisibility;
                    boolean $i$f$isOverride = false;
                    if ($this$isOverride$iv.getStatus().isOverride()) {
                        visibility3 = this.findFunctionVisibility((FirSimpleFunction)$this$implicitVisibility, context2);
                        return visibility3;
                    }
                }
                visibility3 = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
                return visibility3;
            }
            while (iterator2.hasNext()) {
                FirDeclaration firDeclaration2;
                FirDeclaration firDeclaration3;
                FirDeclaration firDeclaration4;
                FirDeclaration it$iv = iterator2.next();
                FirDeclaration firDeclaration5 = it$iv;
                if (!(firDeclaration5 instanceof FirProperty)) {
                    firDeclaration5 = null;
                }
                if ((firDeclaration4 = (FirDeclaration)((FirProperty)firDeclaration5)) == null) {
                    firDeclaration3 = null;
                } else {
                    FirDeclaration firDeclaration6 = firDeclaration4;
                    boolean bl = false;
                    boolean bl2 = false;
                    FirDeclaration it = firDeclaration6;
                    firDeclaration3 = firDeclaration2 = firDeclaration6;
                }
                if (firDeclaration2 == null) continue;
                firDeclaration = firDeclaration2;
                break block14;
            }
            firDeclaration = null;
        }
        FirProperty $i$f$getVisibility = (FirProperty)firDeclaration;
        if ($i$f$getVisibility == null) {
            visibility2 = null;
        } else {
            FirMemberDeclaration $this$visibility$iv3 = $i$f$getVisibility;
            boolean $i$f$getVisibility2 = false;
            visibility2 = $this$visibility$iv2 = $this$visibility$iv3.getStatus().getVisibility();
        }
        if ($this$visibility$iv2 == null) {
            visibility3 = Visibilities.INSTANCE.getDEFAULT_VISIBILITY();
            return visibility3;
        }
        visibility3 = $this$visibility$iv2;
        return visibility3;
    }

    private final Visibility findFunctionVisibility(FirSimpleFunction function2, CheckerContext context2) {
        FirClass<?> firClass = FirHelpersKt.findClosestClassOrObject(context2);
        if (firClass == null) {
            return Visibilities.Unknown.INSTANCE;
        }
        FirClass<?> currentClass = firClass;
        List<FirFunctionSymbol<?>> overriddenFunctions2 = FirHelpersKt.overriddenFunctions(function2, currentClass, context2);
        Visibility visibility2 = Visibilities.Private.INSTANCE;
        for (FirFunctionSymbol<?> func : overriddenFunctions2) {
            Integer compareResult;
            Visibility currentVisibility = this.visibility((FirFunction)func.getFir());
            if (currentVisibility == null || (compareResult = Visibilities.INSTANCE.compare(currentVisibility, visibility2)) == null || compareResult <= 0) continue;
            visibility2 = currentVisibility;
        }
        return visibility2;
    }

    private final Visibility visibility(FirFunction<?> $this$visibility) {
        boolean $i$f$getVisibility;
        Object $this$visibility$iv;
        FirMemberDeclaration firMemberDeclaration;
        Object object = $this$visibility.getSymbol().getFir();
        FirMemberDeclaration firMemberDeclaration2 = firMemberDeclaration = object instanceof FirMemberDeclaration ? (FirMemberDeclaration)object : null;
        if (firMemberDeclaration != null) {
            $this$visibility$iv = firMemberDeclaration;
            $i$f$getVisibility = false;
            object = $this$visibility$iv.getStatus().getVisibility();
            if (object != null) {
                $this$visibility$iv = object;
                $i$f$getVisibility = false;
                boolean bl = false;
                Object it = $this$visibility$iv;
                boolean bl2 = false;
                return it;
            }
        }
        object = $this$visibility.getSymbol().getFir();
        FirMemberDeclaration firMemberDeclaration3 = firMemberDeclaration = object instanceof FirPropertyAccessor ? (FirPropertyAccessor)object : null;
        if (firMemberDeclaration != null) {
            $this$visibility$iv = firMemberDeclaration;
            $i$f$getVisibility = false;
            object = ((FirPropertyAccessor)$this$visibility$iv).getStatus().getVisibility();
            if (object != null) {
                Object object2 = object;
                boolean bl = false;
                boolean bl3 = false;
                Object it = object2;
                boolean bl4 = false;
                return it;
            }
        }
        return null;
    }

    private final Visibility getContainingPropertyVisibility(CheckerContext $this$containingPropertyVisibility) {
        Visibility visibility2;
        FirProperty firProperty;
        FirDeclaration firDeclaration = CollectionsKt.last($this$containingPropertyVisibility.getContainingDeclarations());
        FirProperty firProperty2 = firProperty = firDeclaration instanceof FirProperty ? (FirProperty)firDeclaration : null;
        if (firProperty == null) {
            visibility2 = null;
        } else {
            FirMemberDeclaration $this$visibility$iv = firProperty;
            boolean $i$f$getVisibility = false;
            visibility2 = $this$visibility$iv.getStatus().getVisibility();
        }
        return visibility2;
    }
}

