/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.Arrays;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\u0004\u0018\u00010\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "operationSign", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "getOperationSign", "()Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "operationTokenNode", "Lcom/intellij/lang/ASTNode;", "getOperationTokenNode", "()Lcom/intellij/lang/ASTNode;", "receiverExpression", "getReceiverExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;", "selectorExpression", "getSelectorExpression", "getExpression", "afterOperation", "", "psi"})
public interface KtQualifiedExpression
extends KtExpression {
    @NotNull
    public KtExpression getReceiverExpression();

    @Nullable
    public KtExpression getSelectorExpression();

    @NotNull
    public ASTNode getOperationTokenNode();

    @NotNull
    public KtSingleValueToken getOperationSign();

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public static final class DefaultImpls {
        @NotNull
        public static KtExpression getReceiverExpression(@NotNull KtQualifiedExpression this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            KtExpression ktExpression = DefaultImpls.getExpression(this_, false);
            if (ktExpression == null) {
                throw new AssertionError((Object)Intrinsics.stringPlus("No receiver found: ", PsiUtilsKt.getElementTextWithContext(this_)));
            }
            return ktExpression;
        }

        @Nullable
        public static KtExpression getSelectorExpression(@NotNull KtQualifiedExpression this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return DefaultImpls.getExpression(this_, true);
        }

        @NotNull
        public static ASTNode getOperationTokenNode(@NotNull KtQualifiedExpression this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            ASTNode aSTNode = this_.getNode().findChildByType(KtTokens.OPERATIONS);
            if (aSTNode == null) {
                String string2 = "No operation node for " + this_.getNode().getElementType() + ". Children: " + Arrays.toString(this_.getChildren());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            return aSTNode;
        }

        @NotNull
        public static KtSingleValueToken getOperationSign(@NotNull KtQualifiedExpression this_) {
            Intrinsics.checkNotNullParameter(this_, "this");
            return (KtSingleValueToken)this_.getOperationTokenNode().getElementType();
        }

        private static KtExpression getExpression(KtQualifiedExpression this_, boolean afterOperation) {
            KtExpression ktExpression;
            PsiElement psiElement = this_.getOperationTokenNode().getPsi();
            if (psiElement == null) {
                ktExpression = null;
            } else {
                Sequence<PsiElement> sequence2 = PsiUtilsKt.siblings(psiElement, afterOperation, false);
                if (sequence2 == null) {
                    ktExpression = null;
                } else {
                    PsiElement psiElement2;
                    block5: {
                        Sequence<PsiElement> $this$firstIsInstanceOrNull$iv = sequence2;
                        boolean $i$f$firstIsInstanceOrNull = false;
                        Iterator<PsiElement> iterator2 = $this$firstIsInstanceOrNull$iv.iterator();
                        while (iterator2.hasNext()) {
                            PsiElement element$iv = iterator2.next();
                            if (!(element$iv instanceof KtExpression)) continue;
                            psiElement2 = element$iv;
                            break block5;
                        }
                        psiElement2 = null;
                    }
                    ktExpression = (KtExpression)psiElement2;
                }
            }
            return ktExpression;
        }
    }
}

