/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.debugging;

import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

public class DebuggerClassExpressionGenerator
extends OWLAxiomVisitorAdapter {
    @Nonnull
    private final OWLDataFactory dataFactory;
    private OWLClassExpression desc;

    public DebuggerClassExpressionGenerator(@Nonnull OWLDataFactory dataFactory) {
        this.dataFactory = OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
    }

    @Nullable
    public OWLClassExpression getDebuggerClassExpression() {
        return this.desc;
    }

    @Override
    public void visit(@Nonnull OWLSubClassOfAxiom axiom) {
        OWLObjectComplementOf complement = this.dataFactory.getOWLObjectComplementOf(axiom.getSuperClass());
        this.desc = this.dataFactory.getOWLObjectIntersectionOf(CollectionFactory.createSet(new OWLClassExpression[]{axiom.getSubClass(), complement}));
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        OWLDataSomeValuesFrom sub = this.dataFactory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), this.dataFactory.getTopDatatype());
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom(sub, axiom.getDomain());
        ax.accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        OWLObjectSomeValuesFrom sub = this.dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), this.dataFactory.getOWLThing());
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom(sub, axiom.getDomain());
        ax.accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        OWLObjectAllValuesFrom sup = this.dataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)axiom.getRange());
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom(this.dataFactory.getOWLThing(), sup);
        ax.accept(this);
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        OWLNamedIndividual ind = this.dataFactory.getOWLNamedIndividual(IRI.create("http://debugger.com#", "A" + System.nanoTime()));
        OWLObjectHasValue sub = this.dataFactory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getSubProperty(), ind);
        OWLObjectHasValue sup = this.dataFactory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getSuperProperty(), ind);
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom(sub, sup);
        ax.accept(this);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        OWLObjectOneOf sub = this.dataFactory.getOWLObjectOneOf(axiom.getIndividual());
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom(sub, axiom.getClassExpression());
        ax.accept(this);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() == 2 && axiom.getClassExpressions().contains(this.dataFactory.getOWLNothing())) {
            for (OWLClassExpression c : axiom.getClassExpressions()) {
                if (c.isOWLNothing()) continue;
                this.desc = c;
                return;
            }
        }
        Set<OWLClassExpression> clses = axiom.getClassExpressions();
        Iterator<OWLClassExpression> it = clses.iterator();
        OWLClassExpression descC = it.next();
        assert (descC != null);
        OWLObjectComplementOf notC = this.dataFactory.getOWLObjectComplementOf(descC);
        OWLClassExpression descD = it.next();
        assert (descD != null);
        OWLObjectComplementOf notD = this.dataFactory.getOWLObjectComplementOf(descD);
        OWLObjectIntersectionOf left = this.dataFactory.getOWLObjectIntersectionOf(CollectionFactory.createSet(new OWLClassExpression[]{descC, notD}));
        OWLObjectIntersectionOf right = this.dataFactory.getOWLObjectIntersectionOf(CollectionFactory.createSet(new OWLClassExpression[]{notC, descD}));
        this.desc = this.dataFactory.getOWLObjectUnionOf(CollectionFactory.createSet(new OWLObjectIntersectionOf[]{left, right}));
    }
}

