/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.util;

import com.healthmarketscience.jackcess.util.StreamCipherCompat;

public abstract class StreamCipherFactory {
    private static final StreamCipherFactory RC4_ENGINE_FACTORY;

    protected StreamCipherFactory() {
    }

    public static StreamCipherCompat newRC4Engine() {
        return RC4_ENGINE_FACTORY.newInstance();
    }

    private static StreamCipherFactory loadFactory(String className) throws Exception {
        Class<?> factoryClass = Class.forName(className);
        StreamCipherFactory factory = (StreamCipherFactory)factoryClass.newInstance();
        if (factory.newInstance() == null) {
            throw new IllegalStateException("EngineFactory " + className + " not functional");
        }
        return factory;
    }

    public abstract StreamCipherCompat newInstance();

    static {
        StreamCipherFactory factory = null;
        try {
            factory = StreamCipherFactory.loadFactory("com.healthmarketscience.jackcess.util.RC4EngineCompat$Factory");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (factory == null) {
            try {
                factory = StreamCipherFactory.loadFactory("com.healthmarketscience.jackcess.util.RC4EngineLegacy$Factory");
            }
            catch (Exception e) {
                throw new IllegalStateException("Incompatible bouncycastle version", e);
            }
        }
        RC4_ENGINE_FACTORY = factory;
    }
}

