/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.ltr.store;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.solr.ltr.feature.Feature;
import org.apache.solr.ltr.feature.FeatureException;

public class FeatureStore {
    public static final String DEFAULT_FEATURE_STORE_NAME = "_DEFAULT_";
    private final LinkedHashMap<String, Feature> store = new LinkedHashMap();
    private final String name;

    public FeatureStore(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Feature get(String name) {
        return this.store.get(name);
    }

    public void add(Feature feature) {
        String name = feature.getName();
        if (this.store.containsKey(name)) {
            throw new FeatureException(name + " already contained in the store, please use a different name");
        }
        feature.setIndex(this.store.size());
        this.store.put(name, feature);
    }

    public List<Feature> getFeatures() {
        ArrayList<Feature> storeValues = new ArrayList<Feature>(this.store.values());
        return Collections.unmodifiableList(storeValues);
    }

    public String toString() {
        return "FeatureStore [features=" + this.store.keySet() + "]";
    }
}

