/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.function.mapping.BooleanStreamBooleanValueInBooleanStreamOutFunction;
import org.apache.solr.analytics.function.mapping.BooleanStreamInBooleanStreamOutFunction;
import org.apache.solr.analytics.function.mapping.BooleanStreamInBooleanValueOutFunction;
import org.apache.solr.analytics.function.mapping.BooleanValueBooleanStreamInBooleanStreamOutFunction;
import org.apache.solr.analytics.function.mapping.BooleanValueInBooleanValueOutFunction;
import org.apache.solr.analytics.function.mapping.DateStreamDateValueInDateStreamOutFunction;
import org.apache.solr.analytics.function.mapping.DateStreamInDateStreamOutFunction;
import org.apache.solr.analytics.function.mapping.DateStreamInDateValueOutFunction;
import org.apache.solr.analytics.function.mapping.DateValueDateStreamInDateStreamOutFunction;
import org.apache.solr.analytics.function.mapping.DateValueInDateValueOutFunction;
import org.apache.solr.analytics.function.mapping.DoubleStreamDoubleValueInDoubleStreamOutFunction;
import org.apache.solr.analytics.function.mapping.DoubleStreamInDoubleStreamOutFunction;
import org.apache.solr.analytics.function.mapping.DoubleStreamInDoubleValueOutFunction;
import org.apache.solr.analytics.function.mapping.DoubleValueDoubleStreamInDoubleStreamOutFunction;
import org.apache.solr.analytics.function.mapping.DoubleValueInDoubleValueOutFunction;
import org.apache.solr.analytics.function.mapping.FloatStreamFloatValueInFloatStreamOutFunction;
import org.apache.solr.analytics.function.mapping.FloatStreamInFloatStreamOutFunction;
import org.apache.solr.analytics.function.mapping.FloatStreamInFloatValueOutFunction;
import org.apache.solr.analytics.function.mapping.FloatValueFloatStreamInFloatStreamOutFunction;
import org.apache.solr.analytics.function.mapping.FloatValueInFloatValueOutFunction;
import org.apache.solr.analytics.function.mapping.IntStreamInIntStreamOutFunction;
import org.apache.solr.analytics.function.mapping.IntStreamInIntValueOutFunction;
import org.apache.solr.analytics.function.mapping.IntStreamIntValueInIntStreamOutFunction;
import org.apache.solr.analytics.function.mapping.IntValueInIntValueOutFunction;
import org.apache.solr.analytics.function.mapping.IntValueIntStreamInIntStreamOutFunction;
import org.apache.solr.analytics.function.mapping.LongStreamInLongStreamOutFunction;
import org.apache.solr.analytics.function.mapping.LongStreamInLongValueOutFunction;
import org.apache.solr.analytics.function.mapping.LongStreamLongValueInLongStreamOutFunction;
import org.apache.solr.analytics.function.mapping.LongValueInLongValueOutFunction;
import org.apache.solr.analytics.function.mapping.LongValueLongStreamInLongStreamOutFunction;
import org.apache.solr.analytics.function.mapping.MultiBooleanValueInBooleanValueOutRequireAllFunction;
import org.apache.solr.analytics.function.mapping.MultiBooleanValueInBooleanValueOutRequireOneFunction;
import org.apache.solr.analytics.function.mapping.MultiDateValueInDateValueOutRequireAllFunction;
import org.apache.solr.analytics.function.mapping.MultiDateValueInDateValueOutRequireOneFunction;
import org.apache.solr.analytics.function.mapping.MultiDoubleValueInDoubleValueOutRequireAllFunction;
import org.apache.solr.analytics.function.mapping.MultiDoubleValueInDoubleValueOutRequireOneFunction;
import org.apache.solr.analytics.function.mapping.MultiFloatValueInFloatValueOutRequireAllFunction;
import org.apache.solr.analytics.function.mapping.MultiFloatValueInFloatValueOutRequireOneFunction;
import org.apache.solr.analytics.function.mapping.MultiIntValueInIntValueOutRequireAllFunction;
import org.apache.solr.analytics.function.mapping.MultiIntValueInIntValueOutRequireOneFunction;
import org.apache.solr.analytics.function.mapping.MultiLongValueInLongValueOutRequireAllFunction;
import org.apache.solr.analytics.function.mapping.MultiLongValueInLongValueOutRequireOneFunction;
import org.apache.solr.analytics.function.mapping.MultiStringValueInStringValueOutRequireAllFunction;
import org.apache.solr.analytics.function.mapping.MultiStringValueInStringValueOutRequireOneFunction;
import org.apache.solr.analytics.function.mapping.StringStreamInStringStreamOutFunction;
import org.apache.solr.analytics.function.mapping.StringStreamInStringValueOutFunction;
import org.apache.solr.analytics.function.mapping.StringStreamStringValueInStringStreamOutFunction;
import org.apache.solr.analytics.function.mapping.StringValueInStringValueOutFunction;
import org.apache.solr.analytics.function.mapping.StringValueStringStreamInStringStreamOutFunction;
import org.apache.solr.analytics.function.mapping.TwoBooleanValueInBooleanValueOutFunction;
import org.apache.solr.analytics.function.mapping.TwoDateValueInDateValueOutFunction;
import org.apache.solr.analytics.function.mapping.TwoDoubleValueInDoubleValueOutFunction;
import org.apache.solr.analytics.function.mapping.TwoFloatValueInFloatValueOutFunction;
import org.apache.solr.analytics.function.mapping.TwoIntValueInIntValueOutFunction;
import org.apache.solr.analytics.function.mapping.TwoLongValueInLongValueOutFunction;
import org.apache.solr.analytics.function.mapping.TwoStringValueInStringValueOutFunction;
import org.apache.solr.analytics.value.BooleanValue;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DateValue;
import org.apache.solr.analytics.value.DateValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.analytics.value.FloatValue;
import org.apache.solr.analytics.value.FloatValueStream;
import org.apache.solr.analytics.value.IntValue;
import org.apache.solr.analytics.value.IntValueStream;
import org.apache.solr.analytics.value.LongValue;
import org.apache.solr.analytics.value.LongValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;
import org.apache.solr.common.SolrException;

public class LambdaFunction {
    private static final boolean defaultMultiExistsMethod = true;

    public static BooleanValueStream createBooleanLambdaFunction(String name, BoolInBoolOutLambda lambda, BooleanValueStream param) {
        if (param instanceof BooleanValue) {
            return new BooleanValueInBooleanValueOutFunction(name, lambda, (BooleanValue)param);
        }
        return new BooleanStreamInBooleanStreamOutFunction(name, lambda, param);
    }

    public static BooleanValue createBooleanLambdaFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValueStream param) {
        return new BooleanStreamInBooleanValueOutFunction(name, lambda, param);
    }

    public static BooleanValueStream createBooleanLambdaFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValueStream param1, BooleanValueStream param2) throws SolrException {
        if (param1 instanceof BooleanValue && param2 instanceof BooleanValue) {
            return new TwoBooleanValueInBooleanValueOutFunction(name, lambda, (BooleanValue)param1, (BooleanValue)param2);
        }
        if (param1 instanceof BooleanValue) {
            return new BooleanValueBooleanStreamInBooleanStreamOutFunction(name, lambda, (BooleanValue)param1, param2);
        }
        if (param2 instanceof BooleanValue) {
            return new BooleanStreamBooleanValueInBooleanStreamOutFunction(name, lambda, param1, (BooleanValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static BooleanValue createBooleanLambdaFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValue[] params) {
        return LambdaFunction.createBooleanLambdaFunction(name, lambda, params, true);
    }

    public static BooleanValue createBooleanLambdaFunction(String name, TwoBoolInBoolOutLambda lambda, BooleanValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiBooleanValueInBooleanValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiBooleanValueInBooleanValueOutRequireOneFunction(name, lambda, params);
    }

    public static IntValueStream createIntLambdaFunction(String name, IntInIntOutLambda lambda, IntValueStream param) {
        if (param instanceof IntValue) {
            return new IntValueInIntValueOutFunction(name, lambda, (IntValue)param);
        }
        return new IntStreamInIntStreamOutFunction(name, lambda, param);
    }

    public static IntValue createIntLambdaFunction(String name, TwoIntInIntOutLambda lambda, IntValueStream param) {
        return new IntStreamInIntValueOutFunction(name, lambda, param);
    }

    public static IntValueStream createIntLambdaFunction(String name, TwoIntInIntOutLambda lambda, IntValueStream param1, IntValueStream param2) throws SolrException {
        if (param1 instanceof IntValue && param2 instanceof IntValue) {
            return new TwoIntValueInIntValueOutFunction(name, lambda, (IntValue)param1, (IntValue)param2);
        }
        if (param1 instanceof IntValue) {
            return new IntValueIntStreamInIntStreamOutFunction(name, lambda, (IntValue)param1, param2);
        }
        if (param2 instanceof IntValue) {
            return new IntStreamIntValueInIntStreamOutFunction(name, lambda, param1, (IntValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static IntValue createIntLambdaFunction(String name, TwoIntInIntOutLambda lambda, IntValue[] params) {
        return LambdaFunction.createIntLambdaFunction(name, lambda, params, true);
    }

    public static IntValue createIntLambdaFunction(String name, TwoIntInIntOutLambda lambda, IntValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiIntValueInIntValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiIntValueInIntValueOutRequireOneFunction(name, lambda, params);
    }

    public static LongValueStream createLongLambdaFunction(String name, LongInLongOutLambda lambda, LongValueStream param) {
        if (param instanceof LongValue) {
            return new LongValueInLongValueOutFunction(name, lambda, (LongValue)param);
        }
        return new LongStreamInLongStreamOutFunction(name, lambda, param);
    }

    public static LongValue createLongLambdaFunction(String name, TwoLongInLongOutLambda lambda, LongValueStream param) {
        return new LongStreamInLongValueOutFunction(name, lambda, param);
    }

    public static LongValueStream createLongLambdaFunction(String name, TwoLongInLongOutLambda lambda, LongValueStream param1, LongValueStream param2) throws SolrException {
        if (param1 instanceof LongValue && param2 instanceof LongValue) {
            return new TwoLongValueInLongValueOutFunction(name, lambda, (LongValue)param1, (LongValue)param2);
        }
        if (param1 instanceof LongValue) {
            return new LongValueLongStreamInLongStreamOutFunction(name, lambda, (LongValue)param1, param2);
        }
        if (param2 instanceof LongValue) {
            return new LongStreamLongValueInLongStreamOutFunction(name, lambda, param1, (LongValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static LongValue createLongLambdaFunction(String name, TwoLongInLongOutLambda lambda, LongValue[] params) {
        return LambdaFunction.createLongLambdaFunction(name, lambda, params, true);
    }

    public static LongValue createLongLambdaFunction(String name, TwoLongInLongOutLambda lambda, LongValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiLongValueInLongValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiLongValueInLongValueOutRequireOneFunction(name, lambda, params);
    }

    public static FloatValueStream createFloatLambdaFunction(String name, FloatInFloatOutLambda lambda, FloatValueStream param) {
        if (param instanceof FloatValue) {
            return new FloatValueInFloatValueOutFunction(name, lambda, (FloatValue)param);
        }
        return new FloatStreamInFloatStreamOutFunction(name, lambda, param);
    }

    public static FloatValue createFloatLambdaFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValueStream param) {
        return new FloatStreamInFloatValueOutFunction(name, lambda, param);
    }

    public static FloatValueStream createFloatLambdaFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValueStream param1, FloatValueStream param2) throws SolrException {
        if (param1 instanceof FloatValue && param2 instanceof FloatValue) {
            return new TwoFloatValueInFloatValueOutFunction(name, lambda, (FloatValue)param1, (FloatValue)param2);
        }
        if (param1 instanceof FloatValue) {
            return new FloatValueFloatStreamInFloatStreamOutFunction(name, lambda, (FloatValue)param1, param2);
        }
        if (param2 instanceof FloatValue) {
            return new FloatStreamFloatValueInFloatStreamOutFunction(name, lambda, param1, (FloatValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static FloatValue createFloatLambdaFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValue[] params) {
        return LambdaFunction.createFloatLambdaFunction(name, lambda, params, true);
    }

    public static FloatValue createFloatLambdaFunction(String name, TwoFloatInFloatOutLambda lambda, FloatValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiFloatValueInFloatValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiFloatValueInFloatValueOutRequireOneFunction(name, lambda, params);
    }

    public static DoubleValueStream createDoubleLambdaFunction(String name, DoubleInDoubleOutLambda lambda, DoubleValueStream param) {
        if (param instanceof DoubleValue) {
            return new DoubleValueInDoubleValueOutFunction(name, lambda, (DoubleValue)param);
        }
        return new DoubleStreamInDoubleStreamOutFunction(name, lambda, param);
    }

    public static DoubleValue createDoubleLambdaFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValueStream param) {
        return new DoubleStreamInDoubleValueOutFunction(name, lambda, param);
    }

    public static DoubleValueStream createDoubleLambdaFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValueStream param1, DoubleValueStream param2) throws SolrException {
        if (param1 instanceof DoubleValue && param2 instanceof DoubleValue) {
            return new TwoDoubleValueInDoubleValueOutFunction(name, lambda, (DoubleValue)param1, (DoubleValue)param2);
        }
        if (param1 instanceof DoubleValue) {
            return new DoubleValueDoubleStreamInDoubleStreamOutFunction(name, lambda, (DoubleValue)param1, param2);
        }
        if (param2 instanceof DoubleValue) {
            return new DoubleStreamDoubleValueInDoubleStreamOutFunction(name, lambda, param1, (DoubleValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static DoubleValue createDoubleLambdaFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValue[] params) {
        return LambdaFunction.createDoubleLambdaFunction(name, lambda, params, true);
    }

    public static DoubleValue createDoubleLambdaFunction(String name, TwoDoubleInDoubleOutLambda lambda, DoubleValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiDoubleValueInDoubleValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiDoubleValueInDoubleValueOutRequireOneFunction(name, lambda, params);
    }

    public static DateValueStream createDateLambdaFunction(String name, LongInLongOutLambda lambda, DateValueStream param) {
        if (param instanceof DateValue) {
            return new DateValueInDateValueOutFunction(name, lambda, (DateValue)param);
        }
        return new DateStreamInDateStreamOutFunction(name, lambda, param);
    }

    public static DateValue createDateLambdaFunction(String name, TwoLongInLongOutLambda lambda, DateValueStream param) {
        return new DateStreamInDateValueOutFunction(name, lambda, param);
    }

    public static DateValueStream createDateLambdaFunction(String name, TwoLongInLongOutLambda lambda, DateValueStream param1, DateValueStream param2) throws SolrException {
        if (param1 instanceof DateValue && param2 instanceof DateValue) {
            return new TwoDateValueInDateValueOutFunction(name, lambda, (DateValue)param1, (DateValue)param2);
        }
        if (param1 instanceof DateValue) {
            return new DateValueDateStreamInDateStreamOutFunction(name, lambda, (DateValue)param1, param2);
        }
        if (param2 instanceof DateValue) {
            return new DateStreamDateValueInDateStreamOutFunction(name, lambda, param1, (DateValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static DateValue createDateLambdaFunction(String name, TwoLongInLongOutLambda lambda, DateValue[] params) {
        return LambdaFunction.createDateLambdaFunction(name, lambda, params, true);
    }

    public static DateValue createDateLambdaFunction(String name, TwoLongInLongOutLambda lambda, DateValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiDateValueInDateValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiDateValueInDateValueOutRequireOneFunction(name, lambda, params);
    }

    public static StringValueStream createStringLambdaFunction(String name, StringInStringOutLambda lambda, StringValueStream param) {
        if (param instanceof StringValue) {
            return new StringValueInStringValueOutFunction(name, lambda, (StringValue)param);
        }
        return new StringStreamInStringStreamOutFunction(name, lambda, param);
    }

    public static StringValue createStringLambdaFunction(String name, TwoStringInStringOutLambda lambda, StringValueStream param) {
        return new StringStreamInStringValueOutFunction(name, lambda, param);
    }

    public static StringValueStream createStringLambdaFunction(String name, TwoStringInStringOutLambda lambda, StringValueStream param1, StringValueStream param2) throws SolrException {
        if (param1 instanceof StringValue && param2 instanceof StringValue) {
            return new TwoStringValueInStringValueOutFunction(name, lambda, (StringValue)param1, (StringValue)param2);
        }
        if (param1 instanceof StringValue) {
            return new StringValueStringStreamInStringStreamOutFunction(name, lambda, (StringValue)param1, param2);
        }
        if (param2 instanceof StringValue) {
            return new StringStreamStringValueInStringStreamOutFunction(name, lambda, param1, (StringValue)param2);
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "The " + name + " function requires at least 1 single-valued parameter.");
    }

    public static StringValue createStringLambdaFunction(String name, TwoStringInStringOutLambda lambda, StringValue[] params) {
        return LambdaFunction.createStringLambdaFunction(name, lambda, params, true);
    }

    public static StringValue createStringLambdaFunction(String name, TwoStringInStringOutLambda lambda, StringValue[] params, boolean allMustExist) {
        if (allMustExist) {
            return new MultiStringValueInStringValueOutRequireAllFunction(name, lambda, params);
        }
        return new MultiStringValueInStringValueOutRequireOneFunction(name, lambda, params);
    }

    @FunctionalInterface
    public static interface BoolInBoolOutLambda {
        public boolean apply(boolean var1);
    }

    @FunctionalInterface
    public static interface TwoBoolInBoolOutLambda {
        public boolean apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface IntInIntOutLambda {
        public int apply(int var1);
    }

    @FunctionalInterface
    public static interface TwoIntInIntOutLambda {
        public int apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface LongInLongOutLambda {
        public long apply(long var1);
    }

    @FunctionalInterface
    public static interface TwoLongInLongOutLambda {
        public long apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface FloatInFloatOutLambda {
        public float apply(float var1);
    }

    @FunctionalInterface
    public static interface TwoFloatInFloatOutLambda {
        public float apply(float var1, float var2);
    }

    @FunctionalInterface
    public static interface DoubleInDoubleOutLambda {
        public double apply(double var1);
    }

    @FunctionalInterface
    public static interface TwoDoubleInDoubleOutLambda {
        public double apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface StringInStringOutLambda {
        public String apply(String var1);
    }

    @FunctionalInterface
    public static interface TwoStringInStringOutLambda {
        public String apply(String var1, String var2);
    }

    @FunctionalInterface
    public static interface TwoDoubleInStringOutLambda {
        public String apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoFloatInStringOutLambda {
        public String apply(float var1, float var2);
    }

    @FunctionalInterface
    public static interface TwoLongInStringOutLambda {
        public String apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TwoIntInStringOutLambda {
        public String apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface TwoBoolInStringOutLambda {
        public String apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface TwoStringInDoubleOutLambda {
        public double apply(String var1, String var2);
    }

    @FunctionalInterface
    public static interface TwoFloatInDoubleOutLambda {
        public double apply(float var1, float var2);
    }

    @FunctionalInterface
    public static interface TwoLongInDoubleOutLambda {
        public double apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TwoIntInDoubleOutLambda {
        public double apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface TwoBoolInDoubleOutLambda {
        public double apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface TwoStringInFloatOutLambda {
        public float apply(String var1, String var2);
    }

    @FunctionalInterface
    public static interface TwoDoubleInFloatOutLambda {
        public float apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoLongInFloatOutLambda {
        public float apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TwoIntInFloatOutLambda {
        public float apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface TwoBoolInFloatOutLambda {
        public float apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface TwoStringInLongOutLambda {
        public long apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoDoubleInLongOutLambda {
        public long apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoFloatInLongOutLambda {
        public long apply(float var1, float var2);
    }

    @FunctionalInterface
    public static interface TwoIntInLongOutLambda {
        public long apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface TwoBoolInLongOutLambda {
        public long apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface TwoStringInIntOutLambda {
        public int apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoDoubleInIntOutLambda {
        public int apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoFloatInIntOutLambda {
        public int apply(float var1, float var2);
    }

    @FunctionalInterface
    public static interface TwoLongInIntOutLambda {
        public int apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TwoBoolInIntOutLambda {
        public int apply(boolean var1, boolean var2);
    }

    @FunctionalInterface
    public static interface TwoStringInBoolOutLambda {
        public boolean apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoDoubleInBoolOutLambda {
        public boolean apply(double var1, double var3);
    }

    @FunctionalInterface
    public static interface TwoFloatInBoolOutLambda {
        public boolean apply(float var1, float var2);
    }

    @FunctionalInterface
    public static interface TwoLongInBoolOutLambda {
        public boolean apply(long var1, long var3);
    }

    @FunctionalInterface
    public static interface TwoIntInBoolOutLambda {
        public boolean apply(int var1, int var2);
    }

    @FunctionalInterface
    public static interface DoubleInStringOutLambda {
        public String apply(double var1);
    }

    @FunctionalInterface
    public static interface FloatInStringOutLambda {
        public String apply(float var1);
    }

    @FunctionalInterface
    public static interface LongInStringOutLambda {
        public String apply(long var1);
    }

    @FunctionalInterface
    public static interface IntInStringOutLambda {
        public String apply(int var1);
    }

    @FunctionalInterface
    public static interface BoolInStringOutLambda {
        public String apply(boolean var1);
    }

    @FunctionalInterface
    public static interface StringInDoubleOutLambda {
        public double apply(String var1);
    }

    @FunctionalInterface
    public static interface FloatInDoubleOutLambda {
        public double apply(float var1);
    }

    @FunctionalInterface
    public static interface LongInDoubleOutLambda {
        public double apply(long var1);
    }

    @FunctionalInterface
    public static interface IntInDoubleOutLambda {
        public double apply(int var1);
    }

    @FunctionalInterface
    public static interface BoolInDoubleOutLambda {
        public double apply(boolean var1);
    }

    @FunctionalInterface
    public static interface StringInFloatOutLambda {
        public float apply(String var1);
    }

    @FunctionalInterface
    public static interface DoubleInFloatOutLambda {
        public float apply(double var1);
    }

    @FunctionalInterface
    public static interface LongInFloatOutLambda {
        public float apply(long var1);
    }

    @FunctionalInterface
    public static interface IntInFloatOutLambda {
        public float apply(int var1);
    }

    @FunctionalInterface
    public static interface BoolInFloatOutLambda {
        public float apply(boolean var1);
    }

    @FunctionalInterface
    public static interface StringInLongOutLambda {
        public long apply(double var1);
    }

    @FunctionalInterface
    public static interface DoubleInLongOutLambda {
        public long apply(double var1);
    }

    @FunctionalInterface
    public static interface FloatInLongOutLambda {
        public long apply(float var1);
    }

    @FunctionalInterface
    public static interface IntInLongOutLambda {
        public long apply(int var1);
    }

    @FunctionalInterface
    public static interface BoolInLongOutLambda {
        public long apply(boolean var1);
    }

    @FunctionalInterface
    public static interface StringInIntOutLambda {
        public int apply(double var1);
    }

    @FunctionalInterface
    public static interface DoubleInIntOutLambda {
        public int apply(double var1);
    }

    @FunctionalInterface
    public static interface FloatInIntOutLambda {
        public int apply(float var1);
    }

    @FunctionalInterface
    public static interface LongInIntOutLambda {
        public int apply(long var1);
    }

    @FunctionalInterface
    public static interface BoolInIntOutLambda {
        public int apply(boolean var1);
    }

    @FunctionalInterface
    public static interface StringInBoolOutLambda {
        public boolean apply(double var1);
    }

    @FunctionalInterface
    public static interface DoubleInBoolOutLambda {
        public boolean apply(double var1);
    }

    @FunctionalInterface
    public static interface FloatInBoolOutLambda {
        public boolean apply(float var1);
    }

    @FunctionalInterface
    public static interface LongInBoolOutLambda {
        public boolean apply(long var1);
    }

    @FunctionalInterface
    public static interface IntInBoolOutLambda {
        public boolean apply(int var1);
    }
}

