/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db.paros;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DbUtils;
import org.parosproxy.paros.db.RecordSessionUrl;
import org.parosproxy.paros.db.TableSessionUrl;
import org.parosproxy.paros.db.paros.ParosAbstractTable;

public class ParosTableSessionUrl
extends ParosAbstractTable
implements TableSessionUrl {
    private static final String TABLE_NAME = "SESSION_URL";
    private static final String URLID = "URLID";
    private static final String TYPE = "TYPE";
    private static final String URL = "URL";
    private PreparedStatement psRead = null;
    private PreparedStatement psInsert = null;
    private CallableStatement psGetIdLastInsert = null;
    private PreparedStatement psGetAlluRLSForType = null;
    private PreparedStatement psDeleteUrls = null;
    private PreparedStatement psDeleteAllUrlsForType = null;

    @Override
    protected void reconnect(Connection conn) throws DatabaseException {
        try {
            if (!DbUtils.hasTable(conn, TABLE_NAME)) {
                DbUtils.execute(conn, "CREATE cached TABLE SESSION_URL (urlid bigint generated by default as identity (start with 1), type int not null, url varchar(8192) default '')");
            }
            this.psRead = conn.prepareStatement("SELECT * FROM SESSION_URL WHERE URLID = ?");
            this.psInsert = conn.prepareStatement("INSERT INTO SESSION_URL (TYPE,URL) VALUES (?, ?)");
            this.psGetIdLastInsert = conn.prepareCall("CALL IDENTITY();");
            this.psDeleteUrls = conn.prepareStatement("DELETE FROM SESSION_URL WHERE TYPE = ? AND URL = ?");
            this.psDeleteAllUrlsForType = conn.prepareStatement("DELETE FROM SESSION_URL WHERE TYPE = ?");
            this.psGetAlluRLSForType = conn.prepareStatement("SELECT * FROM SESSION_URL WHERE TYPE = ?");
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized RecordSessionUrl read(long urlId) throws DatabaseException {
        try {
            this.psRead.setLong(1, urlId);
            try (ResultSet rs = this.psRead.executeQuery();){
                RecordSessionUrl recordSessionUrl = this.build(rs);
                return recordSessionUrl;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized RecordSessionUrl insert(int type, String url) throws DatabaseException {
        try {
            long id;
            this.psInsert.setInt(1, type);
            this.psInsert.setString(2, url);
            this.psInsert.executeUpdate();
            try (ResultSet rs = this.psGetIdLastInsert.executeQuery();){
                rs.next();
                id = rs.getLong(1);
            }
            return this.read(id);
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void delete(int type, String url) throws DatabaseException {
        try {
            this.psDeleteUrls.setInt(1, type);
            this.psDeleteUrls.setString(2, url);
            this.psDeleteUrls.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public synchronized void deleteAllUrlsForType(int type) throws DatabaseException {
        try {
            this.psDeleteAllUrlsForType.setInt(1, type);
            this.psDeleteAllUrlsForType.executeUpdate();
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized List<RecordSessionUrl> getUrlsForType(int type) throws DatabaseException {
        try {
            this.psGetAlluRLSForType.setInt(1, type);
            try (ResultSet rs = this.psGetAlluRLSForType.executeQuery();){
                ArrayList<RecordSessionUrl> result = new ArrayList<RecordSessionUrl>();
                while (rs.next()) {
                    result.add(new RecordSessionUrl(rs.getLong(URLID), rs.getInt(TYPE), rs.getString(URL)));
                }
                ArrayList<RecordSessionUrl> arrayList = result;
                return arrayList;
            }
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    private RecordSessionUrl build(ResultSet rs) throws DatabaseException {
        try {
            RecordSessionUrl rt = null;
            if (rs.next()) {
                rt = new RecordSessionUrl(rs.getLong(URLID), rs.getInt(TYPE), rs.getString(URL));
            }
            return rt;
        }
        catch (SQLException e) {
            throw new DatabaseException(e);
        }
    }

    @Override
    public void setUrls(int type, List<String> urls) throws DatabaseException {
        this.deleteAllUrlsForType(type);
        for (String url : urls) {
            this.insert(type, url);
        }
    }
}

