/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx.bookmark;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import mediathek.daten.DatenFilm;
import mediathek.javafx.bookmark.BookmarkDateDiff;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BookmarkData {
    private String url;
    private String sender;
    private String titel;
    private String senddate;
    private final BooleanProperty seen = new SimpleBooleanProperty(false);
    private DatenFilm filmdata;
    private String highQualityUrl;
    private String urlKlein;
    private String note;
    private String expiry;
    private boolean willExpire;

    public BookmarkData() {
    }

    public BookmarkData(DatenFilm filmdata) {
        this();
        this.url = filmdata.getUrl();
        this.sender = filmdata.getSender();
        this.titel = filmdata.getTitle();
        this.senddate = filmdata.getSendeDatum();
        this.highQualityUrl = filmdata.getUrlHighQuality();
        this.urlKlein = filmdata.getUrlKlein();
        this.filmdata = filmdata;
        this.willExpire = false;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getSender() {
        return this.sender;
    }

    public void setSender(String url) {
        this.sender = url;
    }

    public String getThema() {
        return this.filmdata != null ? this.filmdata.getThema() : "";
    }

    public void setThema(String url) {
    }

    public String getTitel() {
        return this.titel;
    }

    public void setTitel(String url) {
        this.titel = url;
    }

    public String getDauer() {
        return this.filmdata != null ? this.filmdata.getDauer() : "";
    }

    public void setDauer(String dauer) {
    }

    public String getDescription() {
        return this.filmdata != null ? this.filmdata.getDescription() : "";
    }

    public void setDescription(String description) {
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getExpiry() {
        return this.expiry;
    }

    public void setExpiry(String expiry) {
        this.expiry = expiry;
        this.willExpire = expiry != null && BookmarkDateDiff.getInstance().diff2Today(expiry) < 4L;
    }

    public boolean getSeen() {
        return this.seen.get();
    }

    public void setSeen(boolean seen) {
        this.seen.set(seen);
    }

    public String getSendDate() {
        return this.senddate;
    }

    public void setSendDate(String senddate) {
        this.senddate = senddate;
    }

    public String getHighQualityUrl() {
        return this.highQualityUrl;
    }

    public void setHighQualityUrl(String highQualityUrl) {
        this.highQualityUrl = highQualityUrl;
    }

    public String getUrlKlein() {
        return this.urlKlein;
    }

    public void setUrlKlein(String urlKlein) {
        this.urlKlein = urlKlein;
    }

    @JsonIgnore
    public BooleanProperty getSeenProperty() {
        return this.seen;
    }

    @JsonIgnore
    public boolean hasURL() {
        return this.url != null;
    }

    @JsonIgnore
    public boolean hasWebURL() {
        return this.filmdata != null && !this.filmdata.getWebsiteLink().isEmpty();
    }

    @JsonIgnore
    public boolean isMovie(String url, String sender) {
        return this.url.compareTo(url) == 0 && this.sender.compareTo(sender) == 0;
    }

    @JsonIgnore
    public boolean isNotInFilmList() {
        return this.filmdata == null;
    }

    @JsonIgnore
    public boolean isLiveStream() {
        return this.filmdata != null ? this.filmdata.isLivestream() : false;
    }

    @JsonIgnore
    public void setDatenFilm(DatenFilm filmdata) {
        this.filmdata = filmdata;
    }

    @JsonIgnore
    public DatenFilm getDatenFilm() {
        return this.filmdata;
    }

    @JsonIgnore
    public String getWebUrl() {
        return this.filmdata != null ? this.filmdata.getWebsiteLink() : null;
    }

    @JsonIgnore
    public String getFormattedNote() {
        return this.note != null && !this.note.isEmpty() ? String.format("\n\nAnmerkung:\n%s", this.note) : "";
    }

    @JsonIgnore
    public String getExtendedDescription() {
        if (this.expiry != null && !this.expiry.isEmpty()) {
            return String.format("%s - %s (Verf\u00fcgbar bis %s)\n\n%s%s", this.sender, this.titel, this.expiry, this.getDescription(), this.getFormattedNote());
        }
        return String.format("%s - %s\n\n%s%s", this.sender, this.titel, this.getDescription(), this.getFormattedNote());
    }

    @JsonIgnore
    public DatenFilm getDataAsDatenFilm() {
        DatenFilm Film = this.getDatenFilm();
        if (Film == null) {
            Film = new DatenFilm();
            Film.setThema(this.getThema());
            Film.setTitle(this.getTitel());
            Film.setUrl(this.getUrl());
            Film.setUrlHighQuality(this.getHighQualityUrl());
            Film.setUrlKlein(this.getUrlKlein());
            Film.setSender(this.getSender());
            Film.setDauer(this.getDauer());
        }
        return Film;
    }

    @JsonIgnore
    public boolean willExpire() {
        return this.willExpire;
    }
}

