/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.IOException;
import mediathek.tool.MVHttpClient;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class FileSize {
    public static final int ONE_MiB = 1000000;
    private static final Logger logger = LogManager.getLogger();

    @NotNull
    public static String getFileLengthFromUrl(@NotNull String url) {
        String groesseStr = "";
        HttpUrl okUrl = HttpUrl.parse(url);
        if (okUrl != null) {
            long l = FileSize.getFileSizeFromUrl(okUrl);
            groesseStr = FileSize.convertSize(l);
        }
        return groesseStr;
    }

    @NotNull
    public static String convertSize(long byteLength) {
        String ret = "";
        if (byteLength > 1000000L) {
            ret = String.valueOf(byteLength / 1000000L);
        } else if (byteLength > 0L) {
            ret = "1";
        }
        return ret;
    }

    public static long getContentLength(@NotNull Response response) {
        String sizeStr = response.headers().get("Content-Length");
        long respLength = -1L;
        if (sizeStr != null) {
            try {
                respLength = Long.parseLong(sizeStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return respLength;
    }

    public static long getFileSizeFromUrl(@NotNull HttpUrl url) {
        if (!url.scheme().startsWith("http") || url.encodedPath().endsWith(".m3u8")) {
            return -1L;
        }
        logger.info("Requesting file size for: {}", (Object)url);
        Request request = new Request.Builder().url(url).head().build();
        long respLength = -1L;
        try (Response response = MVHttpClient.getInstance().getReducedTimeOutClient().newCall(request).execute();){
            if (response.isSuccessful()) {
                respLength = FileSize.getContentLength(response);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (respLength < 1000000L) {
            respLength = -1L;
        }
        return respLength;
    }
}

