/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS;

import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.posick.mDNS.Constants;
import net.posick.mDNS.MulticastDNSQuerier;
import net.posick.mDNS.MulticastDNSService;
import net.posick.mDNS.Querier;
import net.posick.mDNS.ServiceInstance;
import net.posick.mDNS.ServiceName;
import net.posick.mDNS.utils.Misc;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Message;
import org.xbill.DNS.MulticastDNSUtils;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

public abstract class MulticastDNSLookupBase
implements Closeable,
Constants {
    protected static final Logger logger = Misc.getLogger(MulticastDNSLookupBase.class.getName(), Options.check("mdns_verbose") || Options.check("verbose"));
    protected static Querier defaultQuerier;
    protected static Name[] defaultSearchPath;
    protected static final Comparator SERVICE_RECORD_SORTER;
    protected Name[] names;
    protected Querier querier = MulticastDNSLookupBase.getDefaultQuerier();
    protected Name[] searchPath = MulticastDNSLookupBase.getDefaultSearchPath();
    protected int type = 255;
    protected Object browseID;
    protected int dclass = 255;
    protected Message[] queries;

    public MulticastDNSLookupBase(Name ... names) throws IOException {
        this(names, 255, 255);
    }

    public MulticastDNSLookupBase(Name[] names, int type) throws IOException {
        this(names, type, 255);
    }

    public MulticastDNSLookupBase(Name[] names, int type, int dclass) throws IOException {
        this();
        this.names = names;
        this.type = type;
        this.dclass = dclass;
        this.buildQueries();
    }

    public MulticastDNSLookupBase(String ... names) throws IOException {
        this(names, 255, 255);
    }

    public MulticastDNSLookupBase(String name, int type) throws IOException {
        this(new String[]{name}, type, 255);
    }

    public MulticastDNSLookupBase(String name, int type, int dclass) throws IOException {
        this(new String[]{name}, type, dclass);
    }

    public MulticastDNSLookupBase(String[] names, int type) throws IOException {
        this(names, type, 255);
    }

    public MulticastDNSLookupBase(String[] names, int type, int dclass) throws IOException {
        this();
        ArrayList<Name> domainNames;
        if (names != null && names.length > 0) {
            domainNames = new ArrayList<Name>();
            for (int index = 0; index < names.length; ++index) {
                if (names[index].endsWith(".")) {
                    try {
                        domainNames.add(new Name(names[index]));
                    }
                    catch (TextParseException e) {
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, "Error parsing \"" + names[index] + "\" - " + e.getMessage(), e);
                    }
                    continue;
                }
                for (int i = 0; i < this.searchPath.length; ++i) {
                    try {
                        domainNames.add(new Name(names[index] + "." + this.searchPath[i]));
                        continue;
                    }
                    catch (TextParseException e) {
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, "Error parsing \"" + names[index] + "." + this.searchPath[i] + "\" - " + e.getMessage(), e);
                    }
                }
            }
        } else {
            throw new UnknownHostException("Invalid Name(s) specified!");
        }
        this.names = domainNames.toArray(new Name[domainNames.size()]);
        this.type = type;
        this.dclass = dclass;
        this.buildQueries();
    }

    protected MulticastDNSLookupBase() throws IOException {
    }

    protected MulticastDNSLookupBase(Message message) throws IOException {
        this();
        Record[] records;
        this.queries = new Message[]{(Message)message.clone()};
        int type = -1;
        int dclass = -1;
        ArrayList<Name> list = new ArrayList<Name>();
        for (Record r : records = MulticastDNSUtils.extractRecords(message, 0)) {
            if (!list.contains(r)) {
                list.add(r.getName());
            }
            type = type < 0 ? r.getType() : 255;
            dclass = dclass < 0 ? r.getDClass() : 255;
        }
        if (list.size() > 0) {
            this.type = type;
            this.dclass = dclass;
            this.names = (Name[])list.toArray(new Record[list.size()]);
        }
    }

    public void addNames(Name[] names) {
        if (names != null && names.length > 0) {
            Name[] temp = this.names;
            Name[] newNames = new Name[temp.length + names.length];
            System.arraycopy(temp, 0, newNames, 0, temp.length);
            System.arraycopy(temp, temp.length, newNames, temp.length, names.length);
            this.names = newNames;
            this.buildQueries();
        }
    }

    public void addNames(String[] names) throws TextParseException {
        if (names != null && names.length > 0) {
            Name[] newnames = new Name[names.length];
            for (int i = 0; i < names.length; ++i) {
                newnames[i] = Name.fromString(names[i], Name.root);
            }
            this.addNames(newnames);
        }
    }

    public void addSearchPath(Name[] searchPath) {
        if (searchPath != null && searchPath.length > 0) {
            Name[] temp = this.searchPath;
            Name[] newNames = new Name[temp.length + searchPath.length];
            System.arraycopy(temp, 0, newNames, 0, temp.length);
            System.arraycopy(temp, temp.length, newNames, temp.length, this.names.length);
            this.searchPath = newNames;
            this.buildQueries();
        }
    }

    public void addSearchPath(String[] searchPath) throws TextParseException {
        if (searchPath != null && searchPath.length > 0) {
            Name[] newnames = new Name[searchPath.length];
            for (int i = 0; i < searchPath.length; ++i) {
                newnames[i] = Name.fromString(searchPath[i], Name.root);
            }
            this.addSearchPath(newnames);
        }
    }

    public Name[] getNames() {
        return this.names;
    }

    public synchronized Querier getQuerier() {
        return this.querier;
    }

    public Name[] getSearchPath() {
        return this.searchPath;
    }

    public void setNames(Name[] names) {
        this.names = names;
        this.buildQueries();
    }

    public void setNames(String[] names) throws TextParseException {
        if (names == null) {
            this.names = null;
            return;
        }
        Name[] newnames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            newnames[i] = Name.fromString(names[i], Name.root);
        }
        this.setNames(newnames);
    }

    public synchronized void setQuerier(Querier querier) {
        this.querier = querier;
    }

    public void setSearchPath(Name[] domains) {
        this.searchPath = domains;
        this.buildQueries();
    }

    public void setSearchPath(String[] domains) throws TextParseException {
        if (domains == null) {
            this.searchPath = null;
            return;
        }
        Name[] newdomains = new Name[domains.length];
        for (int i = 0; i < domains.length; ++i) {
            newdomains[i] = Name.fromString(domains[i], Name.root);
        }
        this.setSearchPath(newdomains);
    }

    protected void buildQueries() {
        if (this.names != null && this.searchPath != null) {
            ArrayList<Name> searchNames = new ArrayList<Name>();
            ArrayList<Message> newQueries = new ArrayList<Message>();
            Message multicastQuery = null;
            for (int index = 0; index < this.names.length; ++index) {
                Name name = this.names[index];
                if (name.isAbsolute()) {
                    if (MulticastDNSService.isMulticastDomain(name)) {
                        if (multicastQuery == null) {
                            multicastQuery = Message.newQuery(Record.newRecord(name, this.type, this.dclass));
                        } else {
                            multicastQuery.addRecord(Record.newRecord(name, this.type, this.dclass), 0);
                        }
                    } else {
                        newQueries.add(Message.newQuery(Record.newRecord(name, this.type, this.dclass)));
                    }
                    searchNames.add(name);
                    continue;
                }
                for (int i = 0; i < this.searchPath.length; ++i) {
                    try {
                        Name absoluteName = Name.concatenate(name, this.searchPath[i]);
                        if (MulticastDNSService.isMulticastDomain(this.searchPath[i])) {
                            if (multicastQuery == null) {
                                multicastQuery = Message.newQuery(Record.newRecord(absoluteName, this.type, this.dclass));
                            } else {
                                multicastQuery.addRecord(Record.newRecord(absoluteName, this.type, this.dclass), 0);
                            }
                        } else {
                            newQueries.add(Message.newQuery(Record.newRecord(absoluteName, this.type, this.dclass)));
                        }
                        searchNames.add(absoluteName);
                        continue;
                    }
                    catch (NameTooLongException e) {
                        if (!logger.isLoggable(Level.FINE)) continue;
                        logger.log(Level.FINE, e.getMessage(), e);
                    }
                }
            }
            if (multicastQuery != null) {
                newQueries.add(multicastQuery);
            }
            this.names = searchNames.toArray(new Name[searchNames.size()]);
            this.queries = newQueries.toArray(new Message[newQueries.size()]);
        }
    }

    public static synchronized Querier getDefaultQuerier() {
        if (defaultQuerier == null) {
            try {
                defaultQuerier = new MulticastDNSQuerier(true, true);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return defaultQuerier;
    }

    public static synchronized Name[] getDefaultSearchPath() {
        if (defaultSearchPath == null) {
            Name[] configuredSearchPath = ResolverConfig.getCurrentConfig().searchPath();
            defaultSearchPath = new Name[(configuredSearchPath != null ? configuredSearchPath.length : 0) + defaultQuerier.getMulticastDomains().length];
            int startPos = 0;
            if (configuredSearchPath != null) {
                defaultSearchPath = new Name[configuredSearchPath.length + defaultQuerier.getMulticastDomains().length];
                System.arraycopy(configuredSearchPath, 0, defaultSearchPath, startPos, configuredSearchPath.length);
                startPos = configuredSearchPath.length;
            } else {
                defaultSearchPath = new Name[defaultQuerier.getMulticastDomains().length];
            }
            System.arraycopy(defaultQuerier.getMulticastDomains(), 0, defaultSearchPath, startPos, defaultQuerier.getMulticastDomains().length);
        }
        return defaultSearchPath;
    }

    public static synchronized void setDefaultQuerier(Querier querier) {
        defaultQuerier = querier;
    }

    public static synchronized void setDefaultSearchPath(Name[] domains) {
        defaultSearchPath = domains;
    }

    public static synchronized void setDefaultSearchPath(String[] domains) throws TextParseException {
        if (domains == null) {
            defaultSearchPath = null;
            return;
        }
        Name[] newdomains = new Name[domains.length];
        for (int i = 0; i < domains.length; ++i) {
            newdomains[i] = Name.fromString(domains[i], Name.root);
        }
        defaultSearchPath = newdomains;
    }

    protected static ServiceInstance[] extractServiceInstances(Message ... messages) {
        Record[] records = null;
        for (Message message : messages) {
            Record[] temp = MulticastDNSUtils.extractRecords(message, 2, 1, 3);
            if (records == null) {
                records = temp;
                continue;
            }
            Record[] old = records;
            records = new Record[records.length + temp.length];
            System.arraycopy(old, 0, records, 0, records.length);
            System.arraycopy(temp, 0, records, records.length, temp.length);
        }
        return MulticastDNSLookupBase.extractServiceInstances(records);
    }

    protected static ServiceInstance[] extractServiceInstances(Record[] records) {
        HashMap<ServiceName, ServiceInstance> services = new HashMap<ServiceName, ServiceInstance>();
        ServiceInstance service = null;
        Arrays.sort(records, SERVICE_RECORD_SORTER);
        for (Record record : records) {
            switch (record.getType()) {
                case 33: {
                    try {
                        service = new ServiceInstance((SRVRecord)record);
                        services.put(service.getName(), service);
                    }
                    catch (TextParseException e) {
                        logger.log(Level.WARNING, "Error processing SRV record \"" + record.getName() + "\" - " + e.getMessage(), e);
                    }
                    break;
                }
                case 12: {
                    PTRRecord ptr = (PTRRecord)record;
                    service = (ServiceInstance)services.get(ptr.getTarget());
                    if (service == null) break;
                    if (ptr.getTTL() > 0L) {
                        service.addPointer(ptr.getName());
                        break;
                    }
                    service.removePointer(ptr.getName());
                    break;
                }
                case 16: {
                    TXTRecord txt = (TXTRecord)record;
                    service = (ServiceInstance)services.get(txt.getName());
                    if (service == null) break;
                    if (txt.getTTL() > 0L) {
                        service.addTextRecords(txt);
                        break;
                    }
                    service.removeTextRecords(txt);
                    break;
                }
                case 1: {
                    ARecord a = (ARecord)record;
                    for (Object o : services.values()) {
                        service = (ServiceInstance)o;
                        if (!a.getName().equals(service.getHost())) continue;
                        if (a.getTTL() > 0L) {
                            service.addAddress(a.getAddress());
                            continue;
                        }
                        service.removeAddress(a.getAddress());
                    }
                    break;
                }
                case 28: {
                    AAAARecord aaaa = (AAAARecord)record;
                    for (Object o : services.values()) {
                        service = (ServiceInstance)o;
                        if (!aaaa.getName().equals(service.getHost())) continue;
                        if (aaaa.getTTL() > 0L) {
                            service.addAddress(aaaa.getAddress());
                            continue;
                        }
                        service.removeAddress(aaaa.getAddress());
                    }
                    break;
                }
            }
            service = null;
        }
        return services.values().toArray(new ServiceInstance[services.size()]);
    }

    static {
        SERVICE_RECORD_SORTER = new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof Record && o2 instanceof Record) {
                    Record thisRecord = (Record)o1;
                    Record thatRecord = (Record)o2;
                    int thisType = thisRecord.getType();
                    int thatType = thatRecord.getType();
                    switch (thisType) {
                        case 33: {
                            return thatType == 33 ? 0 : -1;
                        }
                        case 12: {
                            switch (thatType) {
                                case 33: {
                                    return 1;
                                }
                                case 12: {
                                    return 0;
                                }
                            }
                            return -1;
                        }
                        case 16: {
                            switch (thatType) {
                                case 12: 
                                case 33: {
                                    return 1;
                                }
                                case 16: {
                                    return 0;
                                }
                            }
                            return -1;
                        }
                        case 1: 
                        case 28: {
                            switch (thatType) {
                                case 12: 
                                case 16: 
                                case 33: {
                                    return 1;
                                }
                                case 1: 
                                case 28: {
                                    return 0;
                                }
                            }
                            return -1;
                        }
                        case 47: {
                            switch (thatType) {
                                case 1: 
                                case 12: 
                                case 16: 
                                case 28: 
                                case 33: {
                                    return 1;
                                }
                                case 47: {
                                    return 0;
                                }
                            }
                            return -1;
                        }
                    }
                    return -1;
                }
                return -1;
            }
        };
    }
}

