/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.internal.impl.SimpleLocalRepositoryManager;
import org.eclipse.aether.internal.impl.TrackingFileManager;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.ConfigUtils;

class EnhancedLocalRepositoryManager
extends SimpleLocalRepositoryManager {
    private static final String LOCAL_REPO_ID = "";
    private final String trackingFilename;
    private final TrackingFileManager trackingFileManager;

    EnhancedLocalRepositoryManager(File basedir, RepositorySystemSession session, TrackingFileManager trackingFileManager) {
        super(basedir, "enhanced");
        String filename = ConfigUtils.getString(session, LOCAL_REPO_ID, "aether.enhancedLocalRepository.trackingFilename");
        if (filename.length() <= 0 || filename.contains("/") || filename.contains("\\") || filename.contains("..")) {
            filename = "_remote.repositories";
        }
        this.trackingFilename = filename;
        this.trackingFileManager = Objects.requireNonNull(trackingFileManager);
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        String path2 = this.getPathForArtifact(request.getArtifact(), false);
        File file2 = new File(this.getRepository().getBasedir(), path2);
        LocalArtifactResult result = new LocalArtifactResult(request);
        if (file2.isFile()) {
            result.setFile(file2);
            Properties props = this.readRepos(file2);
            if (props.get(this.getKey(file2, LOCAL_REPO_ID)) != null) {
                result.setAvailable(true);
            } else {
                String context = request.getContext();
                for (RemoteRepository repository : request.getRepositories()) {
                    if (props.get(this.getKey(file2, this.getRepositoryKey(repository, context))) == null) continue;
                    result.setAvailable(true);
                    result.setRepository(repository);
                    break;
                }
                if (!result.isAvailable() && !this.isTracked(props, file2)) {
                    result.setAvailable(true);
                }
            }
        }
        return result;
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        Collection<String> repositories = request.getRepository() == null ? Collections.singleton(LOCAL_REPO_ID) : this.getRepositoryKeys(request.getRepository(), request.getContexts());
        this.addArtifact(request.getArtifact(), repositories, request.getRepository() == null);
    }

    private Collection<String> getRepositoryKeys(RemoteRepository repository, Collection<String> contexts) {
        HashSet<String> keys2 = new HashSet<String>();
        if (contexts != null) {
            for (String context : contexts) {
                keys2.add(this.getRepositoryKey(repository, context));
            }
        }
        return keys2;
    }

    private void addArtifact(Artifact artifact, Collection<String> repositories, boolean local) {
        String path2 = this.getPathForArtifact(Objects.requireNonNull(artifact, "artifact cannot be null"), local);
        File file2 = new File(this.getRepository().getBasedir(), path2);
        this.addRepo(file2, repositories);
    }

    private Properties readRepos(File artifactFile) {
        File trackingFile = this.getTrackingFile(artifactFile);
        Properties props = this.trackingFileManager.read(trackingFile);
        return props != null ? props : new Properties();
    }

    private void addRepo(File artifactFile, Collection<String> repositories) {
        HashMap<String, String> updates = new HashMap<String, String>();
        for (String repository : repositories) {
            updates.put(this.getKey(artifactFile, repository), LOCAL_REPO_ID);
        }
        File trackingFile = this.getTrackingFile(artifactFile);
        this.trackingFileManager.update(trackingFile, updates);
    }

    private File getTrackingFile(File artifactFile) {
        return new File(artifactFile.getParentFile(), this.trackingFilename);
    }

    private String getKey(File file2, String repository) {
        return file2.getName() + '>' + repository;
    }

    private boolean isTracked(Properties props, File file2) {
        if (props != null) {
            String keyPrefix = file2.getName() + '>';
            for (Object key2 : props.keySet()) {
                if (!key2.toString().startsWith(keyPrefix)) continue;
                return true;
            }
        }
        return false;
    }
}

