/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerDateModel;
import javax.swing.SwingWorker;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.MVConfig;
import mediathek.daten.DatenDownload;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.javafx.AppTerminationIndefiniteProgress;
import mediathek.tool.EscapeKeyHandler;

public class DialogBeendenZeit
extends JDialog {
    private static final String WAIT_FOR_DOWNLOADS_AND_TERMINATE = "Auf Abschlu\u00df aller Downloads warten und danach Programm beenden";
    private static final String WAIT_FOR_DOWNLOADS_AND_DONT_TERMINATE_PROGRAM = "Auf Abschlu\u00df aller Downloads warten, Programm danach NICHT beenden";
    private static final String DONT_START = "Downloads nicht starten";
    private final JFrame frameParent;
    private final Daten daten;
    private final ArrayList<DatenDownload> listeDownloadsStarten;
    private boolean applicationCanTerminate = false;
    private boolean shutdown = false;
    private JPanel glassPane = null;
    private AppTerminationIndefiniteProgress progressPanel;
    private SwingWorker<Void, Void> downloadMonitorWorker = null;
    private JButton btnCancel;
    private JButton btnContinue;
    private JCheckBox cbShutdownComputer;
    private JComboBox<String> comboActions;
    private JButton jButtonHilfe;
    private JSpinner jSpinnerTime;

    public boolean applicationCanTerminate() {
        return this.applicationCanTerminate;
    }

    public boolean isShutdownRequested() {
        return this.shutdown;
    }

    public DialogBeendenZeit(JFrame pparent, Daten daten_, ArrayList<DatenDownload> listeDownloadsStarten_) {
        super((Frame)pparent, true);
        this.initComponents();
        this.frameParent = pparent;
        this.daten = daten_;
        this.listeDownloadsStarten = listeDownloadsStarten_;
        this.setTitle("Zeitverz\u00f6gerter Download-Start");
        if (this.frameParent != null) {
            this.setLocationRelativeTo(this.frameParent);
        }
        EscapeKeyHandler.installHandler(this, this::escapeHandler);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DialogBeendenZeit.this.escapeHandler();
            }
        });
        Calendar cal = Calendar.getInstance();
        cal.add(12, 1);
        Date startDate = cal.getTime();
        cal.add(12, 60);
        Date now = cal.getTime();
        cal.add(5, 2);
        Date endDate = cal.getTime();
        SpinnerDateModel model = new SpinnerDateModel(now, startDate, endDate, 12);
        if (!MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_STARTEN_ZEIT).isEmpty()) {
            try {
                Object heute = new SimpleDateFormat("yyyyMMdd").format(new Date());
                heute = (String)heute + MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_STARTEN_ZEIT);
                Date start = new SimpleDateFormat("yyyyMMddHH:mm").parse((String)heute);
                if (start.after(startDate)) {
                    model = new SpinnerDateModel(start, startDate, endDate, 12);
                } else {
                    start = new Date(start.getTime() + 86400000L);
                    model = new SpinnerDateModel(start, startDate, endDate, 12);
                }
            }
            catch (Exception heute) {
                // empty catch block
            }
        }
        this.jSpinnerTime.setModel(model);
        JSpinner.DateEditor dEditor = new JSpinner.DateEditor(this.jSpinnerTime, "dd.MM.yyy  HH:mm");
        this.jSpinnerTime.setEditor(dEditor);
        this.comboActions.setModel(this.getComboBoxModel());
        this.comboActions.addActionListener(e -> this.setCbShutdownCoputer());
        this.jButtonHilfe.setIcon(Icons.ICON_BUTTON_HELP);
        this.jButtonHilfe.addActionListener(e -> new DialogHilfe(this.frameParent, true, new GetFile().getHilfeSuchen("/mediathek/file/hilfetext_beenden.txt")).setVisible(true));
        this.setCbShutdownCoputer();
        this.cbShutdownComputer.addActionListener(e -> {
            this.shutdown = this.cbShutdownComputer.isSelected();
        });
        this.cbShutdownComputer.setSelected(Boolean.parseBoolean(MVConfig.get(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_SHUTDOWN)));
        this.btnContinue.addActionListener(e -> {
            String strSelectedItem = Objects.requireNonNull(this.comboActions.getSelectedItem()).toString();
            MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_SHUTDOWN, String.valueOf(this.cbShutdownComputer.isSelected()));
            SimpleDateFormat format = ((JSpinner.DateEditor)this.jSpinnerTime.getEditor()).getFormat();
            format.applyPattern("HH:mm");
            Date sp = (Date)this.jSpinnerTime.getValue();
            String strDate = format.format(sp);
            MVConfig.add(MVConfig.Configs.SYSTEM_DIALOG_DOWNLOAD_STARTEN_ZEIT, strDate);
            switch (strSelectedItem) {
                case "Auf Abschlu\u00df aller Downloads warten und danach Programm beenden": {
                    this.applicationCanTerminate = true;
                    this.waitUntilDownloadsHaveFinished();
                    break;
                }
                case "Auf Abschlu\u00df aller Downloads warten, Programm danach NICHT beenden": {
                    this.applicationCanTerminate = false;
                    this.waitUntilDownloadsHaveFinished();
                    break;
                }
                case "Downloads nicht starten": {
                    this.applicationCanTerminate = false;
                    this.dispose();
                }
            }
        });
        this.btnCancel.addActionListener(e -> this.escapeHandler());
        this.pack();
        this.getRootPane().setDefaultButton(this.btnContinue);
    }

    private void setCbShutdownCoputer() {
        String strSelectedItem = (String)this.comboActions.getSelectedItem();
        if (WAIT_FOR_DOWNLOADS_AND_TERMINATE.equals(strSelectedItem)) {
            this.cbShutdownComputer.setEnabled(true);
        } else {
            this.cbShutdownComputer.setEnabled(false);
            this.cbShutdownComputer.setSelected(false);
            this.shutdown = false;
        }
    }

    private DefaultComboBoxModel<String> getComboBoxModel() {
        return new DefaultComboBoxModel<String>(new String[]{WAIT_FOR_DOWNLOADS_AND_TERMINATE, WAIT_FOR_DOWNLOADS_AND_DONT_TERMINATE_PROGRAM, DONT_START});
    }

    private void escapeHandler() {
        if (this.downloadMonitorWorker != null) {
            this.downloadMonitorWorker.cancel(true);
        }
        if (this.glassPane != null) {
            this.glassPane.setVisible(false);
        }
        this.applicationCanTerminate = false;
        this.dispose();
    }

    private JPanel createGlassPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(5, 5));
        this.progressPanel = new AppTerminationIndefiniteProgress(this.isShutdownRequested());
        panel.add((Component)this.progressPanel, "Center");
        return panel;
    }

    private void setTextWait() {
        SimpleDateFormat format = ((JSpinner.DateEditor)this.jSpinnerTime.getEditor()).getFormat();
        format.applyPattern("dd.MM.yyy  HH:mm");
        Date sp = (Date)this.jSpinnerTime.getValue();
        String strDate = format.format(sp);
        String strMessage = "Downloads starten:" + strDate;
        this.progressPanel.setMessage(strMessage);
    }

    private void waitUntilDownloadsHaveFinished() {
        this.glassPane = this.createGlassPane();
        this.setGlassPane(this.glassPane);
        this.setTextWait();
        this.glassPane.setVisible(true);
        this.downloadMonitorWorker = new SwingWorker<Void, Void>(){

            @Override
            protected Void doInBackground() throws Exception {
                while (((Date)DialogBeendenZeit.this.jSpinnerTime.getValue()).after(new Date())) {
                    TimeUnit.SECONDS.sleep(1L);
                }
                DialogBeendenZeit.this.progressPanel.setMessage("Warte auf Abschluss der Downloads...");
                DatenDownload.startenDownloads(DialogBeendenZeit.this.listeDownloadsStarten);
                while (Daten.getInstance().getListeDownloads().unfinishedDownloads() > 0L && !this.isCancelled()) {
                    TimeUnit.SECONDS.sleep(1L);
                }
                return null;
            }

            @Override
            protected void done() {
                DialogBeendenZeit.this.glassPane.setVisible(false);
                DialogBeendenZeit.this.dispose();
                DialogBeendenZeit.this.downloadMonitorWorker = null;
            }
        };
        this.downloadMonitorWorker.execute();
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.comboActions = new JComboBox();
        this.btnContinue = new JButton();
        this.cbShutdownComputer = new JCheckBox();
        this.btnCancel = new JButton();
        this.jButtonHilfe = new JButton();
        JLabel jLabel2 = new JLabel();
        this.jSpinnerTime = new JSpinner();
        JLabel jLabel3 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        jLabel1.setText("<html>Wie m\u00f6chten Sie fortfahren<br>\nwenn alle Downloads fertig sind?</html>");
        this.btnContinue.setText("Weiter");
        this.cbShutdownComputer.setText("Rechner herunterfahren");
        this.btnCancel.setText("Zur\u00fcck");
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfe.setToolTipText("Hilfe anzeigen");
        jLabel2.setText("alle Downloads starten um: ");
        jLabel3.setText("Uhr");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel1, -1, 551, Short.MAX_VALUE).addComponent(this.comboActions, 0, 0, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonHilfe).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnContinue)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbShutdownComputer).addGroup(layout.createSequentialGroup().addComponent(jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerTime, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel3))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.jSpinnerTime, -2, -1, -2).addComponent(jLabel3)).addGap(18, 18, Short.MAX_VALUE).addComponent(jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.comboActions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.cbShutdownComputer).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnContinue).addComponent(this.btnCancel))).addComponent(this.jButtonHilfe)).addContainerGap()));
        this.pack();
    }
}

