/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import mediathek.config.Daten;
import mediathek.config.Icons;
import mediathek.config.MVColor;
import mediathek.daten.DatenAbo;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogAboNoSet;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVMessageDialog;

public class DialogEditAbo
extends JDialog {
    private final DatenAbo aktAbo;
    private JTextField[] textfeldListe;
    private final JComboBox<String> comboboxPSet = new JComboBox();
    private final JComboBox<String> comboboxSender = new JComboBox();
    private final JComboBox<String> comboboxPfad = new JComboBox();
    private final JCheckBox checkBoxEingeschaltet = new JCheckBox();
    private final JRadioButton rbMin = new JRadioButton("Mindestdauer");
    private final JRadioButton rbMax = new JRadioButton("Maximaldauer");
    private final JSlider sliderDauer = new JSlider(0, 100, 0);
    private final JLabel labelDauer = new JLabel("0");
    private final boolean change;
    public boolean ok = false;
    public boolean[] ch = new boolean[13];
    private JButton jButtonAbbrechen;
    private JButton jButtonBeenden;
    private JButton jButtonHelp;
    private JPanel jPanelExtra;
    private JScrollPane jScrollPane1;

    public DialogEditAbo(JFrame parent, boolean modal, DatenAbo aktA, boolean change) {
        super((Frame)parent, modal);
        this.initComponents();
        Daten daten = Daten.getInstance();
        this.change = change;
        this.aktAbo = aktA;
        ButtonGroup gr = new ButtonGroup();
        gr.add(this.rbMin);
        gr.add(this.rbMax);
        for (boolean b : this.ch) {
            b = false;
        }
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        this.comboboxPSet.setModel(new DefaultComboBoxModel<String>(Daten.listePset.getListeAbo().getObjectDataCombo()));
        this.comboboxSender.setModel(GuiFunktionen.getSenderListComboBoxModel(Daten.getInstance().getListeFilme()));
        ArrayList<String> pfade = daten.getListeAbo().getPfade();
        if (!pfade.contains(this.aktAbo.arr[10])) {
            pfade.add(0, this.aktAbo.arr[10]);
        }
        this.comboboxPfad.setModel(new DefaultComboBoxModel<String>(pfade.toArray(new String[0])));
        this.comboboxPfad.setEditable(true);
        this.checkPfad();
        ((JTextComponent)this.comboboxPfad.getEditor().getEditorComponent()).setOpaque(true);
        ((JTextComponent)this.comboboxPfad.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DialogEditAbo.this.checkPfad();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DialogEditAbo.this.checkPfad();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DialogEditAbo.this.checkPfad();
            }
        });
        this.jButtonBeenden.addActionListener(e -> {
            if (this.check()) {
                this.beenden();
            } else {
                MVMessageDialog.showMessageDialog(parent, "Filter angeben!", "Leeres Abo", 0);
            }
        });
        this.jButtonAbbrechen.addActionListener(e -> this.beenden());
        this.getRootPane().setDefaultButton(this.jButtonBeenden);
        EscapeKeyHandler.installHandler(this, this::dispose);
        this.jButtonHelp.setIcon(Icons.ICON_BUTTON_HELP);
        this.jButtonHelp.addActionListener(e -> new DialogHilfe(parent, true, new GetFile().getHilfeSuchen("hilfetext_dialog_add_abo.txt")).setVisible(true));
        if (this.comboboxPSet.getModel().getSize() == 0) {
            new DialogAboNoSet(parent).setVisible(true);
        } else {
            this.setExtra();
            this.pack();
        }
    }

    @Override
    public void setVisible(boolean vis) {
        if (this.comboboxPSet.getModel().getSize() == 0) {
            this.beenden();
        } else {
            super.setVisible(vis);
        }
    }

    private void checkPfad() {
        String s2 = ((JTextComponent)this.comboboxPfad.getEditor().getEditorComponent()).getText();
        if (!s2.equals(FilenameUtils.checkDateiname(s2, false))) {
            this.comboboxPfad.getEditor().getEditorComponent().setBackground(MVColor.DOWNLOAD_FEHLER.color);
        } else {
            this.comboboxPfad.getEditor().getEditorComponent().setBackground(Color.WHITE);
        }
    }

    private void setExtra() {
        this.textfeldListe = new JTextField[13];
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 10, 10, 5);
        this.jPanelExtra.setLayout(gridbag);
        int zeile = 1;
        if (this.change) {
            c.gridx = 2;
            c.weightx = 1.0;
            JLabel label = new JLabel("<html><style type=\"text/css\"> p { text-align: center; }</style><p>bei allen<br />\u00e4ndern</p></html>");
            label.setBorder(new CompoundBorder(BorderFactory.createLineBorder(new Color(204, 204, 255), 4, true), new EmptyBorder(5, 5, 5, 5)));
            gridbag.setConstraints(label, c);
            this.jPanelExtra.add(label);
            c.gridy = 1;
        } else {
            zeile = 0;
            c.gridy = 0;
        }
        for (int i = 0; i < 13; ++i) {
            c.fill = 2;
            c.anchor = 17;
            this.addExtraFeld(i, gridbag, c, this.jPanelExtra);
            c.gridy = ++zeile;
        }
    }

    private void addExtraFeld(int i, GridBagLayout gridbag, GridBagConstraints c, JPanel panel) {
        JLabel label;
        c.gridx = 0;
        c.weightx = 0.0;
        switch (i) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                label = new JLabel("  " + DatenAbo.COLUMN_NAMES[i] + ": ");
                label.setForeground(Color.BLUE);
                break;
            }
            case 8: {
                label = new JLabel("Dauer [min]: ");
                break;
            }
            default: {
                label = new JLabel(DatenAbo.COLUMN_NAMES[i] + ": ");
            }
        }
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridx = 1;
        c.weightx = 10.0;
        switch (i) {
            case 0: {
                JTextField textfeld;
                this.textfeldListe[i] = textfeld = new JTextField();
                textfeld.setEditable(false);
                textfeld.setText("" + this.aktAbo.getNr());
                gridbag.setConstraints(textfeld, c);
                panel.add(textfeld);
                break;
            }
            case 12: {
                this.comboboxPSet.setSelectedItem(this.aktAbo.arr[i]);
                this.aktAbo.arr[12] = this.comboboxPSet.getSelectedItem().toString();
                gridbag.setConstraints(this.comboboxPSet, c);
                panel.add(this.comboboxPSet);
                break;
            }
            case 3: {
                this.comboboxSender.setSelectedItem(this.aktAbo.arr[i]);
                gridbag.setConstraints(this.comboboxSender, c);
                panel.add(this.comboboxSender);
                break;
            }
            case 10: {
                this.comboboxPfad.setSelectedItem(this.aktAbo.arr[i]);
                gridbag.setConstraints(this.comboboxPfad, c);
                panel.add(this.comboboxPfad);
                break;
            }
            case 8: {
                this.sliderDauer.setValue(this.aktAbo.mindestdauerMinuten);
                this.labelDauer.setText(String.valueOf(this.aktAbo.mindestdauerMinuten == 0 ? " alles " : Integer.valueOf(this.aktAbo.mindestdauerMinuten)));
                this.sliderDauer.addChangeListener(e -> this.labelDauer.setText("  " + (Serializable)(this.sliderDauer.getValue() == 0 ? "alles" : Integer.valueOf(this.sliderDauer.getValue())) + " "));
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)this.sliderDauer, "Center");
                p.add((Component)this.labelDauer, "East");
                gridbag.setConstraints(p, c);
                panel.add(p);
                break;
            }
            case 1: {
                this.checkBoxEingeschaltet.setSelected(Boolean.parseBoolean(this.aktAbo.arr[i]));
                gridbag.setConstraints(this.checkBoxEingeschaltet, c);
                panel.add(this.checkBoxEingeschaltet);
                break;
            }
            case 9: {
                this.rbMin.setSelected(this.aktAbo.min);
                this.rbMax.setSelected(!this.aktAbo.min);
                JPanel p = new JPanel(new BorderLayout());
                p.add((Component)this.rbMin, "North");
                p.add((Component)this.rbMax, "Center");
                gridbag.setConstraints(p, c);
                panel.add(p);
                break;
            }
            default: {
                JTextField textfeld;
                this.textfeldListe[i] = textfeld = new JTextField();
                if (i == 11) {
                    textfeld.setEditable(false);
                } else if (i == 2) {
                    textfeld.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            DialogEditAbo.this.textfeldListe[2].setBackground(DialogEditAbo.this.textfeldListe[2].getText().isEmpty() ? Color.red : Color.white);
                            DialogEditAbo.this.jButtonBeenden.setEnabled(!DialogEditAbo.this.textfeldListe[2].getText().isEmpty());
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            DialogEditAbo.this.textfeldListe[2].setBackground(DialogEditAbo.this.textfeldListe[2].getText().isEmpty() ? Color.red : Color.white);
                            DialogEditAbo.this.jButtonBeenden.setEnabled(!DialogEditAbo.this.textfeldListe[2].getText().isEmpty());
                        }

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            DialogEditAbo.this.textfeldListe[2].setBackground(DialogEditAbo.this.textfeldListe[2].getText().isEmpty() ? Color.red : Color.white);
                            DialogEditAbo.this.jButtonBeenden.setEnabled(!DialogEditAbo.this.textfeldListe[2].getText().isEmpty());
                        }
                    });
                }
                textfeld.setText(this.aktAbo.arr[i]);
                gridbag.setConstraints(textfeld, c);
                panel.add(textfeld);
            }
        }
        if (this.change) {
            c.gridx = 2;
            c.weightx = 0.0;
            switch (i) {
                case 1: 
                case 8: 
                case 9: 
                case 10: 
                case 12: {
                    c.fill = 0;
                    c.anchor = 10;
                    JCheckBox jcb = new JCheckBox();
                    jcb.setBorder(new EmptyBorder(5, 5, 5, 5));
                    jcb.setHorizontalTextPosition(0);
                    jcb.addActionListener(l -> {
                        this.ch[i] = jcb.isSelected();
                    });
                    jcb.setBackground(new Color(204, 204, 255));
                    gridbag.setConstraints(jcb, c);
                    panel.add(jcb);
                }
            }
        }
    }

    private boolean check() {
        DatenAbo test = this.aktAbo.getCopy();
        this.get(test);
        if (test.isEmpty()) {
            this.ok = false;
        } else {
            this.get(this.aktAbo);
            this.ok = true;
        }
        return this.ok;
    }

    private void get(DatenAbo abo) {
        block9: for (int i = 0; i < 13; ++i) {
            switch (i) {
                case 10: {
                    abo.arr[10] = this.comboboxPfad.getSelectedItem().toString();
                    continue block9;
                }
                case 12: {
                    abo.arr[12] = this.comboboxPSet.getSelectedItem().toString();
                    continue block9;
                }
                case 3: {
                    abo.arr[3] = this.comboboxSender.getSelectedItem().toString();
                    continue block9;
                }
                case 1: {
                    abo.arr[1] = Boolean.toString(this.checkBoxEingeschaltet.isSelected());
                    continue block9;
                }
                case 9: {
                    abo.arr[9] = Boolean.toString(this.rbMin.isSelected());
                    abo.min = this.rbMin.isSelected();
                    continue block9;
                }
                case 8: {
                    abo.setMindestDauerMinuten(this.sliderDauer.getValue());
                    continue block9;
                }
                case 0: 
                case 11: {
                    continue block9;
                }
                default: {
                    abo.arr[i] = this.textfeldListe[i].getText().trim();
                }
            }
        }
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanelExtra = new JPanel();
        this.jButtonAbbrechen = new JButton();
        this.jButtonBeenden = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanelExtra);
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jButtonBeenden.setText("Ok");
        this.jButtonHelp.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHelp.setToolTipText("Hilfe anzeigen");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonBeenden, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbbrechen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp))).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonBeenden);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonBeenden).addComponent(this.jButtonAbbrechen).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }
}

