/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.edit;

import gnu.trove.TLongCollection;
import gnu.trove.list.array.TLongArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OsmMapUtils;

public class Way
extends Entity {
    private TLongArrayList nodeIds = null;
    private List<Node> nodes = null;

    public Way(long id2) {
        super(id2);
    }

    public Way(Way w) {
        super(w.getId());
        if (w.nodeIds != null) {
            this.nodeIds = new TLongArrayList((TLongCollection)w.nodeIds);
        }
        if (w.nodes != null) {
            this.nodes = new ArrayList<Node>(w.nodes);
        }
    }

    public Way(long id2, List<Node> nodes) {
        super(id2);
        this.nodes = new ArrayList<Node>(nodes);
        this.nodeIds = new TLongArrayList(nodes.size());
        for (Node n : nodes) {
            this.nodeIds.add(n.getId());
        }
    }

    public void addNode(long id2) {
        if (this.nodeIds == null) {
            this.nodeIds = new TLongArrayList();
        }
        this.nodeIds.add(id2);
    }

    public long getFirstNodeId() {
        if (this.nodeIds == null) {
            return -1L;
        }
        return this.nodeIds.get(0);
    }

    public long getLastNodeId() {
        if (this.nodeIds == null) {
            return -1L;
        }
        return this.nodeIds.get(this.nodeIds.size() - 1);
    }

    public Node getFirstNode() {
        if (this.nodes == null || this.nodes.size() == 0) {
            return null;
        }
        return this.nodes.get(0);
    }

    public Node getLastNode() {
        if (this.nodes == null || this.nodes.size() == 0) {
            return null;
        }
        return this.nodes.get(this.nodes.size() - 1);
    }

    public void addNode(Node n) {
        if (this.nodeIds == null) {
            this.nodeIds = new TLongArrayList();
        }
        if (this.nodes == null) {
            this.nodes = new ArrayList<Node>();
        }
        this.nodeIds.add(n.getId());
        this.nodes.add(n);
    }

    public void addNode(Node n, int index) {
        if (this.nodeIds == null) {
            this.nodeIds = new TLongArrayList();
        }
        if (this.nodes == null) {
            this.nodes = new ArrayList<Node>();
        }
        this.nodeIds.insert(index, n.getId());
        this.nodes.add(index, n);
    }

    public long removeNodeByIndex(int i) {
        if (this.nodeIds == null) {
            return -1L;
        }
        long toReturn = this.nodeIds.removeAt(i);
        if (this.nodes != null && this.nodes.size() > i) {
            this.nodes.remove(i);
        }
        return toReturn;
    }

    public TLongArrayList getNodeIds() {
        if (this.nodeIds == null) {
            return new TLongArrayList(0);
        }
        return this.nodeIds;
    }

    public List<Entity.EntityId> getEntityIds() {
        if (this.nodeIds == null) {
            return Collections.emptyList();
        }
        ArrayList<Entity.EntityId> ls = new ArrayList<Entity.EntityId>();
        for (int i = 0; i < this.nodeIds.size(); ++i) {
            ls.add(new Entity.EntityId(Entity.EntityType.NODE, this.nodeIds.get(i)));
        }
        return ls;
    }

    public List<Node> getNodes() {
        if (this.nodes == null) {
            return Collections.emptyList();
        }
        return this.nodes;
    }

    @Override
    public void initializeLinks(Map<Entity.EntityId, Entity> entities) {
        if (this.nodeIds != null) {
            if (this.nodes == null) {
                this.nodes = new ArrayList<Node>();
            } else {
                this.nodes.clear();
            }
            int nIsize = this.nodeIds.size();
            for (int i = 0; i < nIsize; ++i) {
                this.nodes.add((Node)entities.get(new Entity.EntityId(Entity.EntityType.NODE, this.nodeIds.get(i))));
            }
        }
    }

    public QuadRect getLatLonBBox() {
        QuadRect qr = null;
        if (this.nodes != null) {
            for (Node n : this.nodes) {
                if (qr == null) {
                    qr = new QuadRect();
                    qr.left = (float)n.getLongitude();
                    qr.right = (float)n.getLongitude();
                    qr.top = (float)n.getLatitude();
                    qr.bottom = (float)n.getLatitude();
                }
                if (n.getLongitude() < qr.left) {
                    qr.left = (float)n.getLongitude();
                } else if (n.getLongitude() > qr.right) {
                    qr.right = (float)n.getLongitude();
                }
                if (n.getLatitude() > qr.top) {
                    qr.top = (float)n.getLatitude();
                    continue;
                }
                if (!(n.getLatitude() < qr.bottom)) continue;
                qr.bottom = (float)n.getLatitude();
            }
        }
        return qr;
    }

    @Override
    public LatLon getLatLon() {
        if (this.nodes == null) {
            return null;
        }
        return OsmMapUtils.getWeightCenterForWay(this);
    }

    public void reverseNodes() {
        if (this.nodes != null) {
            Collections.reverse(this.nodes);
        }
        if (this.nodeIds != null) {
            this.nodeIds.reverse();
        }
    }
}

