/*
 * Decompiled with CFR 0.152.
 */
package jakarta.el;

import jakarta.el.BeanNameResolver;
import jakarta.el.ELContext;
import jakarta.el.ELException;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotWritableException;
import jakarta.el.Util;
import java.beans.FeatureDescriptor;
import java.util.Iterator;
import java.util.Objects;

public class BeanNameELResolver
extends ELResolver {
    private final BeanNameResolver beanNameResolver;

    public BeanNameELResolver(BeanNameResolver beanNameResolver) {
        this.beanNameResolver = beanNameResolver;
    }

    @Override
    public Object getValue(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object != null || !(object2 instanceof String)) {
            return null;
        }
        String string = (String)object2;
        if (this.beanNameResolver.isNameResolved(string)) {
            try {
                Object object3 = this.beanNameResolver.getBean(string);
                eLContext.setPropertyResolved(object, object2);
                return object3;
            }
            catch (Throwable throwable) {
                Util.handleThrowable(throwable);
                throw new ELException(throwable);
            }
        }
        return null;
    }

    @Override
    public void setValue(ELContext eLContext, Object object, Object object2, Object object3) {
        boolean bl;
        Objects.requireNonNull(eLContext);
        if (object != null || !(object2 instanceof String)) {
            return;
        }
        String string = (String)object2;
        boolean bl2 = eLContext.isPropertyResolved();
        try {
            bl = this.isReadOnly(eLContext, object, object2);
        }
        catch (Throwable throwable) {
            Util.handleThrowable(throwable);
            throw new ELException(throwable);
        }
        finally {
            eLContext.setPropertyResolved(bl2);
        }
        if (bl) {
            throw new PropertyNotWritableException(Util.message(eLContext, "beanNameELResolver.beanReadOnly", string));
        }
        if (this.beanNameResolver.isNameResolved(string) || this.beanNameResolver.canCreateBean(string)) {
            try {
                this.beanNameResolver.setBeanValue(string, object3);
                eLContext.setPropertyResolved(object, object2);
            }
            catch (Throwable throwable) {
                Util.handleThrowable(throwable);
                throw new ELException(throwable);
            }
        }
    }

    @Override
    public Class<?> getType(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object != null || !(object2 instanceof String)) {
            return null;
        }
        String string = (String)object2;
        try {
            if (this.beanNameResolver.isNameResolved(string)) {
                Class<?> clazz = this.beanNameResolver.getBean(string).getClass();
                eLContext.setPropertyResolved(object, object2);
                return clazz;
            }
        }
        catch (Throwable throwable) {
            Util.handleThrowable(throwable);
            throw new ELException(throwable);
        }
        return null;
    }

    @Override
    public boolean isReadOnly(ELContext eLContext, Object object, Object object2) {
        Objects.requireNonNull(eLContext);
        if (object != null || !(object2 instanceof String)) {
            return false;
        }
        String string = (String)object2;
        if (this.beanNameResolver.isNameResolved(string)) {
            boolean bl;
            try {
                bl = this.beanNameResolver.isReadOnly(string);
            }
            catch (Throwable throwable) {
                Util.handleThrowable(throwable);
                throw new ELException(throwable);
            }
            eLContext.setPropertyResolved(object, object2);
            return bl;
        }
        return false;
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext eLContext, Object object) {
        return null;
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext eLContext, Object object) {
        return String.class;
    }
}

