# Tuleap - Command Injection in Project Wiki

**CVE:** CVE-2017-7981

**CVSSv3:** 9.4 (CVSS:3.0/AV:N/AC:L/PR:L/UI:N/S:C/C:H/I:H/A:H/E:P/RL:U/RC:C)

**Versions affected:** >= 8.3 and <= 9.6.99.86

## Introduction

Tuleap is a Libre suite to plan, track, code and collaborate on software
projects. Tuleap helps development teams to build awesome applications,
better, faster, easier.

## Background

Tuleap uses PHPWiki as a plugin to provide a weak feature for
projects. The version of PHPWiki used is 1.3.10. This version contains a
command injection vulnerability in the SyntaxHighlighter plugin. Other
applications that use PHPWiki similar to Tuleap will also be affected
by this issue.

The latest version of PHPWiki is 1.5.5 and is no longer vulnerable to this issue.

## Vulnerability

Authenticated users, including unprivileged users, with access to a
project containing a wiki, can exploit this command injection
(CI) vulnerability to gain remote unauthorised access to the server
hosting the Tuleap web application.

RCE is achieved by entering a SyntaxHighlighter plugin directive in a
new wiki page on any wiki available in any project. The SyntaxHighligter
plugin in vulnerable versions of PHPWiki passes the `syntax` argument
to the `proc_open()` PHP builtin function which spawns a process in the
operating system running the web application.

The following is an example plugin directie which would cause the `id(1)`
command to be executed on a Linux server running an affected version
of Tuleap.

```
<?plugin SyntaxHighlighter syntax="c;id"
code to be highlighted
?>
```

The result of the command execution can be seen in the image below.

![command execution](2017.04.tuleap-auth-ci.command-exec.png)

## Versions Affected

This vulnerability has existed in the version of PHPWiki used by the
Tuleap project since at least version 8.3 through to 9.6.99.86.

## References

https://github.com/xdrr/vulnerability-research/blob/master/webapp/tuleap/2017.04.tuleap-auth-ci.md

https://tuleap.net/plugins/tracker/?aid=10159

## Credit

This vulnerability was discovered by Ben N (pajexali@gmail.com) 19
April 2017.