/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.appearance.api;

import java.awt.geom.Point2D;

public abstract class Interpolator {
    public static final Interpolator LINEAR = new Interpolator(){

        @Override
        public float interpolate(float x) {
            return x;
        }
    };
    public static final Interpolator LOG2 = new Interpolator(){

        @Override
        public float interpolate(float x) {
            return (float)(Math.log(1.0f + x) / Math.log(2.0));
        }
    };

    public static Interpolator newBezierInterpolator(float px1, float py1, float px2, float py2) {
        return new BezierInterpolator(px1, py1, px2, py2);
    }

    public abstract float interpolate(float var1);

    public static class BezierInterpolator
    extends Interpolator {
        private final float x1;
        private final float y1;
        private final float x2;
        private final float y2;
        private final boolean isCurveLinear;
        private static final int SAMPLE_SIZE = 16;
        private static final float SAMPLE_INCREMENT = 0.0625f;
        private final float[] xSamples = new float[17];

        public BezierInterpolator(float px1, float py1, float px2, float py2) {
            if (px1 < 0.0f || px1 > 1.0f || py1 < 0.0f || py1 > 1.0f || px2 < 0.0f || px2 > 1.0f || py2 < 0.0f || py2 > 1.0f) {
                throw new IllegalArgumentException("control point coordinates must all be in range [0,1]");
            }
            if (px1 == 0.0f && px2 == 0.0f) {
                px2 = (float)((double)px2 + 0.01);
            }
            this.x1 = px1;
            this.y1 = py1;
            this.x2 = px2;
            this.y2 = py2;
            boolean bl = this.isCurveLinear = this.x1 == this.y1 && this.x2 == this.y2;
            if (!this.isCurveLinear) {
                for (int i = 0; i < 17; ++i) {
                    this.xSamples[i] = this.eval((float)i * 0.0625f, this.x1, this.x2);
                }
            }
        }

        public Point2D getControl1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public Point2D getControl2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        @Override
        public float interpolate(float x) {
            if (x < 0.0f) {
                x = 0.0f;
            } else if (x > 1.0f) {
                x = 1.0f;
            }
            if (this.isCurveLinear || x == 0.0f || x == 1.0f) {
                return x;
            }
            return this.eval(this.findTForX(x), this.y1, this.y2);
        }

        private float eval(float t, float p1, float p2) {
            float compT = 1.0f - t;
            return t * (3.0f * compT * (compT * p1 + t * p2) + t * t);
        }

        private float evalDerivative(float t, float p1, float p2) {
            float compT = 1.0f - t;
            return 3.0f * (compT * (compT * p1 + 2.0f * t * (p2 - p1)) + t * t * (1.0f - p2));
        }

        private float getInitialGuessForT(float x) {
            for (int i = 1; i < 17; ++i) {
                if (!(this.xSamples[i] >= x)) continue;
                float xRange = this.xSamples[i] - this.xSamples[i - 1];
                if (xRange == 0.0f) {
                    return (float)(i - 1) * 0.0625f;
                }
                return ((float)(i - 1) + (x - this.xSamples[i - 1]) / xRange) * 0.0625f;
            }
            return 1.0f;
        }

        private float findTForX(float x) {
            float dXdT;
            float xT;
            float t = this.getInitialGuessForT(x);
            int numIterations = 4;
            for (int i = 0; i < 4 && (xT = this.eval(t, this.x1, this.x2) - x) != 0.0f && (dXdT = this.evalDerivative(t, this.x1, this.x2)) != 0.0f; ++i) {
                t -= xT / dXdT;
            }
            return t;
        }
    }
}

