/*
 * Decompiled with CFR 0.152.
 */
package org.grails.core.artefact;

import grails.artefact.Artefact;
import grails.core.ArtefactHandlerAdapter;
import grails.core.GrailsApplication;
import grails.core.GrailsClass;
import grails.core.GrailsDomainClass;
import grails.core.support.GrailsApplicationAware;
import groovy.lang.Closure;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.grails.compiler.injection.GrailsASTUtils;
import org.grails.core.DefaultGrailsDomainClass;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.io.support.GrailsResourceUtils;
import org.grails.io.support.Resource;
import org.springframework.core.Ordered;

public class DomainClassArtefactHandler
extends ArtefactHandlerAdapter
implements GrailsApplicationAware,
Ordered {
    public static final String TYPE = "Domain";
    public static final String PLUGIN_NAME = "domainClass";
    private static final String ENTITY_ANN_NAME = "Entity";
    private static final String GRAILS_PACKAGE_PREFIX = "grails.";
    private static final String JAVAX_PERSISTENCE = "javax.persistence";

    public DomainClassArtefactHandler() {
        super(TYPE, GrailsDomainClass.class, DefaultGrailsDomainClass.class, null, true);
    }

    @Override
    public void setGrailsApplication(GrailsApplication grailsApplication) {
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public GrailsClass newArtefactClass(Class artefactClass) {
        return new DefaultGrailsDomainClass(artefactClass);
    }

    public GrailsClass newArtefactClass(Class artefactClass, MappingContext mappingContext) {
        return new DefaultGrailsDomainClass(artefactClass, mappingContext);
    }

    @Override
    protected boolean isArtefactResource(Resource resource) throws IOException {
        return super.isArtefactResource(resource) && GrailsResourceUtils.isDomainClass((URL)resource.getURL());
    }

    @Override
    protected boolean isValidArtefactClassNode(ClassNode classNode, int modifiers) {
        return !classNode.isEnum() && !(classNode instanceof InnerClassNode);
    }

    @Override
    public boolean isArtefact(ClassNode classNode) {
        if (classNode == null) {
            return false;
        }
        if (!this.isValidArtefactClassNode(classNode, classNode.getModifiers())) {
            return false;
        }
        URL url = GrailsASTUtils.getSourceUrl(classNode);
        if (url != null) {
            return GrailsResourceUtils.isDomainClass((URL)url);
        }
        return super.isArtefact(classNode);
    }

    @Override
    public boolean isArtefactClass(Class clazz) {
        return DomainClassArtefactHandler.isDomainClass(clazz);
    }

    public static boolean isDomainClass(Class<?> clazz, boolean allowProxyClass) {
        boolean retval = DomainClassArtefactHandler.isDomainClass(clazz);
        if (!retval && allowProxyClass && clazz != null && clazz.getSimpleName().contains("$")) {
            retval = DomainClassArtefactHandler.isDomainClass(clazz.getSuperclass());
        }
        return retval;
    }

    public static boolean isDomainClass(Class<?> clazz) {
        return clazz != null && DomainClassArtefactHandler.doIsDomainClassCheck(clazz);
    }

    private static boolean doIsDomainClassCheck(Class<?> clazz) {
        if (Closure.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (clazz.isEnum()) {
            return false;
        }
        Artefact artefactAnn = null;
        try {
            artefactAnn = clazz.getAnnotation(Artefact.class);
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        if (artefactAnn != null && artefactAnn.value().equals(TYPE)) {
            return true;
        }
        Annotation[] annotations = null;
        try {
            annotations = clazz.getAnnotations();
        }
        catch (ArrayStoreException arrayStoreException) {
            // empty catch block
        }
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                Class<? extends Annotation> annType = annotation.annotationType();
                String annName = annType.getSimpleName();
                String pkgName = annType.getPackage().getName();
                if ((!ENTITY_ANN_NAME.equals(annName) || !pkgName.startsWith(GRAILS_PACKAGE_PREFIX)) && !pkgName.startsWith(JAVAX_PERSISTENCE)) continue;
                return true;
            }
        }
        return false;
    }

    public int getOrder() {
        return 1;
    }
}

