/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.Internal;
import io.micronaut.inject.BeanType;
import java.lang.annotation.Annotation;
import java.util.Objects;
import java.util.stream.Stream;

@Internal
class AnnotationStereotypeQualifier<T>
implements Qualifier<T> {
    private final Class<? extends Annotation> stereotype;

    AnnotationStereotypeQualifier(Class<? extends Annotation> stereotype) {
        this.stereotype = stereotype;
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        return candidates.filter(candidate -> candidate.getAnnotationMetadata().hasStereotype(this.stereotype));
    }

    public String toString() {
        return "@" + this.stereotype.getSimpleName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnnotationStereotypeQualifier that = (AnnotationStereotypeQualifier)o;
        return Objects.equals(this.stereotype, that.stereotype);
    }

    public int hashCode() {
        return Objects.hash(this.stereotype);
    }
}

