/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.cache.impl;

import java.util.concurrent.ConcurrentHashMap;
import org.grails.datastore.mapping.cache.TPCacheAdapter;
import org.grails.datastore.mapping.cache.TPCacheAdapterRepository;
import org.grails.datastore.mapping.model.PersistentEntity;

public class TPCacheAdapterRepositoryImpl<T>
implements TPCacheAdapterRepository<T> {
    private ConcurrentHashMap<String, TPCacheAdapter<T>> adapters = new ConcurrentHashMap();

    @Override
    public TPCacheAdapter<T> getTPCacheAdapter(PersistentEntity entity) {
        if (entity == null) {
            return null;
        }
        return this.adapters.get(entity.getJavaClass().getName());
    }

    @Override
    public void setTPCacheAdapter(PersistentEntity entity, TPCacheAdapter<T> cacheAdapter) {
        this.setTPCacheAdapter(entity.getJavaClass(), cacheAdapter);
    }

    @Override
    public void setTPCacheAdapter(Class entityJavaClass, TPCacheAdapter<T> cacheAdapter) {
        this.setTPCacheAdapter(entityJavaClass.getName(), cacheAdapter);
    }

    @Override
    public void setTPCacheAdapter(String entityJavaClassFQN, TPCacheAdapter<T> cacheAdapter) {
        this.adapters.put(entityJavaClassFQN, cacheAdapter);
    }
}

