/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestListener;
import junit.framework.TestResult;
import org.apache.tools.ant.taskdefs.optional.junit.IgnoredTestListener;
import org.apache.tools.ant.taskdefs.optional.junit.TestIgnored;

public class IgnoredTestResult
extends TestResult {
    private List<IgnoredTestListener> listeners = new ArrayList<IgnoredTestListener>();
    private List<TestIgnored> ignored = new ArrayList<TestIgnored>();
    private List<TestIgnored> skipped = new ArrayList<TestIgnored>();

    public synchronized void addListener(TestListener listener) {
        if (listener instanceof IgnoredTestListener) {
            this.listeners.add((IgnoredTestListener)listener);
        }
        super.addListener(listener);
    }

    public synchronized void removeListener(TestListener listener) {
        if (listener instanceof IgnoredTestListener) {
            this.listeners.remove(listener);
        }
        super.removeListener(listener);
    }

    public synchronized void testIgnored(Test test) throws Exception {
        this.ignored.add(new TestIgnored(test));
        for (IgnoredTestListener listener : this.listeners) {
            listener.testIgnored(test);
        }
    }

    public long ignoredCount() {
        return this.ignored.size();
    }

    public void testAssumptionFailure(Test test, Throwable cause) {
        this.skipped.add(new TestIgnored(test));
        for (IgnoredTestListener listener : this.listeners) {
            listener.testAssumptionFailure(test, cause);
        }
    }

    public long skippedCount() {
        return this.skipped.size();
    }
}

