/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericCifDataParser;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.T3;
import org.jmol.adapter.readers.cif.Cif2DataParser;
import org.jmol.adapter.readers.cif.CifReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.api.SymmetryInterface;
import org.jmol.symmetry.SymmetryOperation;

public class TopoCifParser
implements CifReader.Parser {
    static final int TOPOL_LINK = 0x1000000;
    static final int TOPOL_GROUP = 0x2000000;
    static final int TOPOL_NODE = 0x4000000;
    public static final int LINK_TYPE_SINGLE = 1;
    public static final int LINK_TYPE_DOUBLE = 2;
    public static final int LINK_TYPE_TRIPLE = 3;
    public static final int LINK_TYPE_QUADRUPLE = 4;
    public static final int LINK_TYPE_QUINTUPLE = 5;
    public static final int LINK_TYPE_SEXTUPLE = 6;
    public static final int LINK_TYPE_SEPTUPLE = 7;
    public static final int LINK_TYPE_OCTUPLE = 8;
    public static final int LINK_TYPE_AROM = 9;
    public static final int LINK_TYPE_POLY = 10;
    public static final int LINK_TYPE_DELO = 11;
    public static final int LINK_TYPE_PI = 12;
    public static final int LINK_TYPE_HBOND = 13;
    public static final int LINK_TYPE_VDW = 14;
    public static final int LINK_TYPE_OTHER = 15;
    public static String linkTypes = "?  SINTRIQUAQUISEXSEPOCTAROPOLPI HBOVDW";
    public static final int LINK_TYPE_BITS = 4;
    static double ERROR_TOLERANCE = 0.001;
    CifReader reader;
    Lst<TAtom> atoms = new Lst();
    Lst<TNode> nodes = new Lst();
    Lst<TLink> links = new Lst();
    Lst<TNet> nets = new Lst();
    TNet singleNet;
    int netCount;
    int linkCount;
    int atomCount;
    T3 temp1 = new P3();
    T3 temp2 = new P3();
    private int ac0 = -1;
    private int bc0;
    private GenericCifDataParser cifParser;
    String failed;
    M4[] ops;
    int i0;
    int b0;
    private String allowedTypes;
    String netNotes = "";
    private SymmetryInterface sym;
    private static final String[] topolFields = new String[]{"_topol_net_id", "_topol_net_label", "_topol_net_special_details", "_topol_link_id", "_topol_link_net_id", "_topol_link_node_id_1", "_topol_link_node_id_2", "_topol_link_node_label_1", "_topol_link_node_label_2", "_topol_link_atom_label_1", "_topol_link_atom_label_2", "_topol_link_symop_1", "_topol_link_translation_1", "_topol_link_translation_1_x", "_topol_link_translation_1_y", "_topol_link_translation_1_z", "_topol_link_symop_2", "_topol_link_translation_2", "_topol_link_translation_2_x", "_topol_link_translation_2_y", "_topol_link_translation_2_z", "_topol_link_distance", "_topol_link_type", "_topol_link_multiplicity", "_topol_link_voronoi_solidangle", "_topol_link_order", "_topol_node_id", "_topol_node_net_id", "_topol_node_label", "_topol_node_atom_label", "_topol_node_symop", "_topol_node_translation", "_topol_node_translation_x", "_topol_node_translation_y", "_topol_node_translation_z", "_topol_node_fract_x", "_topol_node_fract_y", "_topol_node_fract_z", "_topol_node_chemical_formula_sum", "_topol_atom_id", "_topol_atom_atom_label", "_topol_atom_node_id", "_topol_atom_link_id", "_topol_atom_symop", "_topol_atom_translation", "_topol_atom_translation_x", "_topol_atom_translation_y", "_topol_atom_translation_z", "_topol_atom_fract_x", "_topol_atom_fract_y", "_topol_atom_fract_z", "_topol_atom_element_symbol", "_topol_link_site_symmetry_symop_1", "_topol_link_site_symmetry_translation_1_x", "_topol_link_site_symmetry_translation_1_y", "_topol_link_site_symmetry_translation_1_z", "_topol_link_site_symmetry_symop_2", "_topol_link_site_symmetry_translation_2_x", "_topol_link_site_symmetry_translation_2_y", "_topol_link_site_symmetry_translation_2_z", "_topol_link_site_symmetry_translation_1", "_topol_link_site_symmetry_translation_2"};
    private static final byte topol_net_id = 0;
    private static final byte topol_net_label = 1;
    private static final byte topol_net_special_details = 2;
    private static final byte topol_link_id = 3;
    private static final byte topol_link_net_id = 4;
    private static final byte topol_link_node_id_1 = 5;
    private static final byte topol_link_node_id_2 = 6;
    private static final byte topol_link_node_label_1 = 7;
    private static final byte topol_link_node_label_2 = 8;
    private static final byte topol_link_atom_label_1 = 9;
    private static final byte topol_link_atom_label_2 = 10;
    private static final byte topol_link_symop_1 = 11;
    private static final byte topol_link_translation_1 = 12;
    private static final byte topol_link_translation_1_x = 13;
    private static final byte topol_link_translation_1_y = 14;
    private static final byte topol_link_translation_1_z = 15;
    private static final byte topol_link_symop_2 = 16;
    private static final byte topol_link_translation_2 = 17;
    private static final byte topol_link_translation_2_x = 18;
    private static final byte topol_link_translation_2_y = 19;
    private static final byte topol_link_translation_2_z = 20;
    private static final byte topol_link_distance = 21;
    private static final byte topol_link_type = 22;
    private static final byte topol_link_multiplicity = 23;
    private static final byte topol_link_voronoi_solidangle = 24;
    private static final byte topol_link_order = 25;
    private static final byte topol_node_id = 26;
    private static final byte topol_node_net_id = 27;
    private static final byte topol_node_label = 28;
    private static final byte topol_node_atom_label = 29;
    private static final byte topol_node_symop = 30;
    private static final byte topol_node_translation = 31;
    private static final byte topol_node_translation_x = 32;
    private static final byte topol_node_translation_y = 33;
    private static final byte topol_node_translation_z = 34;
    private static final byte topol_node_fract_x = 35;
    private static final byte topol_node_fract_y = 36;
    private static final byte topol_node_fract_z = 37;
    private static final byte topol_node_chemical_formula_sum = 38;
    private static final byte topol_atom_id = 39;
    private static final byte topol_atom_atom_label = 40;
    private static final byte topol_atom_node_id = 41;
    private static final byte topol_atom_link_id = 42;
    private static final byte topol_atom_symop = 43;
    private static final byte topol_atom_translation = 44;
    private static final byte topol_atom_translation_x = 45;
    private static final byte topol_atom_translation_y = 46;
    private static final byte topol_atom_translation_z = 47;
    private static final byte topol_atom_fract_x = 48;
    private static final byte topol_atom_fract_y = 49;
    private static final byte topol_atom_fract_z = 50;
    private static final byte topol_atom_element_symbol = 51;
    private static final byte topol_link_site_symmetry_symop_1 = 52;
    private static final byte topol_link_site_symmetry_translation_1_x = 53;
    private static final byte topol_link_site_symmetry_translation_1_y = 54;
    private static final byte topol_link_site_symmetry_translation_1_z = 55;
    private static final byte topol_link_site_symmetry_symop_2 = 56;
    private static final byte topol_link_site_symmetry_translation_2_x = 57;
    private static final byte topol_link_site_symmetry_translation_2_y = 58;
    private static final byte topol_link_site_symmetry_translation_2_z = 59;
    private static final byte topol_link_site_symmetry_translation_1 = 60;
    private static final byte topol_link_site_symmetry_translation_2 = 61;

    static int getBondType(String type, int order) {
        if ((type = type.toUpperCase()).equals("V")) {
            return order == 0 ? 1 : order;
        }
        switch (type.charAt(0)) {
            case 'V': {
                return 14;
            }
        }
        if (type.length() > 3) {
            type = type.substring(0, 3);
        }
        return Math.max(1, linkTypes.indexOf(type) / 3);
    }

    @Override
    public TopoCifParser setReader(CifReader reader) {
        if (!reader.checkFilterKey("TOPOL")) {
            reader.appendLoadNote("This file has Topology analysis records.\nUse LOAD \"\" {1 1 1} FILTER \"TOPOL\"  to load the topology.");
            return this;
        }
        this.reader = reader;
        String types = reader.getFilter("TOPOS_TYPES=");
        if (types == null) {
            types = reader.getFilter("TOPOS_TYPE=");
        }
        if (types != null && types.length() > 0) {
            this.allowedTypes = types = "+" + types.toLowerCase() + "+";
        }
        this.i0 = reader.baseAtomIndex;
        this.b0 = reader.baseBondIndex;
        return this;
    }

    @Override
    public boolean processBlock(String key) throws Exception {
        if (this.reader == null || this.failed != null) {
            return false;
        }
        if (this.ac0 < 0) {
            this.ac0 = this.reader.asc.ac;
            this.bc0 = this.reader.asc.bondCount;
        }
        if (this.reader.ucItems != null) {
            this.reader.allow_a_len_1 = true;
            for (int i = 0; i < 6; ++i) {
                this.reader.setUnitCellItem(i, this.reader.ucItems[i]);
            }
        }
        this.reader.parseLoopParameters(topolFields);
        this.cifParser = this.reader.cifParser;
        if (key.startsWith("_topol_net")) {
            this.processNets();
        } else if (key.startsWith("_topol_link")) {
            this.processLinks();
        } else if (key.startsWith("_topol_node")) {
            this.processNodes();
        } else if (key.startsWith("_topol_atom")) {
            this.processAtoms();
        }
        return true;
    }

    @Override
    public void ProcessRecord(String key, String data) {
        if (key.startsWith("_topol_net")) {
            this.processSingleNet(key, data);
        }
    }

    private void processSingleNet(String key, String data) {
        if (key.equals(topolFields[0])) {
            int n = this.reader.parseIntStr(data);
            if (n != Integer.MIN_VALUE) {
                if (this.singleNet == null) {
                    this.singleNet = new TNet(this.netCount++, n, "Net" + n, null);
                    this.nets.addLast(this.singleNet);
                } else {
                    this.singleNet.id = n;
                }
                return;
            }
        } else {
            if (key.equals(topolFields[2])) {
                if (this.singleNet == null) {
                    this.singleNet = new TNet(this.netCount++, 1, null, data);
                    this.nets.addLast(this.singleNet);
                } else {
                    this.singleNet.specialDetails = data;
                }
                return;
            }
            if (!key.equals(topolFields[1])) {
                return;
            }
        }
        if (this.singleNet == null) {
            this.singleNet = new TNet(this.netCount++, 1, data, null);
            this.nets.addLast(this.singleNet);
        } else {
            this.singleNet.label = data;
        }
    }

    private void processNets() throws Exception {
        while (this.cifParser.getData()) {
            int id = this.getInt(this.getDataValue((byte)0));
            if (id < 0) {
                id = 0;
            }
            String netLabel = this.getDataValue((byte)1);
            TNet net = this.getNetFor(id, netLabel);
            net.specialDetails = this.getDataValue((byte)2);
            net.line = this.reader.line;
        }
    }

    private void processLinks() throws Exception {
        while (this.cifParser.getData()) {
            String type = ("" + this.getDataValue((byte)22)).toLowerCase();
            if (this.allowedTypes != null && this.allowedTypes.indexOf("+" + type + "+") < 0) continue;
            TLink link = new TLink();
            link.type = type;
            int[] t1 = new int[3];
            int[] t2 = new int[3];
            int n = this.cifParser.getColumnCount();
            block17: for (int i = 0; i < n; ++i) {
                int p = this.reader.fieldProperty(i);
                String field = this.reader.field;
                switch (p) {
                    case 3: {
                        link.id = this.getInt(field);
                        continue block17;
                    }
                    case 4: {
                        int id = this.getInt(field);
                        if (id == Integer.MIN_VALUE) {
                            link.netLabel = field;
                            continue block17;
                        }
                        link.netID = this.getInt(field);
                        continue block17;
                    }
                    case 5: {
                        link.nodeIds[0] = this.getInt(field);
                        continue block17;
                    }
                    case 6: {
                        link.nodeIds[1] = this.getInt(field);
                        continue block17;
                    }
                    case 7: 
                    case 9: {
                        link.atomLabels[0] = field;
                        continue block17;
                    }
                    case 8: 
                    case 10: {
                        link.atomLabels[1] = field;
                        continue block17;
                    }
                    case 11: 
                    case 52: {
                        link.symops[0] = this.getInt(field) - 1;
                        continue block17;
                    }
                    case 16: 
                    case 56: {
                        link.symops[1] = this.getInt(field) - 1;
                        continue block17;
                    }
                    case 25: {
                        link.topoOrder = this.getInt(field);
                        continue block17;
                    }
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 60: {
                        t1 = this.processTranslation(p, t1, field);
                        continue block17;
                    }
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 61: {
                        t2 = this.processTranslation(p, t2, field);
                        continue block17;
                    }
                    case 21: {
                        link.cartesianDistance = this.getFloat(field);
                        continue block17;
                    }
                    case 23: {
                        link.multiplicity = this.getInt(field);
                        continue block17;
                    }
                    case 24: {
                        link.voronoiAngle = this.getFloat(field);
                    }
                }
            }
            if (!link.setLink(t1, t2, this.reader.line)) {
                this.failed = "invalid link! " + link;
                return;
            }
            this.links.addLast(link);
        }
    }

    private void processNodes() throws Exception {
        while (this.cifParser.getData()) {
            TNode node = new TNode();
            int[] t = new int[3];
            int n = this.cifParser.getColumnCount();
            block13: for (int i = 0; i < n; ++i) {
                int p = this.reader.fieldProperty(i);
                String field = this.reader.field;
                switch (p) {
                    case 26: {
                        node.id = this.getInt(field);
                        continue block13;
                    }
                    case 28: {
                        node.label = field;
                        continue block13;
                    }
                    case 27: {
                        node.netID = this.getInt(field);
                        continue block13;
                    }
                    case 29: {
                        node.atomLabel = field;
                        continue block13;
                    }
                    case 30: {
                        node.symop = this.getInt(field) - 1;
                        continue block13;
                    }
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: {
                        t = this.processTranslation(p, t, field);
                        continue block13;
                    }
                    case 38: {
                        node.formula = field;
                        continue block13;
                    }
                    case 35: {
                        node.x = this.getFloat(field);
                        continue block13;
                    }
                    case 36: {
                        node.y = this.getFloat(field);
                        continue block13;
                    }
                    case 37: {
                        node.z = this.getFloat(field);
                    }
                }
            }
            if (!node.setNode(t, this.reader.line)) continue;
            this.nodes.addLast(node);
        }
    }

    private void processAtoms() throws Exception {
        while (this.cifParser.getData()) {
            TAtom atom = new TAtom();
            int[] t = new int[3];
            int n = this.cifParser.getColumnCount();
            block13: for (int i = 0; i < n; ++i) {
                int p = this.reader.fieldProperty(i);
                String field = this.reader.field;
                switch (p) {
                    case 39: {
                        atom.id = this.getInt(field);
                        continue block13;
                    }
                    case 40: {
                        atom.atomLabel = field;
                        continue block13;
                    }
                    case 41: {
                        atom.nodeID = this.getInt(field);
                        continue block13;
                    }
                    case 42: {
                        atom.linkID = this.getInt(field);
                        continue block13;
                    }
                    case 43: {
                        atom.symop = this.getInt(field) - 1;
                        continue block13;
                    }
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: {
                        t = this.processTranslation(p, t, field);
                        continue block13;
                    }
                    case 48: {
                        atom.x = this.getFloat(field);
                        continue block13;
                    }
                    case 49: {
                        atom.y = this.getFloat(field);
                        continue block13;
                    }
                    case 50: {
                        atom.z = this.getFloat(field);
                        continue block13;
                    }
                    case 51: {
                        atom.formula = field;
                    }
                }
            }
            if (!atom.setAtom(t, this.reader.line)) continue;
            this.atoms.addLast(atom);
        }
    }

    private int[] processTranslation(int p, int[] t, String field) {
        switch (p) {
            case 12: 
            case 17: 
            case 31: 
            case 44: 
            case 60: 
            case 61: {
                t = Cif2DataParser.getIntArrayFromStringList(field, 3);
                break;
            }
            case 13: 
            case 18: 
            case 32: 
            case 45: 
            case 53: 
            case 57: {
                t[0] = this.getInt(field);
                break;
            }
            case 14: 
            case 19: 
            case 33: 
            case 46: 
            case 54: 
            case 58: {
                t[1] = this.getInt(field);
                break;
            }
            case 15: 
            case 20: 
            case 34: 
            case 47: 
            case 55: 
            case 59: {
                t[2] = this.getInt(field);
            }
        }
        return t;
    }

    @Override
    public boolean finalizeReader() throws Exception {
        int i;
        if (this.reader == null || this.reader.symops == null) {
            return false;
        }
        this.cifParser = null;
        this.reader.applySymmetryToBonds = true;
        Lst<String> symops = this.reader.symops;
        int nOps = symops.size();
        this.ops = new M4[nOps];
        for (i = 0; i < nOps; ++i) {
            this.ops[i] = SymmetryOperation.getMatrixFromXYZ("!" + (String)symops.get(i));
        }
        for (i = 0; i < this.atoms.size(); ++i) {
            ((TAtom)this.atoms.get(i)).finalizeAtom();
        }
        this.sym = this.reader.getSymmetry();
        for (i = 0; i < this.links.size(); ++i) {
            ((TLink)this.links.get(i)).finalizeLink();
        }
        if (this.reader.doApplySymmetry) {
            this.reader.applySymmetryAndSetTrajectory();
        }
        return true;
    }

    @Override
    public void finalizeSymmetry(boolean haveSymmetry) throws Exception {
        if (this.reader == null || !haveSymmetry || this.links.size() == 0) {
            return;
        }
        BS bsConnected = new BS();
        BS bsAtoms = new BS();
        int nLinks = this.processAssociations(bsConnected, bsAtoms);
        BS bsExclude = TopoCifParser.shiftBits(bsAtoms, bsConnected);
        if (bsConnected.cardinality() > 0) {
            this.reader.asc.bsAtoms = bsAtoms;
            this.reader.asc.atomSetInfo.put("bsExcludeBonding", bsExclude);
        }
        this.reader.appendLoadNote("TopoCifParser created " + bsConnected.cardinality() + " nodes and " + nLinks + " links");
        Lst<Map<String, Object>> info = new Lst<Map<String, Object>>();
        int n = this.links.size();
        for (int i = 0; i < n; ++i) {
            info.addLast(((TLink)this.links.get(i)).getLinkInfo());
        }
        this.reader.asc.setCurrentModelInfo("topology", info);
        String script = "if (autobond) {delete !connected && !(atomName LIKE '*_Link*' or atomName LIKE '*_Node*')}; display displayed or " + ((TNet)this.nets.get((int)0)).label + "__*";
        this.reader.addJmolScript(script);
        for (int i = 0; i < this.nets.size(); ++i) {
            ((TNet)this.nets.get(i)).finalizeNet();
        }
    }

    static BS shiftBits(BS bsAtoms, BS bs) {
        BS bsNew = new BS();
        int pt = 0;
        int i = bsAtoms.nextSetBit(0);
        while (i >= 0) {
            while (bsAtoms.get(i)) {
                bsNew.setBitTo(pt++, bs.get(i++));
            }
            i = bsAtoms.nextSetBit(i + 1);
        }
        return bsNew;
    }

    private int processAssociations(BS bsConnected, BS bsAtoms) {
        TLink link;
        TNode node;
        int nlinks = 0;
        Atom[] atoms = this.reader.asc.atoms;
        int i = this.reader.asc.ac;
        while (--i >= this.ac0) {
            Atom a = atoms[i];
            int idx = a.sequenceNumber;
            if (idx == Integer.MIN_VALUE || idx == 0) continue;
            if (idx > 0) {
                node = this.getAssociatedNodeByIdx(idx - 1);
                if (node.bsAtoms == null) {
                    node.bsAtoms = new BS();
                }
                node.bsAtoms.set(this.i0 + a.index);
            } else {
                link = this.getAssoiatedLinkByIdx(-idx - 1);
                if (link != null) {
                    if (link.bsAtoms == null) {
                        link.bsAtoms = new BS();
                    }
                    link.bsAtoms.set(this.i0 + a.index);
                }
            }
            bsAtoms.set(a.index);
        }
        boolean checkDistance = this.reader.doPackUnitCell;
        Bond[] bonds = this.reader.asc.bonds;
        int i2 = this.reader.asc.bondCount;
        while (--i2 >= this.bc0) {
            Bond b = bonds[i2];
            if (b.order >= 0x2000000) {
                bonds[i2] = null;
                continue;
            }
            if (b.order < 0x1000000) continue;
            b.order -= 0x1000000;
            TLink link2 = this.getAssoiatedLinkByIdx(b.order >> 4);
            if (checkDistance && (double)Math.abs(this.calculateDistance(atoms[b.atomIndex1], atoms[b.atomIndex2]) - link2.distance) >= ERROR_TOLERANCE) {
                bonds[i2] = null;
                continue;
            }
            if (link2.bsBonds == null) {
                link2.bsBonds = new BS();
            }
            link2.bsBonds.set(this.b0 + i2);
            switch (b.order & 0xF) {
                default: {
                    b.order = 1;
                    break;
                }
                case 2: {
                    b.order = 2;
                    break;
                }
                case 3: {
                    b.order = 3;
                    break;
                }
                case 4: {
                    b.order = 4;
                    break;
                }
                case 5: {
                    b.order = 5;
                    break;
                }
                case 6: {
                    b.order = 6;
                    break;
                }
                case 10: {
                    b.order = 1;
                    break;
                }
                case 11: 
                case 12: {
                    b.order = 515;
                    break;
                }
                case 13: {
                    b.order = 2048;
                    break;
                }
                case 14: {
                    b.order = 33;
                }
            }
            bsConnected.set(b.atomIndex1);
            bsConnected.set(b.atomIndex2);
            ++nlinks;
        }
        bsAtoms.or(bsConnected);
        i2 = this.nodes.size();
        while (--i2 >= 0) {
            node = (TNode)this.nodes.get(i2);
            if (node.bsAtoms == null) continue;
            node.bsAtoms = TopoCifParser.shiftBits(bsAtoms, node.bsAtoms);
        }
        i2 = this.links.size();
        while (--i2 >= 0) {
            link = (TLink)this.links.get(i2);
            if (link.bsAtoms == null) continue;
            link.bsAtoms = TopoCifParser.shiftBits(bsAtoms, link.bsAtoms);
        }
        return nlinks;
    }

    static boolean isEqualD(T3 p1, T3 p2, double d) {
        return Double.isNaN(d) || Math.abs((double)p1.distance(p2) - d) < ERROR_TOLERANCE;
    }

    private String getDataValue(byte key) {
        String f = this.reader.getField(key);
        return "\u0000".equals(f) ? null : f;
    }

    private int getInt(String f) {
        return f == null ? Integer.MIN_VALUE : this.reader.parseIntStr(f);
    }

    private float getFloat(String f) {
        return f == null ? Float.NaN : this.reader.parseFloatStr(f);
    }

    static void setTAtom(Atom a, Atom b) {
        b.setT(a);
        b.formalCharge = a.formalCharge;
        b.bondRadius = a.bondRadius;
    }

    static void setElementSymbol(Atom a, String formula) {
        String name = a.atomName;
        a.atomName = formula == null ? (a.atomName == null ? "X" : a.atomName.substring(a.atomName.indexOf(95) + 1)) : formula;
        a.getElementSymbol();
        a.atomName = name;
    }

    static void applySymmetry(Atom a, M4[] ops, int op, T3 t) {
        if (op >= 0 && (op > 1 || t.x != 0.0f || t.y != 0.0f || t.z != 0.0f)) {
            if (op > 1) {
                ops[op].rotTrans(a);
            }
            a.add(t);
        }
    }

    public TNet getNetByID(int id) {
        int i = this.nets.size();
        while (--i >= 0) {
            TNet n = (TNet)this.nets.get(i);
            if (n.id != id) continue;
            return n;
        }
        TNet n = new TNet(this.netCount++, id, "Net" + id, null);
        this.nets.addLast(n);
        return n;
    }

    public Atom getAtomFromName(String atomLabel) {
        return atomLabel == null ? null : this.reader.asc.getAtomFromName(atomLabel);
    }

    float calculateDistance(P3 p1, P3 p2) {
        this.temp1.setT(p1);
        this.temp2.setT(p2);
        this.sym.toCartesian(this.temp1, true);
        this.sym.toCartesian(this.temp2, true);
        return this.temp1.distance(this.temp2);
    }

    public TNet getNetFor(int id, String label) {
        TNet net = null;
        if (id > 0) {
            net = this.getNetByID(id);
        } else if (label != null) {
            int i = this.nets.size();
            while (--i >= 0) {
                TNet n = (TNet)this.nets.get(i);
                if (!n.label.equals(label)) continue;
                net = n;
                break;
            }
        }
        if (net == null) {
            net = this.getNetByID(id < 1 ? 1 : id);
        }
        if (label != null) {
            net.label = label;
        }
        return net;
    }

    TNode getAssociatedNodeByIdx(int idx) {
        int i = this.nodes.size();
        while (--i >= 0) {
            TNode n = (TNode)this.nodes.get(i);
            if (n.idx != idx) continue;
            return n;
        }
        return null;
    }

    TLink getAssoiatedLinkByIdx(int idx) {
        int i = this.links.size();
        while (--i >= 0) {
            TLink l = (TLink)this.links.get(i);
            if (l.idx != idx) continue;
            return l;
        }
        return null;
    }

    public TNode getNodeById(int nodeID, int op, P3 trans) {
        int i = this.nodes.size();
        while (--i >= 0) {
            TNode n = (TNode)this.nodes.get(i);
            if (n.id != nodeID || op >= 0 && (n.linkSymop != op || !n.linkTrans.equals(trans))) continue;
            return n;
        }
        return null;
    }

    private class TLink
    extends Bond {
        int id;
        int[] nodeIds = new int[2];
        String[] atomLabels = new String[2];
        int[] symops = new int[2];
        P3[] translations = new P3[2];
        int netID;
        String netLabel;
        String type = "";
        int multiplicity;
        int topoOrder;
        float voronoiAngle;
        float cartesianDistance;
        int idx;
        TNet net;
        TNode[] linkNodes = new TNode[2];
        int typeBondOrder;
        Lst<TAtom> tatoms;
        BS bsAtoms;
        BS bsBonds;
        private String line;

        public TLink() {
            boolean i = false;
        }

        boolean setLink(int[] t1, int[] t2, String line) {
            this.line = line;
            this.idx = TopoCifParser.this.linkCount++;
            if (this.nodeIds[1] == 0) {
                this.nodeIds[1] = this.nodeIds[0];
            }
            this.typeBondOrder = TopoCifParser.getBondType(this.type, this.topoOrder);
            this.translations[0] = P3.new3(t1[0], t1[1], t1[2]);
            this.translations[1] = P3.new3(t2[0], t2[1], t2[2]);
            System.out.println("TopoCifParser.setLink " + this);
            return true;
        }

        void addAtom(TAtom atom) {
            if (this.tatoms == null) {
                this.tatoms = new Lst();
            }
            this.tatoms.addLast(atom);
        }

        void finalizeLink() throws Exception {
            this.finalizeLinkNode(0);
            this.finalizeLinkNode(1);
            if (this.tatoms != null) {
                this.net.hasAtoms = true;
                int i = this.tatoms.size();
                while (--i >= 0) {
                    TAtom a = (TAtom)this.tatoms.get(i);
                    a.sequenceNumber = -this.idx - 1;
                    a.atomName = this.net.label + "_" + a.atomName;
                }
            }
            this.order = 0x1000000 + (this.idx << 4) + this.typeBondOrder;
            this.distance = TopoCifParser.this.calculateDistance(this.linkNodes[0], this.linkNodes[1]);
            if (this.cartesianDistance != 0.0f && (double)Math.abs(this.distance - this.cartesianDistance) >= ERROR_TOLERANCE) {
                System.err.println("Distance error! distance=" + this.distance + " for " + this.line);
            }
            System.out.println("link d=" + this.distance + " " + this + this.linkNodes[0] + this.linkNodes[1]);
            TopoCifParser.this.reader.asc.addBond(this);
        }

        private void finalizeLinkNode(int index) throws Exception {
            Atom atom;
            TNode node;
            int id = this.nodeIds[index];
            String atomLabel = this.atomLabels[index];
            int op = this.symops[index];
            P3 trans = this.translations[index];
            TNode node0 = node = this.getNodeWithSym(id, atomLabel, op, trans);
            if (node == null) {
                node = this.getNodeWithSym(id, atomLabel, -1, null);
            }
            Atom atom2 = atom = node == null ? TopoCifParser.this.getAtomFromName(atomLabel) : null;
            if (atom != null) {
                this.setNet(null);
                node = new TNode(TopoCifParser.this.atomCount++, atom, this.net, op, trans);
            } else if (node != null) {
                this.setNet(node);
                if (node0 == null) {
                    node = node.copy();
                }
                node.linkSymop = op;
                node.linkTrans = trans;
            } else {
                throw new Exception("TopoCIFParser.addNodeIfNull no atom or node " + atomLabel + " line=" + this.line);
            }
            TopoCifParser.this.nodes.addLast(node);
            this.linkNodes[index] = node;
            if (index == 1 && node == this.linkNodes[0]) {
                this.linkNodes[1] = node.copy();
            }
            node.finalizeNode(TopoCifParser.this.ops);
            TopoCifParser.applySymmetry(node, TopoCifParser.this.ops, op, trans);
            if (index == 0) {
                this.atomIndex1 = node.index;
            } else {
                this.atomIndex2 = node.index;
            }
        }

        private void setNet(TNode node) {
            if (this.net != null) {
                return;
            }
            this.net = node == null ? TopoCifParser.this.getNetFor(this.netID, this.netLabel) : node.net;
            ++this.net.nLinks;
            this.netLabel = this.net.label;
            this.netID = this.net.id;
        }

        private TNode getNodeWithSym(int nodeID, String nodeLabel, int op, P3 trans) {
            if (nodeID > 0) {
                return TopoCifParser.this.getNodeById(nodeID, op, trans);
            }
            int i = TopoCifParser.this.nodes.size();
            while (--i >= 0) {
                TNode n = (TNode)TopoCifParser.this.nodes.get(i);
                if (!n.label.equals(nodeLabel) || op != -1 && (op != n.linkSymop || !trans.equals(n.linkTrans))) continue;
                return n;
            }
            return null;
        }

        Map<String, Object> getLinkInfo() {
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            info.put("index", this.idx + 1);
            if (this.id > 0) {
                info.put("id", this.id);
            }
            info.put("netID", this.netID);
            info.put("netLabel", this.netLabel);
            if (this.atomLabels[0] != null) {
                info.put("atomLabel1", this.atomLabels[0]);
            }
            if (this.atomLabels[1] != null) {
                info.put("atomLabel2", this.atomLabels[1]);
            }
            if (this.nodeIds[0] > 0) {
                info.put("nodeId1", this.nodeIds[0]);
            }
            if (this.nodeIds[1] > 0) {
                info.put("nodeId2", this.nodeIds[1]);
            }
            info.put("distance", Float.valueOf(this.cartesianDistance));
            if (!Float.isNaN(this.distance)) {
                info.put("distance", Float.valueOf(this.distance));
            }
            info.put("symops1", this.symops[0] + 1);
            info.put("symops2", this.symops[1] + 1);
            info.put("translation1", this.translations[0]);
            info.put("translation2", this.translations[1]);
            info.put("multiplicity", this.multiplicity);
            if (this.type != null) {
                info.put("type", this.type);
            }
            info.put("voronoiSolidAngle", Float.valueOf(this.voronoiAngle));
            info.put("atomIndex1", TopoCifParser.this.i0 + this.linkNodes[0].index);
            info.put("atomIndex2", TopoCifParser.this.i0 + this.linkNodes[1].index);
            if (this.bsAtoms != null && this.bsAtoms.cardinality() > 0) {
                info.put("representedAtoms", this.bsAtoms);
            }
            info.put("topoOrder", this.topoOrder);
            info.put("order", this.typeBondOrder);
            return info;
        }

        String info() {
            return "[link " + this.line + " : " + this.distance + "]";
        }

        @Override
        public String toString() {
            return this.info();
        }
    }

    private class TNode
    extends Atom {
        public int id;
        public String formula;
        public String atomLabel;
        int netID;
        String label;
        int symop = 0;
        P3 trans = new P3();
        Lst<TAtom> tatoms;
        BS bsAtoms = null;
        int linkSymop = 0;
        P3 linkTrans = new P3();
        TNet net;
        private boolean isFinalized;
        int idx;
        private Atom atom;
        private String line;

        TNode() {
            boolean i = false;
        }

        TNode(int idx, Atom atom, TNet net, int op, P3 trans) {
            this.idx = idx;
            this.atom = atom;
            this.net = net;
            this.linkSymop = op;
            this.linkTrans = trans;
            this.atomName = this.atomLabel = atom.atomName;
            this.label = this.atomLabel;
            this.formula = atom.getElementSymbol();
            TopoCifParser.setTAtom(atom, this);
        }

        boolean setNode(int[] a, String line) {
            this.line = line;
            if (this.tatoms == null) {
                if (Float.isNaN(this.x) != Float.isNaN(this.y) || Float.isNaN(this.y) != Float.isNaN(this.z)) {
                    return false;
                }
                this.idx = TopoCifParser.this.atomCount++;
                if (Float.isNaN(this.x)) {
                    this.trans = P3.new3(a[0], a[1], a[2]);
                } else {
                    this.symop = 0;
                }
                if (this.formula != null && this.formula.indexOf(" ") < 0) {
                    this.atomName = this.formula;
                    this.getElementSymbol();
                    if (!this.formula.equals(this.elementSymbol)) {
                        this.elementSymbol = "Z";
                    }
                    this.atomName = null;
                }
            }
            if (this.net == null) {
                this.net = TopoCifParser.this.getNetFor(this.netID, null);
            }
            this.netID = this.net.id;
            return true;
        }

        void addAtom(TAtom atom) {
            if (this.tatoms == null) {
                this.tatoms = new Lst();
            }
            this.tatoms.addLast(atom);
        }

        void finalizeNode(M4[] ops) throws Exception {
            Atom a;
            boolean haveXYZ;
            if (this.isFinalized) {
                return;
            }
            this.isFinalized = true;
            boolean bl = haveXYZ = !Float.isNaN(this.x);
            if (this.tatoms == null) {
                a = this.atom == null ? TopoCifParser.this.getAtomFromName(this.atomLabel) : this.atom;
                TopoCifParser.setElementSymbol(this, this.formula == null ? a.elementSymbol : this.formula);
                if (a == null && !haveXYZ) {
                    throw new Exception("TopoCIFParser.finalizeNode no atom " + this.atomLabel + " line=" + this.line);
                }
            } else {
                this.setCentroid();
                if (this.tatoms.size() == 1) {
                    TAtom ta = (TAtom)this.tatoms.get(0);
                    TopoCifParser.setElementSymbol(ta, ta.elementSymbol);
                    this.atomLabel = ta.atomLabel;
                    this.formalCharge = ta.formalCharge;
                    this.tatoms = null;
                } else {
                    this.net.hasAtoms = true;
                    this.elementSymbol = "Xx";
                    int i = this.tatoms.size();
                    while (--i >= 0) {
                        TAtom ta = (TAtom)this.tatoms.get(i);
                        ta.sequenceNumber = this.idx + 1;
                        if (ta.atomName != null && ta.atomName.startsWith(this.net.label + "_")) continue;
                        ta.atomName = this.net.label + "_" + ta.atomName;
                    }
                }
                a = this;
            }
            if (a != null && a == this.atom || !haveXYZ) {
                if (a != this) {
                    TopoCifParser.setTAtom(a, this);
                }
                TopoCifParser.applySymmetry(this, ops, this.symop, this.trans);
            }
            this.atomName = this.net.label + "__";
            if (this.label != null && this.label.startsWith(this.atomName)) {
                this.atomName = "";
            }
            this.atomName = this.atomName + (this.label != null ? this.label : (this.atomLabel != null ? this.atomLabel : "Node_" + this.id));
            this.addNode();
        }

        private void addNode() {
            TopoCifParser.this.reader.addCifAtom(this, this.atomName, null, null);
            ++this.net.nNodes;
        }

        private void setCentroid() {
            int n;
            this.z = 0.0f;
            this.y = 0.0f;
            this.x = 0.0f;
            int i = n = this.tatoms.size();
            while (--i >= 0) {
                this.add((T3)this.tatoms.get(i));
            }
            this.x /= (float)n;
            this.y /= (float)n;
            this.z /= (float)n;
        }

        public String info() {
            return "[node " + this.id + " " + this.label + "/" + this.atomName + " " + super.toString() + "]";
        }

        @Override
        public String toString() {
            return this.info();
        }

        public TNode copy() {
            TNode node = (TNode)this.clone();
            node.idx = TopoCifParser.this.atomCount++;
            if (node.isFinalized) {
                node.addNode();
            }
            if (this.tatoms != null) {
                node.tatoms = new Lst();
                int n = this.tatoms.size();
                for (int i = 0; i < n; ++i) {
                    TAtom ta = ((TAtom)this.tatoms.get(i)).getTClone();
                    node.tatoms.addLast(ta);
                    TopoCifParser.this.reader.addCifAtom(ta, ta.atomName, null, null);
                }
            }
            return node;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private class TAtom
    extends Atom {
        int id;
        String atomLabel;
        int nodeID;
        int linkID;
        int symop = 0;
        private P3 trans = new P3();
        String formula;
        String line;
        private boolean isFinalized;
        int idx;

        TAtom() {
            boolean i = false;
        }

        TAtom getTClone() {
            try {
                TAtom ta = (TAtom)this.clone();
                ta.idx = TopoCifParser.this.atomCount++;
                return ta;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        boolean setAtom(int[] a, String line) {
            this.line = line;
            if (Float.isNaN(this.x) != Float.isNaN(this.y) || Float.isNaN(this.y) != Float.isNaN(this.z)) {
                return false;
            }
            this.idx = TopoCifParser.this.atomCount++;
            if (Float.isNaN(this.x)) {
                this.trans = P3.new3(a[0], a[1], a[2]);
            } else {
                this.symop = 0;
            }
            if (this.formula != null && this.formula.indexOf(" ") < 0) {
                this.atomName = this.formula;
                this.getElementSymbol();
                if (!this.formula.equals(this.elementSymbol)) {
                    this.elementSymbol = "Z";
                }
            }
            this.atomName = this.atomLabel;
            return true;
        }

        void finalizeAtom() throws Exception {
            if (this.isFinalized) {
                return;
            }
            this.isFinalized = true;
            Atom a = TopoCifParser.this.getAtomFromName(this.atomLabel);
            TopoCifParser.setElementSymbol(this, this.formula);
            if (a == null && Float.isNaN(this.x)) {
                throw new Exception("TopoCIFParser.finalizeAtom no atom " + this.atomLabel + " line=" + this.line);
            }
            TNode node = null;
            if (this.nodeID > 0 && (node = TopoCifParser.this.getNodeById(this.nodeID, -1, null)) != null) {
                node.addAtom(this);
            }
            TLink link = null;
            if (this.linkID > 0 && (link = this.getLinkById(this.linkID)) != null) {
                link.addAtom(this);
            }
            if (node == null && link == null) {
                System.out.println("TAtom " + this + " ignored");
                return;
            }
            if (a != null && Float.isNaN(this.x)) {
                TopoCifParser.setTAtom(a, this);
                TopoCifParser.applySymmetry(this, TopoCifParser.this.ops, this.symop, this.trans);
            }
            this.atomName = (node != null ? "Node_" + this.nodeID + "_" : (link != null ? "Link_" + this.linkID + "_" : "TAtom_")) + this.atomLabel;
            System.out.println("TAtom adding " + this);
            TopoCifParser.this.reader.addCifAtom(this, this.atomName, null, null);
        }

        private TLink getLinkById(int linkID) {
            int i = TopoCifParser.this.links.size();
            while (--i >= 0) {
                TLink l = (TLink)TopoCifParser.this.links.get(i);
                if (l.id != linkID) continue;
                return l;
            }
            return null;
        }

        @Override
        public String toString() {
            return this.line + " " + super.toString();
        }
    }

    private class TNet {
        String line;
        int id;
        int nLinks;
        int nNodes;
        String label;
        String specialDetails;
        int idx;
        boolean hasAtoms;

        TNet(int index, int id, String label, String specialDetails) {
            this.idx = index;
            this.id = id;
            this.label = label;
            this.specialDetails = specialDetails;
        }

        void finalizeNet() {
            String netKey = "," + this.id + ",";
            if (TopoCifParser.this.netNotes.indexOf(netKey) < 0) {
                TopoCifParser.this.reader.appendLoadNote("Net " + this.label + (this.specialDetails == null ? "" : " '" + this.specialDetails + "'") + " created with " + this.nLinks + " links and " + this.nNodes + " nodes.\nUse DISPLAY " + (this.hasAtoms ? this.label + "__* to display it without associated atoms\nUse DISPLAY " + this.label + "_* to display it with its associated atoms" : this.label + "* to display it"));
            }
        }
    }
}

