/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCacheMonitor;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheManager;

public class RemoteCacheMonitor
extends AbstractAuxiliaryCacheMonitor {
    private final ConcurrentHashMap<RemoteCacheManager, RemoteCacheManager> managers = new ConcurrentHashMap();

    public RemoteCacheMonitor() {
        super("JCS-RemoteCacheMonitor");
        RemoteCacheMonitor.setIdlePeriod(30000L);
    }

    public void addManager(RemoteCacheManager manager) {
        this.managers.put(manager, manager);
        if (this.getState() == Thread.State.NEW) {
            this.start();
        }
    }

    @Override
    public void dispose() {
        this.managers.clear();
    }

    @Override
    public void doWork() {
        for (RemoteCacheManager mgr : this.managers.values()) {
            if (mgr.canFixCaches()) {
                mgr.fixCaches();
                continue;
            }
            this.allright.set(false);
        }
    }
}

