/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.concurrent.Future;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.io.BoundingBoxDownloader;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public final class DownloadOsmInViewAction
extends JosmAction {
    public DownloadOsmInViewAction() {
        super(I18n.tr("Download in current view", new Object[0]), "download_in_view", I18n.tr("Download map data from the OSM server in current view", new Object[0]), Shortcut.registerShortcut("file:downloadosminview", I18n.tr("File: {0}", I18n.tr("Download in current view", new Object[0])), 65535, 5000), false, "dialogs/download_in_view", true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Bounds bounds = MainApplication.getMap().mapView.getRealBounds();
        DownloadOsmInViewTask task = new DownloadOsmInViewTask();
        task.setZoomAfterDownload(false);
        Future<?> future = task.download(bounds);
        MainApplication.worker.submit(new PostDownloadHandler(task, future));
    }

    @Override
    protected boolean listenToSelectionChange() {
        return false;
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(this.getLayerManager().getActiveLayer() != null && !NetworkManager.isOffline(OnlineResource.OSM_API));
    }

    private static class DownloadOsmInViewTask
    extends DownloadOsmTask {
        private DownloadOsmInViewTask() {
        }

        Future<?> download(Bounds downloadArea) {
            return this.download(new DownloadOsmTask.DownloadTask(this, new DownloadParams(), new BoundingBoxDownloader(downloadArea), null, false), downloadArea);
        }
    }
}

