/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.geom.Line2D;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Objects;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IWay;
import org.openstreetmap.josm.tools.Logging;

public class IWaySegment<N extends INode, W extends IWay<N>>
implements Comparable<IWaySegment<N, W>> {
    private final W way;
    private final int lowerIndex;

    public W getWay() {
        return this.way;
    }

    public int getLowerIndex() {
        return this.lowerIndex;
    }

    public int getUpperIndex() {
        return this.lowerIndex + 1;
    }

    public IWaySegment(W w, int i) {
        this.way = w;
        this.lowerIndex = i;
        if (i < 0 || i >= w.getNodesCount() - 1) {
            throw new IllegalArgumentException(this.toString());
        }
    }

    public boolean isUsable() {
        return this.getUpperIndex() < this.way.getNodesCount();
    }

    public N getFirstNode() {
        return this.way.getNode(this.getLowerIndex());
    }

    public N getSecondNode() {
        return this.way.getNode(this.getUpperIndex());
    }

    public static <N extends INode, W extends IWay<N>> IWaySegment<N, W> forNodePair(W way, N first, N second) {
        for (int endIndex = way.getNodesCount() - 1; endIndex > 0; --endIndex) {
            int indexOfFirst = way.getNodes().subList(0, endIndex).lastIndexOf(first);
            if (!second.equals(way.getNode(indexOfFirst + 1))) continue;
            return new IWaySegment<N, W>(way, indexOfFirst);
        }
        throw new IllegalArgumentException("Node pair is not part of way!");
    }

    public W toWay() throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        IWay w;
        if (this.way.getNodes().size() == 2) {
            return this.way;
        }
        Class<?> clazz = this.way.getClass();
        try {
            Constructor<?> constructor = clazz.getConstructor(clazz);
            w = (IWay)constructor.newInstance(this.way);
        }
        catch (NoSuchMethodException e) {
            Logging.trace(e);
            Constructor<?> constructor = clazz.getConstructor(new Class[0]);
            w = (IWay)constructor.newInstance(new Object[0]);
        }
        w.setNodes(Arrays.asList(this.getFirstNode(), this.getSecondNode()));
        return (W)w;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IWaySegment that = (IWaySegment)o;
        return this.lowerIndex == that.lowerIndex && Objects.equals(this.way, that.way);
    }

    public int hashCode() {
        return Objects.hash(this.way, this.lowerIndex);
    }

    @Override
    public int compareTo(IWaySegment o) {
        IPrimitive otherWay;
        W thisWay;
        try {
            thisWay = this.toWay();
            otherWay = o == null ? null : (IPrimitive)o.toWay();
        }
        catch (ReflectiveOperationException e) {
            Logging.error(e);
            return -1;
        }
        return o == null ? -1 : (this.equals(o) ? 0 : thisWay.compareTo(otherWay));
    }

    public boolean intersects(IWaySegment<?, ?> s2) {
        if (this.getFirstNode().equals(s2.getFirstNode()) || this.getSecondNode().equals(s2.getSecondNode()) || this.getFirstNode().equals(s2.getSecondNode()) || this.getSecondNode().equals(s2.getFirstNode())) {
            return false;
        }
        return Line2D.linesIntersect(this.getFirstNode().getEastNorth().east(), this.getFirstNode().getEastNorth().north(), this.getSecondNode().getEastNorth().east(), this.getSecondNode().getEastNorth().north(), s2.getFirstNode().getEastNorth().east(), s2.getFirstNode().getEastNorth().north(), s2.getSecondNode().getEastNorth().east(), s2.getSecondNode().getEastNorth().north());
    }

    public boolean isSimilar(IWaySegment<?, ?> s2) {
        return this.getFirstNode().equals(s2.getFirstNode()) && this.getSecondNode().equals(s2.getSecondNode()) || this.getFirstNode().equals(s2.getSecondNode()) && this.getSecondNode().equals(s2.getFirstNode());
    }

    public String toString() {
        return "IWaySegment [way=" + this.way.getUniqueId() + ", lowerIndex=" + this.lowerIndex + ']';
    }
}

