/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection.proj;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.proj.AbstractProj;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class DoubleStereographic
extends AbstractProj {
    private Ellipsoid ellps;
    private double n;
    private double c;
    private double chi0;
    private double r;
    private static final double EPSILON = 1.0E-12;

    @Override
    public String getName() {
        return I18n.tr("Double Stereographic", new Object[0]);
    }

    @Override
    public String getProj4Id() {
        return "sterea";
    }

    @Override
    public void initialize(ProjParameters params) throws ProjectionConfigurationException {
        super.initialize(params);
        if (params.lat0 == null) {
            throw new ProjectionConfigurationException(I18n.tr("Parameter ''{0}'' required.", "lat_0"));
        }
        this.ellps = params.ellps;
        this.initialize(params.lat0);
    }

    private void initialize(double lat0) {
        double phi0 = Utils.toRadians(lat0);
        double e2 = this.ellps.e2;
        this.r = Math.sqrt(1.0 - e2) / (1.0 - e2 * Math.pow(Math.sin(phi0), 2.0));
        this.n = Math.sqrt(1.0 + this.ellps.eb2 * Math.pow(Math.cos(phi0), 4.0));
        double s1 = (1.0 + Math.sin(phi0)) / (1.0 - Math.sin(phi0));
        double s2 = (1.0 - this.e * Math.sin(phi0)) / (1.0 + this.e * Math.sin(phi0));
        double w1 = Math.pow(s1 * Math.pow(s2, this.e), this.n);
        double sinchi00 = (w1 - 1.0) / (w1 + 1.0);
        this.c = (this.n + Math.sin(phi0)) * (1.0 - sinchi00) / ((this.n - Math.sin(phi0)) * (1.0 + sinchi00));
        double w2 = this.c * w1;
        this.chi0 = Math.asin((w2 - 1.0) / (w2 + 1.0));
    }

    @Override
    public double[] project(double phi, double lambda) {
        double nLambda = this.n * lambda;
        double sa = (1.0 + Math.sin(phi)) / (1.0 - Math.sin(phi));
        double sb = (1.0 - this.e * Math.sin(phi)) / (1.0 + this.e * Math.sin(phi));
        double w = this.c * Math.pow(sa * Math.pow(sb, this.e), this.n);
        double chi = Math.asin((w - 1.0) / (w + 1.0));
        double b = 1.0 + Math.sin(chi) * Math.sin(this.chi0) + Math.cos(chi) * Math.cos(this.chi0) * Math.cos(nLambda);
        double x = 2.0 * this.r * Math.cos(chi) * Math.sin(nLambda) / b;
        double y = 2.0 * this.r * (Math.sin(chi) * Math.cos(this.chi0) - Math.cos(chi) * Math.sin(this.chi0) * Math.cos(nLambda)) / b;
        return new double[]{x, y};
    }

    @Override
    public double[] invproject(double x, double y) {
        double e2 = this.ellps.e2;
        double g = 2.0 * this.r * Math.tan(0.7853981633974483 - this.chi0 / 2.0);
        double h = 4.0 * this.r * Math.tan(this.chi0) + g;
        double i = Math.atan(x / (h + y));
        double j = Math.atan(x / (g - y)) - i;
        double chi = this.chi0 + 2.0 * Math.atan((y - x * Math.tan(j / 2.0)) / (2.0 * this.r));
        double lambda = (j + 2.0 * i) / this.n;
        double psi = 0.5 * Math.log((1.0 + Math.sin(chi)) / (this.c * (1.0 - Math.sin(chi)))) / this.n;
        double phiprev = -1000.0;
        int iteration = 0;
        double phi = 2.0 * Math.atan(Math.exp(psi)) - 1.5707963267948966;
        while (Math.abs(phi - phiprev) > 1.0E-12) {
            if (++iteration > 10) {
                throw new IllegalStateException("Too many iterations");
            }
            phiprev = phi;
            double psii = Math.log(Math.tan(phi / 2.0 + 0.7853981633974483) * Math.pow((1.0 - this.e * Math.sin(phi)) / (1.0 + this.e * Math.sin(phi)), this.e / 2.0));
            phi -= (psii - psi) * Math.cos(phi) * (1.0 - e2 * Math.pow(Math.sin(phi), 2.0)) / (1.0 - e2);
        }
        return new double[]{phi, lambda};
    }

    @Override
    public Bounds getAlgorithmBounds() {
        return new Bounds(-89.0, -87.0, 89.0, 87.0, false);
    }
}

