/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.layer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainFrame;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.IEnabledStateUpdating;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.imagery.ImageryFilterSettings;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;

public final class LayerVisibilityAction
extends AbstractAction
implements IEnabledStateUpdating,
Layer.LayerAction {
    private static final String DIALOGS_LAYERLIST = "dialogs/layerlist";
    private static final int SLIDER_STEPS = 100;
    private static final int SLIDER_WHEEL_INCREMENT = 5;
    private static final double DEFAULT_OPACITY = 1.0;
    private static final double DEFAULT_GAMMA_VALUE = 0.0;
    private static final double DEFAULT_SHARPNESS_FACTOR = 1.0;
    private static final double MAX_SHARPNESS_FACTOR = 2.0;
    private static final double DEFAULT_COLORFUL_FACTOR = 1.0;
    private static final double MAX_COLORFUL_FACTOR = 2.0;
    private final Supplier<Collection<Layer>> layerSupplier;
    private final Supplier<Collection<ImageryFilterSettings>> filterSettingsSupplier;
    private final JPopupMenu popup;
    private SideButton sideButton;
    final JPanel content = new JPanel();
    final List<VisibilityMenuEntry> sliders = new ArrayList<VisibilityMenuEntry>();

    public LayerVisibilityAction(LayerListDialog.LayerListModel model) {
        this(model::getSelectedLayers, () -> Utils.transform(Utils.filteredCollection(model.getSelectedLayers(), ImageryLayer.class), ImageryLayer::getFilterSettings));
    }

    public LayerVisibilityAction(Supplier<Collection<Layer>> layerSupplier, Supplier<Collection<ImageryFilterSettings>> filterSettingsSupplier) {
        this.layerSupplier = layerSupplier;
        this.filterSettingsSupplier = filterSettingsSupplier;
        this.popup = new JPopupMenu();
        this.popup.addMouseWheelListener(InputEvent::consume);
        this.popup.add(this.content);
        this.content.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.content.setLayout(new GridBagLayout());
        new ImageProvider(DIALOGS_LAYERLIST, "visibility").getResource().attachImageIcon(this, true);
        this.putValue("ShortDescription", I18n.tr("Change visibility.", new Object[0]));
        this.addContentEntry(new VisibilityCheckbox());
        this.addContentEntry(new OpacitySlider());
        this.addContentEntry(new ColorfulnessSlider());
        this.addContentEntry(new GammaFilterSlider());
        this.addContentEntry(new SharpnessSlider());
        this.addContentEntry(new ColorSelector());
    }

    private void addContentEntry(VisibilityMenuEntry slider) {
        this.content.add((Component)slider.getPanel(), GBC.eop().fill(2));
        this.sliders.add(slider);
    }

    void setVisibleFlag(boolean visible) {
        for (Layer l : this.layerSupplier.get()) {
            l.setVisible(visible);
        }
        this.updateValues();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateValues();
        if (e.getSource() == this.sideButton) {
            if (this.sideButton.isShowing()) {
                this.popup.show(this.sideButton, 0, this.sideButton.getHeight());
            }
        } else {
            MainFrame mainFrame = MainApplication.getMainFrame();
            if (mainFrame.isShowing()) {
                this.popup.show(mainFrame, mainFrame.getWidth() / 2, (mainFrame.getHeight() - this.popup.getHeight()) / 2);
            }
        }
    }

    void updateValues() {
        for (VisibilityMenuEntry slider : this.sliders) {
            slider.updateValue();
        }
    }

    @Override
    public boolean supportLayers(List<Layer> layers) {
        return !layers.isEmpty();
    }

    @Override
    public Component createMenuComponent() {
        return new JMenuItem(this);
    }

    @Override
    public void updateEnabledState() {
        this.setEnabled(!this.layerSupplier.get().isEmpty() || !this.filterSettingsSupplier.get().isEmpty());
    }

    public void setCorrespondingSideButton(SideButton sideButton) {
        this.sideButton = sideButton;
    }

    private class ColorSelector
    extends JPanel
    implements VisibilityMenuEntry {
        private final Border NORMAL_BORDER;
        private final Border SELECTED_BORDER;
        private final Color[] COLORS;
        private final HashMap<Color, JPanel> panels;

        ColorSelector() {
            super(new GridBagLayout());
            this.NORMAL_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
            this.SELECTED_BORDER = BorderFactory.createLineBorder(Color.BLACK, 2);
            this.COLORS = new Color[]{Color.RED, Color.ORANGE, Color.YELLOW, Color.GREEN, Color.BLUE, Color.CYAN, Color.GRAY};
            this.panels = new HashMap();
            this.add((Component)new JLabel(I18n.tr("Color", new Object[0])), GBC.eol().insets(34, 0, 0, 0));
            for (Color color : this.COLORS) {
                this.addPanelForColor(color);
            }
        }

        private void addPanelForColor(final Color color) {
            JPanel innerPanel = new JPanel();
            innerPanel.setBackground(color);
            JPanel colorPanel = new JPanel(new BorderLayout());
            colorPanel.setBorder(this.NORMAL_BORDER);
            colorPanel.add(innerPanel);
            colorPanel.setMinimumSize(new Dimension(20, 20));
            colorPanel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Collection layers = (Collection)LayerVisibilityAction.this.layerSupplier.get();
                    for (Layer l : layers) {
                        l.setColor(color);
                    }
                    ColorSelector.this.highlightColor(color);
                }
            });
            this.add((Component)colorPanel, GBC.std().weight(1.0, 1.0).fill().insets(5));
            this.panels.put(color, colorPanel);
            List<Color> colors = this.getColors();
            if (colors.size() == 1) {
                this.highlightColor(colors.get(0));
            }
        }

        private List<Color> getColors() {
            return ((Collection)LayerVisibilityAction.this.layerSupplier.get()).stream().map(Layer::getColor).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        }

        @Override
        public void updateValue() {
            List<Color> colors = this.getColors();
            if (colors.size() == 1) {
                this.setVisible(true);
                this.highlightColor(colors.get(0));
            } else if (colors.size() > 1) {
                this.setVisible(true);
                this.highlightColor(null);
            } else {
                this.setVisible(false);
            }
        }

        private void highlightColor(Color color) {
            JPanel selected;
            this.panels.values().forEach(panel -> panel.setBorder(this.NORMAL_BORDER));
            if (color != null && (selected = this.panels.get(color)) != null) {
                selected.setBorder(this.SELECTED_BORDER);
            }
            this.repaint();
        }

        @Override
        public JComponent getPanel() {
            return this;
        }
    }

    private class ColorfulnessSlider
    extends AbstractFilterSlider {
        ColorfulnessSlider() {
            super(0.0, 2.0, 1.0);
            this.setLabels(I18n.trc("image colorfulness", "less"), I18n.trc("image colorfulness", "normal"), I18n.trc("image colorfulness", "more"));
            this.slider.setToolTipText(I18n.tr("Adjust colorfulness.", new Object[0]) + " " + I18n.tr("Double click to reset.", new Object[0]));
        }

        @Override
        public void updateValue() {
            Collection settings = (Collection)LayerVisibilityAction.this.filterSettingsSupplier.get();
            this.setVisible(!settings.isEmpty());
            if (!settings.isEmpty()) {
                this.setRealValue(((ImageryFilterSettings)settings.iterator().next()).getColorfulness());
            }
        }

        @Override
        protected void onStateChanged() {
            for (ImageryFilterSettings settings : (Collection)LayerVisibilityAction.this.filterSettingsSupplier.get()) {
                settings.setColorfulness(this.getRealValue());
            }
        }

        @Override
        public ImageIcon getIcon() {
            return ImageProvider.get(LayerVisibilityAction.DIALOGS_LAYERLIST, "colorfulness");
        }

        @Override
        public String getLabel() {
            return I18n.tr("Colorfulness", new Object[0]);
        }
    }

    private class SharpnessSlider
    extends AbstractFilterSlider {
        SharpnessSlider() {
            super(0.0, 2.0, 1.0);
            this.setLabels(I18n.trc("image sharpness", "blurred"), I18n.trc("image sharpness", "normal"), I18n.trc("image sharpness", "sharp"));
            this.slider.setToolTipText(I18n.tr("Adjust sharpness/blur value.", new Object[0]) + " " + I18n.tr("Double click to reset.", new Object[0]));
        }

        @Override
        public void updateValue() {
            Collection settings = (Collection)LayerVisibilityAction.this.filterSettingsSupplier.get();
            this.setVisible(!settings.isEmpty());
            if (!settings.isEmpty()) {
                this.setRealValue(((ImageryFilterSettings)settings.iterator().next()).getSharpenLevel());
            }
        }

        @Override
        protected void onStateChanged() {
            for (ImageryFilterSettings settings : (Collection)LayerVisibilityAction.this.filterSettingsSupplier.get()) {
                settings.setSharpenLevel(this.getRealValue());
            }
        }

        @Override
        public ImageIcon getIcon() {
            return ImageProvider.get(LayerVisibilityAction.DIALOGS_LAYERLIST, "sharpness");
        }

        @Override
        public String getLabel() {
            return I18n.tr("Sharpness", new Object[0]);
        }
    }

    private class GammaFilterSlider
    extends AbstractFilterSlider {
        GammaFilterSlider() {
            super(-1.0, 1.0, 0.0);
            this.setLabels("0", "1", "\u221e");
            this.slider.setToolTipText(I18n.tr("Adjust gamma value.", new Object[0]) + " " + I18n.tr("Double click to reset.", new Object[0]));
        }

        @Override
        public void updateValue() {
            Collection settings = (Collection)LayerVisibilityAction.this.filterSettingsSupplier.get();
            this.setVisible(!settings.isEmpty());
            if (!settings.isEmpty()) {
                double gamma = ((ImageryFilterSettings)settings.iterator().next()).getGamma();
                this.setRealValue(this.mapGammaToInterval(gamma));
            }
        }

        @Override
        protected void onStateChanged() {
            for (ImageryFilterSettings settings : (Collection)LayerVisibilityAction.this.filterSettingsSupplier.get()) {
                settings.setGamma(this.mapIntervalToGamma(this.getRealValue()));
            }
        }

        @Override
        public ImageIcon getIcon() {
            return ImageProvider.get(LayerVisibilityAction.DIALOGS_LAYERLIST, "gamma");
        }

        @Override
        public String getLabel() {
            return I18n.tr("Gamma", new Object[0]);
        }

        private double mapIntervalToGamma(double x) {
            return (1.0 + x) / (1.0 - x);
        }

        private double mapGammaToInterval(double gamma) {
            return (gamma - 1.0) / (gamma + 1.0);
        }
    }

    class OpacitySlider
    extends AbstractFilterSlider {
        OpacitySlider() {
            super(0.0, 1.0, 1.0);
            this.setLabels("0%", "50%", "100%");
            this.slider.setToolTipText(I18n.tr("Adjust opacity of the layer.", new Object[0]) + " " + I18n.tr("Double click to reset.", new Object[0]));
        }

        @Override
        protected void onStateChanged() {
            if (this.getRealValue() <= 0.001 && !this.slider.getValueIsAdjusting()) {
                LayerVisibilityAction.this.setVisibleFlag(false);
            } else {
                for (Layer layer : (Collection)LayerVisibilityAction.this.layerSupplier.get()) {
                    layer.setOpacity(this.getRealValue());
                }
            }
        }

        @Override
        protected void mouseWheelMoved(MouseWheelEvent e) {
            if (!this.isEnabled() && !((Collection)LayerVisibilityAction.this.layerSupplier.get()).isEmpty() && e.getPreciseWheelRotation() < 0.0) {
                e.consume();
                LayerVisibilityAction.this.setVisibleFlag(true);
            } else {
                super.mouseWheelMoved(e);
            }
        }

        @Override
        public void updateValue() {
            Collection usedLayers = (Collection)LayerVisibilityAction.this.layerSupplier.get();
            this.setVisible(!usedLayers.isEmpty());
            if (usedLayers.stream().noneMatch(Layer::isVisible)) {
                this.slider.setEnabled(false);
                return;
            }
            this.slider.setEnabled(true);
            double opacity = usedLayers.stream().mapToDouble(Layer::getOpacity).sum();
            if ((opacity /= (double)usedLayers.size()) == 0.0) {
                opacity = 1.0;
                LayerVisibilityAction.this.setVisibleFlag(true);
            }
            this.setRealValue(opacity);
        }

        @Override
        public String getLabel() {
            return I18n.tr("Opacity", new Object[0]);
        }

        @Override
        public ImageIcon getIcon() {
            return ImageProvider.get(LayerVisibilityAction.DIALOGS_LAYERLIST, "transparency");
        }

        @Override
        public String toString() {
            return "OpacitySlider [getRealValue()=" + this.getRealValue() + ']';
        }
    }

    private static abstract class AbstractFilterSlider
    extends JPanel
    implements VisibilityMenuEntry {
        private final double minValue;
        private final double maxValue;
        protected final JSlider slider = new JSlider(0);

        AbstractFilterSlider(double minValue, double maxValue, final double defaultValue) {
            super(new GridBagLayout());
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.add((Component)new JLabel(this.getIcon()), GBC.std().span(1, 2).insets(0, 0, 5, 0));
            this.add((Component)new JLabel(this.getLabel()), GBC.eol().insets(5, 0, 5, 0));
            this.add((Component)this.slider, GBC.eol());
            this.addMouseWheelListener(this::mouseWheelMoved);
            this.slider.setMaximum(100);
            int tick = this.convertFromRealValue(1.0);
            this.slider.setMinorTickSpacing(tick);
            this.slider.setMajorTickSpacing(tick);
            this.slider.setPaintTicks(true);
            this.slider.addChangeListener(e -> this.onStateChanged());
            this.slider.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e != null && SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
                        this.setRealValue(defaultValue);
                    }
                }
            });
        }

        protected void setLabels(String labelMinimum, String labelMiddle, String labelMaximum) {
            Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
            ((Dictionary)labels).put(this.slider.getMinimum(), new JLabel(labelMinimum));
            ((Dictionary)labels).put((this.slider.getMaximum() + this.slider.getMinimum()) / 2, new JLabel(labelMiddle));
            ((Dictionary)labels).put(this.slider.getMaximum(), new JLabel(labelMaximum));
            this.slider.setLabelTable(labels);
            this.slider.setPaintLabels(true);
        }

        protected abstract void onStateChanged();

        protected void mouseWheelMoved(MouseWheelEvent e) {
            e.consume();
            if (!this.isEnabled()) {
                return;
            }
            double rotation = -1.0 * e.getPreciseWheelRotation();
            double destinationValue = (double)this.slider.getValue() + rotation * 5.0;
            destinationValue = rotation < 0.0 ? Math.floor(destinationValue) : Math.ceil(destinationValue);
            this.slider.setValue(Utils.clamp((int)destinationValue, this.slider.getMinimum(), this.slider.getMaximum()));
        }

        protected double getRealValue() {
            return this.convertToRealValue(this.slider.getValue());
        }

        protected double convertToRealValue(int value) {
            double s = (double)value / 100.0;
            return s * this.maxValue + (1.0 - s) * this.minValue;
        }

        protected void setRealValue(double value) {
            this.slider.setValue(this.convertFromRealValue(value));
        }

        protected int convertFromRealValue(double value) {
            int i = (int)((value - this.minValue) / (this.maxValue - this.minValue) * 100.0 + 0.5);
            return Utils.clamp(i, this.slider.getMinimum(), this.slider.getMaximum());
        }

        public abstract ImageIcon getIcon();

        public abstract String getLabel();

        @Override
        public JComponent getPanel() {
            return this;
        }
    }

    private class VisibilityCheckbox
    extends JCheckBox
    implements VisibilityMenuEntry {
        VisibilityCheckbox() {
            super(I18n.tr("Show layer", new Object[0]));
            Icon icon = UIManager.getIcon("CheckBox.icon");
            int iconWidth = icon == null ? 20 : icon.getIconWidth();
            this.setBorder(BorderFactory.createEmptyBorder(0, Math.max(29 - iconWidth, 0), 0, 0));
            this.addChangeListener(e -> LayerVisibilityAction.this.setVisibleFlag(this.isSelected()));
        }

        @Override
        public void updateValue() {
            Collection layers = (Collection)LayerVisibilityAction.this.layerSupplier.get();
            boolean allVisible = layers.stream().allMatch(Layer::isVisible);
            boolean allHidden = layers.stream().noneMatch(Layer::isVisible);
            this.setVisible(!layers.isEmpty());
            this.setSelected(allVisible && !allHidden);
        }

        @Override
        public JComponent getPanel() {
            return this;
        }
    }

    protected static interface VisibilityMenuEntry {
        public void updateValue();

        public JComponent getPanel();
    }
}

