/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFile;
import org.jetbrains.kotlin.descriptors.impl.EmptyPackageFragmentDescriptor;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrFileImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrFileSymbolImpl;
import org.jetbrains.kotlin.ir.util.NaiveSourceBasedFileEntryImpl;
import org.jetbrains.kotlin.library.encodings.WobblyTF8;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0003\u001a\u001a\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001a\u0010\u0007\u001a\u00020\b*\u00020\u00022\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0000\u001a\u0014\u0010\f\u001a\u00020\b*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000bH\u0000\u00a8\u0006\u000e"}, d2={"createFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "module", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "fileProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFile;", "deserializeFqName", "", "fqn", "", "", "deserializeString", "index", "ir.serialization.common"})
public final class IrFileDeserializerKt {
    @NotNull
    public static final String deserializeString(@NotNull IrLibraryFile $this$deserializeString, int index2) {
        Intrinsics.checkNotNullParameter($this$deserializeString, "<this>");
        return WobblyTF8.INSTANCE.decode($this$deserializeString.string(index2));
    }

    @NotNull
    public static final String deserializeFqName(@NotNull IrLibraryFile $this$deserializeFqName, @NotNull List<Integer> fqn) {
        Intrinsics.checkNotNullParameter($this$deserializeFqName, "<this>");
        Intrinsics.checkNotNullParameter(fqn, "fqn");
        return CollectionsKt.joinToString$default(fqn, ".", null, null, 0, null, new Function1<Integer, String>((Object)$this$deserializeFqName){

            @NotNull
            public final String invoke(int p0) {
                return IrFileDeserializerKt.deserializeString((IrLibraryFile)this.receiver, p0);
            }

            @NotNull
            public final String getSignature() {
                return "deserializeString(Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;I)Ljava/lang/String;";
            }

            @NotNull
            public final String getName() {
                return "deserializeString";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinPackage(IrFileDeserializerKt.class, "ir.serialization.common");
            }
        }, 30, null);
    }

    @NotNull
    public static final org.jetbrains.kotlin.ir.declarations.IrFile createFile(@NotNull IrLibraryFile $this$createFile, @NotNull IrModuleFragment module2, @NotNull IrFile fileProto) {
        Intrinsics.checkNotNullParameter($this$createFile, "<this>");
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(fileProto, "fileProto");
        String fileName = fileProto.getFileEntry().getName();
        Intrinsics.checkNotNullExpressionValue(fileName, "fileName");
        List<Integer> list2 = fileProto.getFileEntry().getLineStartOffsetList();
        Intrinsics.checkNotNullExpressionValue(list2, "fileProto.fileEntry.lineStartOffsetList");
        NaiveSourceBasedFileEntryImpl fileEntry = new NaiveSourceBasedFileEntryImpl(fileName, CollectionsKt.toIntArray((Collection<Integer>)list2));
        List<Integer> list3 = fileProto.getFqNameList();
        Intrinsics.checkNotNullExpressionValue(list3, "fileProto.fqNameList");
        FqName fqName2 = new FqName(IrFileDeserializerKt.deserializeFqName($this$createFile, list3));
        EmptyPackageFragmentDescriptor packageFragmentDescriptor = new EmptyPackageFragmentDescriptor(module2.getDescriptor(), fqName2);
        IrFileSymbolImpl symbol2 = new IrFileSymbolImpl(packageFragmentDescriptor);
        return new IrFileImpl(fileEntry, symbol2, fqName2, module2);
    }
}

