/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.Complex;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.Wrapper;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.capitalizeDecapitalize.CapitalizeDecapitalizeKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u001eH\u0002J\u0010\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010#\u001a\u00020\u001eJ\b\u0010&\u001a\u00020\"H\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0000X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "Lorg/jetbrains/kotlin/ir/interpreter/state/Complex;", "value", "", "(Ljava/lang/Object;)V", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "fields", "", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "getFields", "()Ljava/util/List;", "getIrClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "outerClass", "getOuterClass", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "setOuterClass", "(Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;)V", "receiverClass", "Ljava/lang/Class;", "superWrapperClass", "getSuperWrapperClass", "()Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "setSuperWrapperClass", "(Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;)V", "getValue", "()Ljava/lang/Object;", "getIrFunctionByIrCall", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "getJavaOriginalName", "", "irFunction", "getMethod", "Ljava/lang/invoke/MethodHandle;", "toString", "Companion", "ir.interpreter"})
public final class Wrapper
implements Complex {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Object value;
    @NotNull
    private final IrClass irClass;
    @NotNull
    private final List<Variable> fields;
    @Nullable
    private Wrapper superWrapperClass;
    @Nullable
    private Variable outerClass;
    @NotNull
    private final Class<? extends Object> receiverClass;
    @NotNull
    private static final Map<String, Object> companionObjectValue = MapsKt.mapOf(TuplesKt.to("kotlin.text.Regex$Companion", Regex.Companion));
    @NotNull
    private static final Map<Class<?>, IrClass> javaClassToIrClass;
    @NotNull
    private static final Set<String> intrinsicClasses;
    @NotNull
    private static final Map<String, String> intrinsicFunctionToHandler;

    /*
     * WARNING - void declaration
     */
    public Wrapper(@NotNull Object value2, @NotNull IrClass irClass2) {
        Object object;
        Object mutableMap;
        Object $this$single$iv;
        Iterable $this$mapNotNull$iv;
        Object[] $this$single$iv2;
        Object object2;
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(irClass2, "irClass");
        this.value = value2;
        this.irClass = irClass2;
        boolean bl = false;
        this.fields = new ArrayList();
        this.receiverClass = Wrapper.Companion.getClass(IrUtilsKt.getDefaultType(this.getIrClass()), true);
        Class<?> javaClass = this.value.getClass();
        if (Intrinsics.areEqual(javaClass, HashMap.class)) {
            void $this$filterIsInstanceTo$iv$iv;
            Pair $this$filterIsInstance$iv;
            void $this$mapNotNullTo$iv$iv;
            Object it;
            object2 = javaClass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(object2, "javaClass.declaredClasses");
            $this$single$iv2 = (Object[])object2;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv22 = false;
            for (Object element$iv : $this$single$iv2) {
                it = (Class)element$iv;
                boolean bl2 = false;
                String string2 = ((Class)it).getName();
                Intrinsics.checkNotNullExpressionValue(string2, "it.name");
                if (!StringsKt.contains$default((CharSequence)string2, "$Node", false, 2, null)) continue;
                if (found$iv22) {
                    throw (Throwable)new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv22 = true;
            }
            if (!found$iv22) {
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Class nodeClass = (Class)single$iv;
            $this$mapNotNull$iv = this.getIrClass().getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable found$iv22 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo22 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            it = $this$forEach$iv$iv$iv.iterator();
            while (it.hasNext()) {
                IrClass irClass3;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = it.next();
                boolean bl3 = false;
                IrType it2 = (IrType)element$iv$iv;
                boolean bl4 = false;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it2);
                if ((irClassSymbol == null ? null : (IrClass)irClassSymbol.getOwner()) == null) continue;
                irClass3 = irClass3;
                boolean bl5 = false;
                boolean bl6 = false;
                IrClass it$iv$iv = irClass3;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$single22 = false;
            Iterable single$iv2 = null;
            boolean found$iv = false;
            Iterator $i$f$mapNotNullTo22 = $this$single$iv.iterator();
            while ($i$f$mapNotNullTo22.hasNext()) {
                Object element$iv = $i$f$mapNotNullTo22.next();
                IrClass it3 = (IrClass)element$iv;
                boolean bl8 = false;
                if (!IrUtilsKt.isInterface(it3)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv2 = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            mutableMap = (IrClass)((Object)single$iv2);
            $this$single$iv = Companion;
            Map<Class<?>, IrClass> $i$f$single22 = javaClassToIrClass;
            single$iv2 = mutableMap.getDeclarations();
            Class clazz = nodeClass;
            boolean $i$f$filterIsInstance = false;
            $i$f$mapNotNullTo22 = $this$filterIsInstance$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List list2 = (List)destination$iv$iv2;
            $this$filterIsInstance$iv = TuplesKt.to(clazz, CollectionsKt.single(list2));
            $i$f$filterIsInstance = false;
            $i$f$single22.put($this$filterIsInstance$iv.getFirst(), (IrClass)$this$filterIsInstance$iv.getSecond());
        } else if (Intrinsics.areEqual(javaClass, LinkedHashMap.class)) {
            void $this$filterIsInstanceTo$iv$iv;
            Pair $this$filterIsInstance$iv2;
            void $this$mapNotNullTo$iv$iv;
            String element$iv$iv;
            mutableMap = javaClass.getDeclaredClasses();
            Intrinsics.checkNotNullExpressionValue(mutableMap, "javaClass.declaredClasses");
            $this$single$iv2 = (Object[])mutableMap;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv32 = false;
            for (Object element$iv : $this$single$iv2) {
                Class it = (Class)element$iv;
                boolean bl9 = false;
                element$iv$iv = it.getName();
                Intrinsics.checkNotNullExpressionValue(element$iv$iv, "it.name");
                if (!StringsKt.contains$default((CharSequence)element$iv$iv, "$Entry", false, 2, null)) continue;
                if (found$iv32) {
                    throw (Throwable)new IllegalArgumentException("Array contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv32 = true;
            }
            if (!found$iv32) {
                throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
            }
            Class entryClass = (Class)single$iv;
            $this$mapNotNull$iv = this.getIrClass().getSuperTypes();
            boolean $i$f$mapNotNull = false;
            Iterable found$iv32 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo32 = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv$iv : $this$forEach$iv$iv$iv) {
                IrClass irClass4;
                element$iv$iv = element$iv$iv$iv;
                boolean bl10 = false;
                IrType it = (IrType)((Object)element$iv$iv);
                boolean bl11 = false;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(it);
                if ((irClassSymbol == null ? null : (IrClass)irClassSymbol.getOwner()) == null) continue;
                irClass4 = irClass4;
                boolean bl12 = false;
                boolean bl13 = false;
                IrClass it$iv$iv = irClass4;
                boolean bl14 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$single32 = false;
            Iterable single$iv3 = null;
            boolean found$iv = false;
            Iterator $i$f$mapNotNullTo32 = $this$single$iv.iterator();
            while ($i$f$mapNotNullTo32.hasNext()) {
                Object element$iv = $i$f$mapNotNullTo32.next();
                IrClass it = (IrClass)element$iv;
                boolean bl15 = false;
                if (!IrUtilsKt.isInterface(it)) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv3 = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            mutableMap = (IrClass)((Object)single$iv3);
            $this$single$iv = Companion;
            Map<Class<?>, IrClass> $i$f$single32 = javaClassToIrClass;
            single$iv3 = mutableMap.getDeclarations();
            Class clazz = entryClass;
            boolean $i$f$filterIsInstance = false;
            $i$f$mapNotNullTo32 = $this$filterIsInstance$iv2;
            Collection destination$iv$iv3 = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof IrClass)) continue;
                destination$iv$iv3.add(element$iv$iv2);
            }
            List list3 = (List)destination$iv$iv3;
            $this$filterIsInstance$iv2 = TuplesKt.to(clazz, CollectionsKt.single(list3));
            $i$f$filterIsInstance = false;
            $i$f$single32.put($this$filterIsInstance$iv2.getFirst(), (IrClass)$this$filterIsInstance$iv2.getSecond());
        } else if (Intrinsics.areEqual(javaClass.getCanonicalName(), "java.util.Collections.SingletonMap")) {
            Object element$iv$iv;
            Object $this$filterIsInstanceTo$iv$iv;
            Object $this$filterIsInstance$iv;
            object = Companion;
            object2 = javaClassToIrClass;
            $this$single$iv = this.getIrClass().getDeclarations();
            Class clazz = AbstractMap.SimpleEntry.class;
            boolean $i$f$filterIsInstance = false;
            void $this$filterIsInstance$iv2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list4 = (List)destination$iv$iv;
            $this$filterIsInstance$iv = TuplesKt.to(clazz, CollectionsKt.single(list4));
            $i$f$filterIsInstance = false;
            object2.put(((Pair)$this$filterIsInstance$iv).getFirst(), ((Pair)$this$filterIsInstance$iv).getSecond());
            object = Companion;
            object2 = javaClassToIrClass;
            $this$filterIsInstance$iv = this.getIrClass().getDeclarations();
            clazz = AbstractMap.SimpleImmutableEntry.class;
            $i$f$filterIsInstance = false;
            $this$filterIsInstanceTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterIsInstanceTo = false;
            iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv$iv = iterator2.next();
                if (!(element$iv$iv instanceof IrClass)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list4 = (List)destination$iv$iv;
            Pair pair = TuplesKt.to(clazz, CollectionsKt.single(list4));
            $i$f$filterIsInstance = false;
            object2.put(pair.getFirst(), pair.getSecond());
        }
        object = javaClassToIrClass.get(this.value.getClass());
        boolean bl16 = false;
        boolean bl17 = false;
        IrClass it = (IrClass)object;
        boolean bl18 = false;
        boolean bl19 = it == null || IrUtilsKt.isSubclassOf(this.getIrClass(), it);
        if (bl19) {
            object = javaClassToIrClass;
            Class<?> clazz = this.value.getClass();
            IrClass irClass5 = this.getIrClass();
            boolean bl20 = false;
            object.put(clazz, (IrClass)irClass5);
        }
    }

    @NotNull
    public final Object getValue() {
        return this.value;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    @Override
    @NotNull
    public List<Variable> getFields() {
        return this.fields;
    }

    @Override
    @Nullable
    public Wrapper getSuperWrapperClass() {
        return this.superWrapperClass;
    }

    @Override
    public void setSuperWrapperClass(@Nullable Wrapper wrapper) {
        this.superWrapperClass = wrapper;
    }

    @Override
    @Nullable
    public Variable getOuterClass() {
        return this.outerClass;
    }

    @Override
    public void setOuterClass(@Nullable Variable variable2) {
        this.outerClass = variable2;
    }

    public Wrapper(@NotNull Object value2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        IrClass irClass2 = javaClassToIrClass.get(value2.getClass());
        Intrinsics.checkNotNull(irClass2);
        this(value2, irClass2);
    }

    @Override
    @Nullable
    public IrFunction getIrFunctionByIrCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MethodHandle getMethod(@NotNull IrFunction irFunction2) {
        Object object;
        Object v2;
        Object object2;
        block7: {
            void $this$firstOrNull$iv;
            IrProperty irProperty2;
            Object object3;
            IrSimpleFunction irSimpleFunction;
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            IrSimpleFunction irSimpleFunction2 = irSimpleFunction = irFunction2 instanceof IrSimpleFunction ? (IrSimpleFunction)irFunction2 : null;
            String propertyName = irSimpleFunction == null ? null : ((object3 = irSimpleFunction.getCorrespondingPropertySymbol()) == null ? null : ((irProperty2 = (IrProperty)object3.getOwner()) == null ? null : ((object2 = irProperty2.getName()) == null ? null : ((Name)object2).asString())));
            object3 = new String[2];
            object3[0] = propertyName;
            irProperty2 = propertyName;
            object3[1] = Intrinsics.stringPlus("get", irProperty2 == null ? null : CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)((Object)irProperty2)));
            object3 = CollectionsKt.listOfNotNull(object3);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block6: {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    Method[] methodArray = this.receiverClass.getMethods();
                    Intrinsics.checkNotNullExpressionValue(methodArray, "receiverClass.methods");
                    Object[] $this$any$iv = methodArray;
                    boolean $i$f$any = false;
                    for (Object element$iv2 : $this$any$iv) {
                        Method method = (Method)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(method.getName(), it)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
                if (!bl) continue;
                v2 = element$iv;
                break block7;
            }
            v2 = null;
        }
        String propertyCall = v2;
        String intrinsicName = this.getJavaOriginalName(irFunction2);
        object2 = intrinsicName;
        if (object2 == null) {
            String string2 = propertyCall;
            if (string2 == null) {
                String string3 = irFunction2.getName().toString();
                Intrinsics.checkNotNullExpressionValue(string3, "irFunction.name.toString()");
                object = string3;
            } else {
                object = string2;
            }
        } else {
            object = object2;
        }
        Object methodName = object;
        MethodType methodType = Wrapper.Companion.getMethodType(irFunction2);
        return MethodHandles.lookup().findVirtual(this.receiverClass, (String)methodName, methodType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String getJavaOriginalName(IrFunction irFunction2) {
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(UtilsKt.getLastOverridden(irFunction2));
        if (fqName2 == null) {
            return null;
        }
        String string2 = fqName2.asString();
        String string3 = string2;
        if (string3 == null) return null;
        int n = -1;
        switch (string3.hashCode()) {
            case 73906511: {
                if (string3.equals("kotlin.collections.Map.<get-keys>")) {
                    n = 1;
                }
                break;
            }
            case -1544237172: {
                if (string3.equals("kotlin.CharSequence.get")) {
                    n = 2;
                }
                break;
            }
            case 113597193: {
                if (string3.equals("kotlin.collections.Map.<get-entries>")) {
                    n = 3;
                }
                break;
            }
            case 2038007751: {
                if (string3.equals("kotlin.collections.MutableList.removeAt")) {
                    n = 4;
                }
                break;
            }
        }
        switch (n) {
            case 3: {
                return "entrySet";
            }
            case 1: {
                return "keySet";
            }
            case 2: {
                return "charAt";
            }
            case 4: {
                return "remove";
            }
            default: {
                return null;
            }
        }
    }

    @NotNull
    public String toString() {
        return this.value.toString();
    }

    @Override
    @Nullable
    public State getField(@NotNull IrSymbol symbol2) {
        return Complex.DefaultImpls.getField(this, symbol2);
    }

    @Override
    @NotNull
    public IrSimpleFunction getOverridden(@NotNull IrSimpleFunction owner) {
        return Complex.DefaultImpls.getOverridden(this, owner);
    }

    @Override
    @NotNull
    public String irClassFqName() {
        return Complex.DefaultImpls.irClassFqName(this);
    }

    @Override
    public void setField(@NotNull Variable newVar) {
        Complex.DefaultImpls.setField(this, newVar);
    }

    static {
        boolean bl = false;
        javaClassToIrClass = new LinkedHashMap();
        Object[] objectArray = new String[]{"kotlin.text.StringBuilder", "kotlin.Pair", "kotlin.collections.HashMap", "kotlin.text.RegexOption", "kotlin.text.Regex", "kotlin.text.Regex.Companion", "kotlin.text.MatchGroup"};
        intrinsicClasses = SetsKt.setOf(objectArray);
        objectArray = new Pair[]{TuplesKt.to("Array.kotlin.collections.asList()", "kotlin.collections.ArraysKt"), TuplesKt.to("kotlin.collections.mutableListOf(Array)", "kotlin.collections.CollectionsKt"), TuplesKt.to("kotlin.collections.arrayListOf(Array)", "kotlin.collections.CollectionsKt"), TuplesKt.to("Char.kotlin.text.isWhitespace()", "kotlin.text.CharsKt"), TuplesKt.to("Array.kotlin.collections.toMutableList()", "kotlin.collections.ArraysKt")};
        intrinsicFunctionToHandler = MapsKt.mapOf(objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u0010\u001a\u00020\fJ\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\fJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\fJ\u000e\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0016J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u001a\u001a\u00020\u0016J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u001c\u0010#\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000b*\u00020$2\u0006\u0010%\u001a\u00020 H\u0002J\u000e\u0010&\u001a\u0004\u0018\u00010\u0005*\u00020\u0016H\u0002J\f\u0010'\u001a\u00020(*\u00020\u0016H\u0002J\u0012\u0010)\u001a\b\u0012\u0004\u0012\u00020+0**\u00020\u0016H\u0002J\u000e\u0010,\u001a\u0004\u0018\u00010\u0005*\u00020\"H\u0002J\f\u0010-\u001a\u00020 *\u00020\u0016H\u0002J\f\u0010.\u001a\u00020 *\u00020\u0016H\u0002J\u0014\u0010/\u001a\u00020 *\u00020\u00162\u0006\u00100\u001a\u000201H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper$Companion;", "", "()V", "companionObjectValue", "", "", "intrinsicClasses", "", "intrinsicFunctionToHandler", "javaClassToIrClass", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "associateJavaClassWithIrClass", "", "javaClass", "irClass", "getCompanionObject", "Lorg/jetbrains/kotlin/ir/interpreter/state/Wrapper;", "getConstructorMethod", "Ljava/lang/invoke/MethodHandle;", "irConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getEnumEntry", "irEnumClass", "getReflectionMethod", "irFunction", "getStaticGetter", "field", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getStaticMethod", "mustBeHandledWithWrapper", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "getClass", "Lorg/jetbrains/kotlin/ir/types/IrType;", "asObject", "getJvmClassName", "getMethodType", "Ljava/lang/invoke/MethodType;", "getOriginalOverriddenSymbols", "", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "getSignature", "isExtensionReceiverPrimitive", "isReturnTypePrimitiveAsObject", "isValueParameterPrimitiveAsObject", "index", "", "ir.interpreter"})
    public static final class Companion {
        private Companion() {
        }

        public final void associateJavaClassWithIrClass(@NotNull Class<?> javaClass, @NotNull IrClass irClass2) {
            Intrinsics.checkNotNullParameter(javaClass, "javaClass");
            Intrinsics.checkNotNullParameter(irClass2, "irClass");
            Companion companion = this;
            Map map = javaClassToIrClass;
            Pair<Class<?>, IrClass> pair = TuplesKt.to(javaClass, irClass2);
            boolean bl = false;
            map.put(pair.getFirst(), pair.getSecond());
        }

        private final String getSignature(IrDeclarationWithName $this$getSignature) {
            String string2;
            Object object = IrUtilsKt.getFqNameWhenAvailable($this$getSignature);
            String fqName2 = object == null ? null : ((FqName)object).asString();
            object = $this$getSignature;
            if (object instanceof IrFunction) {
                String string3;
                IrValueParameter irValueParameter;
                IrAnnotationContainer irAnnotationContainer = ((IrFunction)$this$getSignature).getDispatchReceiverParameter();
                IrValueParameter irValueParameter2 = irValueParameter = irAnnotationContainer == null ? ((IrFunction)$this$getSignature).getExtensionReceiverParameter() : irAnnotationContainer;
                if (irValueParameter == null) {
                    string3 = "";
                } else {
                    irAnnotationContainer = irValueParameter.getType();
                    if (irAnnotationContainer == null) {
                        string3 = "";
                    } else {
                        String string4 = UtilsKt.getOnlyName((IrType)irAnnotationContainer);
                        if (string4 == null) {
                            string3 = "";
                        } else {
                            String string5 = string4;
                            boolean bl = false;
                            boolean bl2 = false;
                            String it = string5;
                            boolean bl3 = false;
                            String string6 = Intrinsics.stringPlus(it, ".");
                            string3 = string6 == null ? "" : string6;
                        }
                    }
                }
                String receiver = string3;
                string2 = CollectionsKt.joinToString$default(((IrFunction)$this$getSignature).getValueParameters(), null, receiver + fqName2 + '(', ")", 0, null, getSignature.1.INSTANCE, 25, null);
            } else {
                string2 = fqName2;
            }
            return string2;
        }

        private final String getJvmClassName(IrFunction $this$getJvmClassName) {
            Map map = intrinsicFunctionToHandler;
            String string2 = this.getSignature($this$getJvmClassName);
            boolean bl = false;
            return (String)map.get(string2);
        }

        public final boolean mustBeHandledWithWrapper(@NotNull IrDeclarationWithName declaration2) {
            boolean bl;
            Intrinsics.checkNotNullParameter(declaration2, "declaration");
            Object object = IrUtilsKt.getFqNameWhenAvailable(declaration2);
            String fqName2 = object == null ? null : ((FqName)object).asString();
            object = declaration2;
            if (object instanceof IrFunction) {
                Map map = intrinsicFunctionToHandler;
                String string2 = this.getSignature(declaration2);
                boolean bl2 = false;
                Map map2 = map;
                boolean bl3 = false;
                bl = map2.containsKey(string2);
            } else {
                String string3;
                bl = CollectionsKt.contains(intrinsicClasses, fqName2) || ((string3 = fqName2) == null ? false : StringsKt.startsWith$default(string3, "java", false, 2, null));
            }
            return bl;
        }

        @NotNull
        public final MethodHandle getReflectionMethod(@NotNull IrFunction irFunction2) {
            Object object;
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            IrValueParameter irValueParameter = irFunction2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            Class<? extends Object> receiverClass = this.getClass(irValueParameter.getType(), true);
            MethodType methodType = this.getMethodType(irFunction2);
            Object object2 = irFunction2;
            if (object2 instanceof IrSimpleFunction) {
                Object object3 = ((IrSimpleFunction)irFunction2).getCorrespondingPropertySymbol();
                IrProperty property2 = object3 == null ? null : (IrProperty)object3.getOwner();
                object3 = property2;
                if (Intrinsics.areEqual(object3 == null ? null : ((IrProperty)object3).getGetter(), irFunction2)) {
                    object3 = property2.getName().asString();
                    Intrinsics.checkNotNullExpressionValue(object3, "property.name.asString()");
                    object = Intrinsics.stringPlus("get", CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)object3));
                } else {
                    object3 = property2;
                    if (Intrinsics.areEqual(object3 == null ? null : ((IrProperty)object3).getSetter(), irFunction2)) {
                        object3 = property2.getName().asString();
                        Intrinsics.checkNotNullExpressionValue(object3, "property.name.asString()");
                        object = Intrinsics.stringPlus("set", CapitalizeDecapitalizeKt.capitalizeAsciiOnly((String)object3));
                    } else {
                        object3 = irFunction2.getName().asString();
                        Intrinsics.checkNotNullExpressionValue(object3, "irFunction.name.asString()");
                        object = object3;
                    }
                }
            } else {
                String string2 = irFunction2.getName().asString();
                Intrinsics.checkNotNullExpressionValue(string2, "irFunction.name.asString()");
                object = string2;
            }
            String methodName = object;
            object2 = MethodHandles.lookup().findVirtual(receiverClass, methodName, methodType);
            Intrinsics.checkNotNullExpressionValue(object2, "lookup().findVirtual(rec\u2026, methodName, methodType)");
            return object2;
        }

        @NotNull
        public final Wrapper getCompanionObject(@NotNull IrClass irClass2) {
            Intrinsics.checkNotNullParameter(irClass2, "irClass");
            String objectName = UtilsKt.internalName(irClass2);
            Object v = companionObjectValue.get(objectName);
            if (v == null) {
                throw new InternalError("Companion object " + objectName + " cannot be interpreted");
            }
            Object objectValue = v;
            return new Wrapper(objectValue, irClass2);
        }

        @Nullable
        public final MethodHandle getConstructorMethod(@NotNull IrFunction irConstructor2) {
            Intrinsics.checkNotNullParameter(irConstructor2, "irConstructor");
            String intrinsicValue = UtilsKt.internalName(IrUtilsKt.getParentAsClass(irConstructor2));
            if (Intrinsics.areEqual(intrinsicValue, "kotlin.Char") || Intrinsics.areEqual(intrinsicValue, "kotlin.Long")) {
                return null;
            }
            MethodType methodType = this.getMethodType(irConstructor2);
            return MethodHandles.lookup().findConstructor(this.getClass(irConstructor2.getReturnType(), true), methodType);
        }

        @Nullable
        public final MethodHandle getStaticMethod(@NotNull IrFunction irFunction2) {
            boolean bl;
            String intrinsicName;
            Intrinsics.checkNotNullParameter(irFunction2, "irFunction");
            String string2 = intrinsicName = this.getJvmClassName(irFunction2);
            if (string2 == null) {
                bl = false;
            } else {
                CharSequence charSequence = string2;
                boolean bl2 = false;
                bl = !(charSequence.length() == 0);
            }
            if (!bl) {
                return null;
            }
            Class<?> jvmClass = Class.forName(intrinsicName);
            MethodType methodType = this.getMethodType(irFunction2);
            return MethodHandles.lookup().findStatic(jvmClass, irFunction2.getName().asString(), methodType);
        }

        @NotNull
        public final MethodHandle getStaticGetter(@NotNull IrField field2) {
            Intrinsics.checkNotNullParameter(field2, "field");
            Class<? extends Object> jvmClass = this.getClass(IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(field2)), true);
            Object object = field2.getType();
            boolean bl = false;
            boolean bl2 = false;
            IrType it = object;
            boolean bl3 = false;
            Class<? extends Object> returnType2 = Companion.getClass(it, ((IrSimpleType)it).getHasQuestionMark());
            object = MethodHandles.lookup().findStaticGetter(jvmClass, field2.getName().asString(), returnType2);
            Intrinsics.checkNotNullExpressionValue(object, "lookup().findStaticGette\u2026e.asString(), returnType)");
            return object;
        }

        @NotNull
        public final MethodHandle getEnumEntry(@NotNull IrClass irEnumClass) {
            Intrinsics.checkNotNullParameter(irEnumClass, "irEnumClass");
            String intrinsicName = UtilsKt.internalName(irEnumClass);
            Class<?> jvmEnumClass = Class.forName(intrinsicName);
            MethodType methodType = MethodType.methodType(jvmEnumClass, String.class);
            MethodHandle methodHandle = MethodHandles.lookup().findStatic(jvmEnumClass, "valueOf", methodType);
            Intrinsics.checkNotNullExpressionValue(methodHandle, "lookup().findStatic(jvmE\u2026s, \"valueOf\", methodType)");
            return methodHandle;
        }

        /*
         * WARNING - void declaration
         */
        private final MethodType getMethodType(IrFunction $this$getMethodType) {
            MethodType methodType;
            MethodType methodType2;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$getMethodType.getValueParameters();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Class<? extends Object> clazz = Companion.getClass(it.getType(), Companion.isValueParameterPrimitiveAsObject($this$getMethodType, it.getIndex()));
                collection.add(clazz);
            }
            List argsClasses = (List)destination$iv$iv;
            if ($this$getMethodType instanceof IrSimpleFunction) {
                IrType irType;
                Class<? extends Object> returnClass = this.getClass($this$getMethodType.getReturnType(), this.isReturnTypePrimitiveAsObject($this$getMethodType));
                IrValueParameter irValueParameter = $this$getMethodType.getExtensionReceiverParameter();
                Class<? extends Object> extensionClass = irValueParameter == null ? null : ((irType = irValueParameter.getType()) == null ? null : this.getClass(irType, this.isExtensionReceiverPrimitive($this$getMethodType)));
                methodType2 = MethodType.methodType(returnClass, CollectionsKt.plus((Collection)CollectionsKt.listOfNotNull(extensionClass), (Iterable)argsClasses));
                Intrinsics.checkNotNullExpressionValue(methodType2, "{\n                // for\u2026rgsClasses)\n            }");
                methodType = methodType2;
            } else {
                methodType2 = MethodType.methodType(Void.TYPE, argsClasses);
                Intrinsics.checkNotNullExpressionValue(methodType2, "{\n                // for\u2026rgsClasses)\n            }");
                methodType = methodType2;
            }
            return methodType;
        }

        private final Class<? extends Object> getClass(IrType $this$getClass, boolean asObject) {
            Class clazz;
            Class<?> clazz2;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull($this$getClass);
            IrClass owner = irClassSymbol == null ? null : (IrClass)irClassSymbol.getOwner();
            IrClass irClass2 = owner;
            String fqName2 = irClass2 == null ? null : ((clazz2 = IrUtilsKt.getFqNameWhenAvailable(irClass2)) == null ? null : ((FqName)((Object)clazz2)).asString());
            IrType notNullType = IrTypesKt.makeNotNull($this$getClass);
            if (IrTypePredicatesKt.isPrimitiveType$default(notNullType, false, 1, null) || IrTypePredicatesKt.isString(notNullType)) {
                Class<?> clazz3 = UtilsKt.getPrimitiveClass(notNullType, asObject);
                clazz = clazz3;
                Intrinsics.checkNotNull(clazz3);
            } else if (IrTypePredicatesKt.isArray(notNullType)) {
                Class clazz4;
                IrClass irClass3;
                IrClassSymbol irClassSymbol2;
                Object object = IrTypesKt.getTypeOrNull(CollectionsKt.single(((IrSimpleType)$this$getClass).getArguments()));
                FqName argumentFqName = object == null ? null : ((irClassSymbol2 = IrTypesKt.getClassOrNull((IrType)object)) == null ? null : ((irClass3 = (IrClass)irClassSymbol2.getOwner()) == null ? null : IrUtilsKt.getFqNameWhenAvailable(irClass3)));
                if (argumentFqName != null && !Intrinsics.areEqual(argumentFqName.asString(), "kotlin.Any")) {
                    object = argumentFqName;
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = object;
                    boolean bl3 = false;
                    clazz4 = Class.forName("[L" + it + ';');
                } else {
                    clazz4 = Object[].class;
                }
                clazz2 = clazz4;
                Intrinsics.checkNotNullExpressionValue(clazz2, "{\n                    va\u2026      }\n                }");
                clazz = clazz2;
            } else if (IrTypePredicatesKt.isNothing(notNullType)) {
                clazz = Void.class;
            } else if (IrTypePredicatesKt.isAny(notNullType)) {
                clazz = Object.class;
            } else if (IrTypePredicatesKt.isUnit(notNullType)) {
                if (asObject) {
                    clazz = Void.class;
                } else {
                    Class<Void> clazz5 = Void.TYPE;
                    clazz = clazz5;
                    Intrinsics.checkNotNull(clazz5);
                }
            } else if (IrTypePredicatesKt.isNumber(notNullType)) {
                clazz = Number.class;
            } else if (IrTypePredicatesKt.isCharSequence(notNullType)) {
                clazz = CharSequence.class;
            } else if (IrTypePredicatesKt.isComparable(notNullType)) {
                clazz = Comparable.class;
            } else if (UtilsKt.isThrowable(notNullType)) {
                clazz = Throwable.class;
            } else if (IrTypePredicatesKt.isIterable(notNullType)) {
                clazz = Iterable.class;
            } else if (UtilsKt.isKFunction(notNullType)) {
                clazz2 = Class.forName("kotlin.reflect.KFunction");
                Intrinsics.checkNotNullExpressionValue(clazz2, "forName(\"kotlin.reflect.KFunction\")");
                clazz = clazz2;
            } else {
                if (UtilsKt.isFunction(notNullType)) {
                    Class<?> clazz6;
                    String string2;
                    Object object = fqName2;
                    Integer arity = object == null ? null : ((string2 = StringsKt.removePrefix((String)object, (CharSequence)"kotlin.Function")) == null ? null : StringsKt.toIntOrNull(string2));
                    if (arity == null || arity >= 23) {
                        object = Class.forName("kotlin.jvm.functions.FunctionN");
                        Intrinsics.checkNotNullExpressionValue(object, "forName(\"kotlin.jvm.functions.FunctionN\")");
                        clazz6 = object;
                    } else {
                        object = Class.forName(Intrinsics.stringPlus("kotlin.jvm.functions.", StringsKt.removePrefix(fqName2, (CharSequence)"kotlin.")));
                        Intrinsics.checkNotNullExpressionValue(object, "forName(\"kotlin.jvm.func\u2026emovePrefix(\"kotlin.\")}\")");
                        clazz6 = object;
                    }
                    return clazz6;
                }
                if (Intrinsics.areEqual(fqName2, "kotlin.Enum")) {
                    clazz = Enum.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Collection") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableCollection")) {
                    clazz = Collection.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.List") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableList")) {
                    clazz = List.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Set") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableSet")) {
                    clazz = Set.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Map") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableMap")) {
                    clazz = Map.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.ListIterator") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableListIterator")) {
                    clazz = ListIterator.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Iterator") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableIterator")) {
                    clazz = Iterator.class;
                } else if (Intrinsics.areEqual(fqName2, "kotlin.collections.Map.Entry") || Intrinsics.areEqual(fqName2, "kotlin.collections.MutableMap.MutableEntry")) {
                    clazz = Map.Entry.class;
                } else if (fqName2 == null) {
                    clazz = Object.class;
                } else {
                    clazz2 = Class.forName(UtilsKt.internalName(owner));
                    Intrinsics.checkNotNullExpressionValue(clazz2, "forName(owner.internalName())");
                    clazz = clazz2;
                }
            }
            return clazz;
        }

        private final List<IrFunctionSymbol> getOriginalOverriddenSymbols(IrFunction $this$getOriginalOverriddenSymbols) {
            boolean bl = false;
            List overriddenSymbols2 = new ArrayList();
            if ($this$getOriginalOverriddenSymbols instanceof IrSimpleFunction) {
                List pool = CollectionsKt.toMutableList(((IrSimpleFunction)$this$getOriginalOverriddenSymbols).getOverriddenSymbols());
                ListIterator iterator2 = pool.listIterator();
                Iterator iterator3 = iterator2;
                boolean bl2 = false;
                Iterator iterator4 = iterator3;
                while (iterator4.hasNext()) {
                    IrSimpleFunctionSymbol symbol2 = (IrSimpleFunctionSymbol)iterator4.next();
                    if (((IrSimpleFunction)symbol2.getOwner()).getOverriddenSymbols().isEmpty()) {
                        Collection collection = overriddenSymbols2;
                        boolean bl3 = false;
                        collection.add(symbol2);
                        iterator2.remove();
                        continue;
                    }
                    Iterable $this$forEach$iv = ((IrSimpleFunction)symbol2.getOwner()).getOverriddenSymbols();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrSimpleFunctionSymbol it = (IrSimpleFunctionSymbol)element$iv;
                        boolean bl4 = false;
                        iterator2.add(it);
                    }
                }
            }
            if (overriddenSymbols2.isEmpty()) {
                overriddenSymbols2.add($this$getOriginalOverriddenSymbols.getSymbol());
            }
            return overriddenSymbols2;
        }

        private final boolean isExtensionReceiverPrimitive(IrFunction $this$isExtensionReceiverPrimitive) {
            IrType irType;
            IrValueParameter irValueParameter = $this$isExtensionReceiverPrimitive.getExtensionReceiverParameter();
            return irValueParameter == null ? false : ((irType = irValueParameter.getType()) == null ? false : !IrTypePredicatesKt.isPrimitiveType$default(irType, false, 1, null));
        }

        private final boolean isReturnTypePrimitiveAsObject(IrFunction $this$isReturnTypePrimitiveAsObject) {
            for (IrFunctionSymbol symbol2 : this.getOriginalOverriddenSymbols($this$isReturnTypePrimitiveAsObject)) {
                if (UtilsKt.isTypeParameter(symbol2.getOwner().getReturnType()) || IrTypeUtilsKt.isNullable(symbol2.getOwner().getReturnType())) continue;
                return false;
            }
            return true;
        }

        private final boolean isValueParameterPrimitiveAsObject(IrFunction $this$isValueParameterPrimitiveAsObject, int index2) {
            for (IrFunctionSymbol symbol2 : this.getOriginalOverriddenSymbols($this$isValueParameterPrimitiveAsObject)) {
                if (UtilsKt.isTypeParameter(symbol2.getOwner().getValueParameters().get(index2).getType()) || IrTypeUtilsKt.isNullable(symbol2.getOwner().getValueParameters().get(index2).getType())) continue;
                return false;
            }
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

