#
# Copyright 2017 Ettus Research, a National Instruments Company
#
# SPDX-License-Identifier: GPL-3.0-or-later
#
"""
MPM Module
"""

__simulated__ = ("sim" == "sim")

from .discovery import spawn_discovery_process
from .rpc_server import spawn_rpc_process
from . import mpmtypes
from . import gpsd_iface
from .mpmlog import get_main_logger

if not __simulated__:
    from . import libpyusrp_periphs as lib
    from . import periph_manager
    from . import dboard_manager
    from . import xports
    from . import cores
    from . import chips
else:
    from . import periph_manager

__version__ = periph_manager.__version__
__githash__ = periph_manager.__githash__
__mpm_device__ = periph_manager.__mpm_device__
