# Contributing
## Pull requests
Changes to this project should be proposed as pull requests on Github
at: <https://github.com/lxc/lxd>

Proposed changes will then go through code review there and once acked,
be merged in the main branch.

## Commit structure
Separate commits should be used for:

 - API extension (`api: Add XYZ extension`, contains `doc/api-extensions.md` and `shared/version.api.go`)
 - Documentation (`doc: Update XYZ` for files in `doc/`)
 - API structure (`shared/api: Add XYZ` for changes to `shared/api/`)
 - Go client package (`client: Add XYZ` for changes to `client/`)
 - CLI (`lxc/<command>: Change XYZ` for changes to `lxc/`)
 - Scripts (`scripts: Update bash completion for XYZ` for changes to `scripts/`)
 - LXD daemon (`lxd/<package>: Add support for XYZ` for changes to `lxd/`)
 - Tests (`tests: Add test for XYZ` for changes to `tests/`)

The same kind of pattern extends to the other tools in the LXD code tree
and depending on complexity, things may be split into even smaller chunks.

When updating strings in the CLI tool (`lxc/`), you may need a commit to update the templates:

 - make i18n
 - git commit -a -s -m "i18n: Update translation templates" po/

This structure makes it easier for contributions to be reviewed and also
greatly simplifies the process of backporting fixes to stable branches.

## License and copyright
By default, any contribution to this project is made under the Apache
2.0 license.

The author of a change remains the copyright holder of their code
(no copyright assignment).


## Developer Certificate of Origin
To improve tracking of contributions to this project we use the DCO 1.1
and use a "sign-off" procedure for all changes going into the branch.

The sign-off is a simple line at the end of the explanation for the
commit which certifies that you wrote it or otherwise have the right
to pass it on as an open-source contribution.

> Developer Certificate of Origin
> Version 1.1
>
> Copyright (C) 2004, 2006 The Linux Foundation and its contributors.
> 660 York Street, Suite 102,
> San Francisco, CA 94110 USA
>
> Everyone is permitted to copy and distribute verbatim copies of this
> license document, but changing it is not allowed.
>
> Developer's Certificate of Origin 1.1
>
> By making a contribution to this project, I certify that:
>
> (a) The contribution was created in whole or in part by me and I
>     have the right to submit it under the open source license
>     indicated in the file; or
>
> (b) The contribution is based upon previous work that, to the best
>     of my knowledge, is covered under an appropriate open source
>     license and I have the right under that license to submit that
>     work with modifications, whether created in whole or in part
>     by me, under the same open source license (unless I am
>     permitted to submit under a different license), as indicated
>     in the file; or
>
> (c) The contribution was provided directly to me by some other
>     person who certified (a), (b) or (c) and I have not modified
>     it.
>
> (d) I understand and agree that this project and the contribution
>     are public and that a record of the contribution (including all
>     personal information I submit with it, including my sign-off) is
>     maintained indefinitely and may be redistributed consistent with
>     this project or the open source license(s) involved.

An example of a valid sign-off line is:

```
Signed-off-by: Random J Developer <random@developer.org>
```

Use your real name and a valid e-mail address.
Sorry, no pseudonyms or anonymous contributions are allowed.

We also require each commit be individually signed-off by their author,
even when part of a larger set. You may find `git commit -s` useful.

## Getting Started Developing

Follow the steps below to set up your development environment to get started working on new features for LXD.

### Building Dependencies

To build dependencies, you can follow the instructions in [the README.md](index.md) under the "Installing LXD from Source" section.

### Adding Your Fork Remote

After building your dependencies, you can now add your GitHub fork as a remote and switch to it:
```bash
git remote add myfork git@github.com:<your_username>/lxd.git
git remote update
git checkout myfork/master
```

### Building LXD

Finally, you should be able to `make` inside the repository and build your fork of the project.

At this point, you would most likely want to create a new branch for your changes on your fork:

```bash
git checkout -b [name_of_your_new_branch]
git push myfork [name_of_your_new_branch]
```

### Important Notes for New LXD Contributors

- Persistent data is stored in the `LXD_DIR` directory which is generated by `lxd init`. The `LXD_DIR` defaults to `/var/lib/lxd` or `/var/snap/lxd/common/lxd` for snap users.
- As you develop, you may want to change the `LXD_DIR` for your fork of LXD so as to avoid version conflicts.
- Binaries compiled from your source will be generated in the `$(go env GOPATH)/bin` directory by default.
    - You will need to explicitly invoke these binaries (not the global `lxd` you may have installed) when testing your changes.
    - You may choose to create an alias in your `~/.bashrc` to call these binaries with the appropriate flags more conveniently.
- If you have a systemd service configured to run the LXD daemon from a previous installation of LXD, you may want to disable it to avoid version conflicts.

