/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java.com.lowagie.text.pdf;

import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfArray;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfDictionary;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfName;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfObject;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfReader;
import com.gitlab.pdftk_java.com.lowagie.text.pdf.PdfString;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class FdfReader
extends PdfReader {
    HashMap fields;
    String fileSpec;
    PdfName encoding;

    public FdfReader(String filename) throws IOException {
        super(filename);
    }

    public FdfReader(byte[] pdfIn) throws IOException {
        super(pdfIn);
    }

    public FdfReader(URL url) throws IOException {
        super(url);
    }

    public FdfReader(InputStream is) throws IOException {
        super(is);
    }

    @Override
    protected void readPdf() throws IOException {
        this.fields = new HashMap();
        try {
            this.tokens.checkFdfHeader();
            this.rebuildXref();
            this.readDocObj();
        }
        finally {
            try {
                this.tokens.close();
            }
            catch (Exception exception) {}
        }
        this.readFields();
    }

    protected void kidNode(PdfDictionary merged, String name) {
        PdfArray kids = merged.getAsArray(PdfName.KIDS);
        if (kids == null || kids.isEmpty()) {
            if (name.length() > 0) {
                name = name.substring(1);
            }
            this.fields.put(name, merged);
        } else {
            merged.remove(PdfName.KIDS);
            for (int k = 0; k < kids.size(); ++k) {
                PdfDictionary dic = new PdfDictionary();
                dic.merge(merged);
                PdfDictionary newDic = kids.getAsDict(k);
                PdfString t = newDic.getAsString(PdfName.T);
                String newName = name;
                if (t != null) {
                    newName = newName + "." + t.toUnicodeString();
                }
                dic.merge(newDic);
                dic.remove(PdfName.T);
                this.kidNode(dic, newName);
            }
        }
    }

    protected void readFileSpecification(PdfDictionary fdf) {
        PdfObject fs = FdfReader.getPdfObject(fdf.get(PdfName.F));
        if (fs != null) {
            if (fs.isString()) {
                this.fileSpec = ((PdfString)fs).toUnicodeString();
            } else if (fs.isDictionary()) {
                PdfObject uf = FdfReader.getPdfObject(((PdfDictionary)fs).get(PdfName.UF));
                if (uf != null && uf.isString()) {
                    this.fileSpec = ((PdfString)uf).toUnicodeString();
                } else {
                    PdfObject f = FdfReader.getPdfObject(((PdfDictionary)fs).get(PdfName.F));
                    if (f != null && f.isString()) {
                        this.fileSpec = ((PdfString)f).toUnicodeString();
                    }
                }
            }
        }
    }

    protected void readFields() {
        this.catalog = this.trailer.getAsDict(PdfName.ROOT);
        PdfDictionary fdf = this.catalog.getAsDict(PdfName.FDF);
        if (fdf == null) {
            return;
        }
        this.readFileSpecification(fdf);
        PdfArray fld = fdf.getAsArray(PdfName.FIELDS);
        if (fld == null) {
            return;
        }
        this.encoding = fdf.getAsName(PdfName.ENCODING);
        PdfDictionary merged = new PdfDictionary();
        merged.put(PdfName.KIDS, fld);
        this.kidNode(merged, "");
    }

    public HashMap getFields() {
        return this.fields;
    }

    public PdfDictionary getField(String name) {
        return (PdfDictionary)this.fields.get(name);
    }

    private String decodeString(PdfString vs) {
        if (this.encoding == null || vs.getEncoding() != null) {
            return vs.toUnicodeString();
        }
        byte[] b = vs.getBytes();
        if (b.length >= 2 && b[0] == -2 && b[1] == -1) {
            return vs.toUnicodeString();
        }
        try {
            if (this.encoding.equals(PdfName.SHIFT_JIS)) {
                return new String(b, "SJIS");
            }
            if (this.encoding.equals(PdfName.UHC)) {
                return new String(b, "MS949");
            }
            if (this.encoding.equals(PdfName.GBK)) {
                return new String(b, "GBK");
            }
            if (this.encoding.equals(PdfName.BIGFIVE)) {
                return new String(b, "Big5");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return vs.toUnicodeString();
    }

    public String getFieldValue(String name) {
        PdfDictionary field = (PdfDictionary)this.fields.get(name);
        if (field == null) {
            return null;
        }
        PdfObject v = FdfReader.getPdfObject(field.get(PdfName.V));
        if (v == null) {
            return null;
        }
        if (v.isName()) {
            return PdfName.decodeName(((PdfName)v).toString());
        }
        if (v.isString()) {
            return this.decodeString((PdfString)v);
        }
        return null;
    }

    public String getFieldRichValue(String name) {
        PdfDictionary field = (PdfDictionary)this.fields.get(name);
        if (field == null) {
            return null;
        }
        PdfObject rv = FdfReader.getPdfObject(field.get(PdfName.RV));
        if (rv == null) {
            return null;
        }
        if (rv.isName()) {
            return PdfName.decodeName(((PdfName)rv).toString());
        }
        if (rv.isString()) {
            return ((PdfString)rv).toUnicodeString();
        }
        return null;
    }

    public String[] getFieldMultiValue(String name) {
        PdfDictionary field = (PdfDictionary)this.fields.get(name);
        if (field == null) {
            return null;
        }
        PdfArray v = field.getAsArray(PdfName.V);
        if (v == null) {
            String singlevalue = this.getFieldValue(name);
            if (singlevalue != null) {
                return new String[]{singlevalue};
            }
        } else {
            ArrayList<String> values = new ArrayList<String>();
            ArrayList vv = v.getArrayList();
            for (PdfObject vi : vv) {
                if (!vi.isString()) continue;
                values.add(this.decodeString((PdfString)vi));
            }
            String[] ret = new String[values.size()];
            ret = values.toArray(ret);
            return ret;
        }
        return null;
    }

    public String getFileSpec() {
        return this.fileSpec;
    }
}

