# This file has been autogenerated by the pywayland scanner

# Copyright © 2008-2013 Kristian Høgsberg
# Copyright © 2013      Rafael Antognolli
# Copyright © 2013      Jasper St. Pierre
# Copyright © 2010-2013 Intel Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

import enum

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from ..wayland import WlSurface
from .zxdg_positioner_v6 import ZxdgPositionerV6
from .zxdg_surface_v6 import ZxdgSurfaceV6


class ZxdgShellV6(Interface):
    """Create desktop-style surfaces

    :class:`~pywayland.protocol.xdg_shell_unstable_v5.XdgShell` allows clients
    to turn a :class:`~pywayland.protocol.wayland.WlSurface` into a "real
    window" which can be dragged, resized, stacked, and moved around by the
    user. Everything about this interface is suited towards traditional desktop
    environments.
    """

    name = "zxdg_shell_v6"
    version = 1

    class error(enum.IntEnum):
        role = 0
        defunct_surfaces = 1
        not_the_topmost_popup = 2
        invalid_popup_parent = 3
        invalid_surface_state = 4
        invalid_positioner = 5


class ZxdgShellV6Proxy(Proxy):
    interface = ZxdgShellV6

    @ZxdgShellV6.request()
    def destroy(self):
        """Destroy :class:`~pywayland.protocol.xdg_shell_unstable_v5.XdgShell`

        Destroy this
        :class:`~pywayland.protocol.xdg_shell_unstable_v5.XdgShell` object.

        Destroying a bound
        :class:`~pywayland.protocol.xdg_shell_unstable_v5.XdgShell` object
        while there are surfaces still alive created by this
        :class:`~pywayland.protocol.xdg_shell_unstable_v5.XdgShell` object
        instance is illegal and will result in a protocol error.
        """
        self._marshal(0)
        self._destroy()

    @ZxdgShellV6.request(
        Argument(ArgumentType.NewId, interface=ZxdgPositionerV6),
    )
    def create_positioner(self):
        """Create a positioner object

        Create a positioner object. A positioner object is used to position
        surfaces relative to some parent surface. See the interface description
        and :func:`XdgSurface.get_popup()
        <pywayland.protocol.xdg_shell.XdgSurface.get_popup>` for details.

        :returns:
            :class:`~pywayland.protocol.xdg_shell_unstable_v6.ZxdgPositionerV6`
        """
        id = self._marshal_constructor(1, ZxdgPositionerV6)
        return id

    @ZxdgShellV6.request(
        Argument(ArgumentType.NewId, interface=ZxdgSurfaceV6),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def get_xdg_surface(self, surface):
        """Create a shell surface from a surface

        This creates an :class:`~pywayland.protocol.xdg_shell.XdgSurface` for
        the given surface. While
        :class:`~pywayland.protocol.xdg_shell.XdgSurface` itself is not a role,
        the corresponding surface may only be assigned a role extending
        :class:`~pywayland.protocol.xdg_shell.XdgSurface`, such as
        :class:`~pywayland.protocol.xdg_shell.XdgToplevel` or
        :class:`~pywayland.protocol.xdg_shell.XdgPopup`.

        This creates an :class:`~pywayland.protocol.xdg_shell.XdgSurface` for
        the given surface. An :class:`~pywayland.protocol.xdg_shell.XdgSurface`
        is used as basis to define a role to a given surface, such as
        :class:`~pywayland.protocol.xdg_shell.XdgToplevel` or
        :class:`~pywayland.protocol.xdg_shell.XdgPopup`. It also manages
        functionality shared between
        :class:`~pywayland.protocol.xdg_shell.XdgSurface` based surface roles.

        See the documentation of
        :class:`~pywayland.protocol.xdg_shell.XdgSurface` for more details
        about what an :class:`~pywayland.protocol.xdg_shell.XdgSurface` is and
        how it is used.

        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :returns:
            :class:`~pywayland.protocol.xdg_shell_unstable_v6.ZxdgSurfaceV6`
        """
        id = self._marshal_constructor(2, ZxdgSurfaceV6, surface)
        return id

    @ZxdgShellV6.request(
        Argument(ArgumentType.Uint),
    )
    def pong(self, serial):
        """Respond to a ping event

        A client must respond to a ping event with a pong request or the client
        may be deemed unresponsive. See :func:`XdgShell.ping()
        <pywayland.protocol.xdg_shell_unstable_v5.XdgShell.ping>`.

        :param serial:
            serial of the ping event
        :type serial:
            `ArgumentType.Uint`
        """
        self._marshal(3, serial)


class ZxdgShellV6Resource(Resource):
    interface = ZxdgShellV6

    @ZxdgShellV6.event(
        Argument(ArgumentType.Uint),
    )
    def ping(self, serial):
        """Check if the client is alive

        The ping event asks the client if it's still alive. Pass the serial
        specified in the event back to the compositor by sending a "pong"
        request back with the specified serial. See :func:`XdgShell.ping()
        <pywayland.protocol.xdg_shell_unstable_v5.XdgShell.ping>`.

        Compositors can use this to determine if the client is still alive.
        It's unspecified what will happen if the client doesn't respond to the
        ping request, or in what timeframe. Clients should try to respond in a
        reasonable amount of time.

        A compositor is free to ping in any way it wants, but a client must
        always respond to any
        :class:`~pywayland.protocol.xdg_shell_unstable_v5.XdgShell` object it
        created.

        :param serial:
            pass this to the pong request
        :type serial:
            `ArgumentType.Uint`
        """
        self._post_event(0, serial)


class ZxdgShellV6Global(Global):
    interface = ZxdgShellV6


ZxdgShellV6._gen_c()
ZxdgShellV6.proxy_class = ZxdgShellV6Proxy
ZxdgShellV6.resource_class = ZxdgShellV6Resource
ZxdgShellV6.global_class = ZxdgShellV6Global
