/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.model;

import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomeObject;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Transformation;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class HomeFurnitureGroup
extends HomePieceOfFurniture {
    private static final long serialVersionUID = 1L;
    private List<HomePieceOfFurniture> furniture;
    private boolean resizable;
    private boolean deformable;
    private boolean texturable;
    private boolean doorOrWindow;
    private float fixedWidth;
    private float fixedDepth;
    private float fixedHeight;
    private float dropOnTopElevation;
    private String currency;
    private transient PropertyChangeListener furnitureListener;

    public HomeFurnitureGroup(List<HomePieceOfFurniture> list, String string) {
        this(list, list.get(0), string);
    }

    public HomeFurnitureGroup(List<HomePieceOfFurniture> list, HomePieceOfFurniture homePieceOfFurniture, String string) {
        this(list, homePieceOfFurniture.getAngle(), false, string);
    }

    public HomeFurnitureGroup(List<HomePieceOfFurniture> list, float f, boolean bl, String string) {
        this(HomeFurnitureGroup.createId("furnitureGroup"), list, f, bl, string);
    }

    public HomeFurnitureGroup(String string, List<HomePieceOfFurniture> list, float f, boolean bl, String string2) {
        super(string, list.get(0));
        this.furniture = Collections.unmodifiableList(list);
        this.resizable = true;
        this.deformable = true;
        this.texturable = true;
        boolean bl2 = true;
        boolean bl3 = false;
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            bl2 &= homePieceOfFurniture.isMovable();
            bl3 |= homePieceOfFurniture.isVisible();
        }
        this.setName(string2);
        this.setCatalogId(null);
        this.setDescription(null);
        this.setInformation(null);
        this.setCreator(null);
        this.setNameVisible(false);
        this.setNameXOffset(0.0f);
        this.setNameYOffset(0.0f);
        this.setNameAngle(0.0f);
        this.setNameStyle(null);
        super.setMovable(bl2);
        super.setAngle(f);
        super.setModelMirrored(bl);
        this.setVisible(bl3);
        this.updateLocationAndSize(list, f, true);
        this.addFurnitureListener();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.dropOnTopElevation = -1.0f;
        this.deformable = true;
        this.texturable = true;
        objectInputStream.defaultReadObject();
        this.addFurnitureListener();
    }

    /*
     * WARNING - void declaration
     */
    private void updateLocationAndSize(List<HomePieceOfFurniture> list, float f, boolean bl) {
        void var8_27;
        this.resizable = true;
        this.deformable = true;
        this.texturable = true;
        this.doorOrWindow = true;
        this.currency = list.get(0).getCurrency();
        for (HomePieceOfFurniture object2 : list) {
            this.resizable &= object2.isResizable();
            this.deformable &= object2.isDeformable();
            this.texturable &= object2.isTexturable();
            this.doorOrWindow &= object2.isDoorOrWindow();
            if (this.currency == null || object2.getCurrency() != null && object2.getCurrency().equals(this.currency)) continue;
            this.currency = null;
        }
        float f2 = Float.MAX_VALUE;
        if (bl) {
            void var5_8;
            Object f3 = null;
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                Level level = homePieceOfFurniture.getLevel();
                if (level == null || var5_8 != null && !(level.getElevation() < var5_8.getElevation())) continue;
                Level level2 = level;
            }
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                if (homePieceOfFurniture.getLevel() != null) {
                    f2 = Math.min(f2, homePieceOfFurniture.getGroundElevation() - var5_8.getElevation());
                    homePieceOfFurniture.setElevation(homePieceOfFurniture.getGroundElevation() - var5_8.getElevation());
                    homePieceOfFurniture.setLevel(null);
                    continue;
                }
                f2 = Math.min(f2, homePieceOfFurniture.getElevation());
            }
        } else {
            for (HomePieceOfFurniture homePieceOfFurniture : list) {
                f2 = Math.min(f2, homePieceOfFurniture.getElevation());
            }
        }
        float f3 = 0.0f;
        float f4 = -1.0f;
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            f3 = Math.max(f3, homePieceOfFurniture.getElevation() + homePieceOfFurniture.getHeightInPlan());
            if (!(homePieceOfFurniture.getDropOnTopElevation() >= 0.0f)) continue;
            f4 = Math.max(f4, homePieceOfFurniture.getElevation() + homePieceOfFurniture.getHeightInPlan() * homePieceOfFurniture.getDropOnTopElevation());
        }
        f3 -= f2;
        f4 -= f2;
        AffineTransform affineTransform = AffineTransform.getRotateInstance(-f);
        Object var8_26 = null;
        for (HomePieceOfFurniture homePieceOfFurniture : this.getFurnitureWithoutGroups(list)) {
            GeneralPath generalPath = new GeneralPath();
            float[][] fArray = homePieceOfFurniture.getPoints();
            generalPath.moveTo(fArray[0][0], fArray[0][1]);
            for (int i = 1; i < fArray.length; ++i) {
                generalPath.lineTo(fArray[i][0], fArray[i][1]);
            }
            generalPath.closePath();
            if (var8_27 == null) {
                Rectangle2D rectangle2D = generalPath.createTransformedShape(affineTransform).getBounds2D();
                continue;
            }
            var8_27.add(generalPath.createTransformedShape(affineTransform).getBounds2D());
        }
        Point2D.Float float_ = new Point2D.Float((float)var8_27.getCenterX(), (float)var8_27.getCenterY());
        affineTransform.setToRotation(f);
        affineTransform.transform(float_, float_);
        if (this.resizable) {
            float f5 = (float)var8_27.getWidth();
            super.setWidth(f5);
            super.setWidthInPlan(f5);
            float f6 = (float)var8_27.getHeight();
            super.setDepth(f6);
            super.setDepthInPlan(f6);
            super.setHeight(f3);
            super.setHeightInPlan(f3);
        } else {
            this.fixedWidth = (float)var8_27.getWidth();
            this.fixedDepth = (float)var8_27.getHeight();
            this.fixedHeight = f3;
        }
        this.dropOnTopElevation = f4 / f3;
        super.setX((float)((Point2D)float_).getX());
        super.setY((float)((Point2D)float_).getY());
        super.setElevation(f2);
    }

    private void addFurnitureListener() {
        this.furnitureListener = new LocationAndSizeChangeListener(this);
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            homePieceOfFurniture.addPropertyChangeListener(this.furnitureListener);
        }
    }

    private List<HomePieceOfFurniture> getFurnitureWithoutGroups(List<HomePieceOfFurniture> list) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                arrayList.addAll(this.getFurnitureWithoutGroups(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()));
                continue;
            }
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    public List<HomePieceOfFurniture> getAllFurniture() {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(this.furniture);
        for (HomePieceOfFurniture homePieceOfFurniture : this.getFurniture()) {
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
            arrayList.addAll(((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture());
        }
        return arrayList;
    }

    public List<HomePieceOfFurniture> getFurniture() {
        return Collections.unmodifiableList(this.furniture);
    }

    void addPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture, int n) {
        this.furniture = new ArrayList<HomePieceOfFurniture>(this.furniture);
        homePieceOfFurniture.setLevel(this.getLevel());
        this.furniture.add(n, homePieceOfFurniture);
        homePieceOfFurniture.addPropertyChangeListener(this.furnitureListener);
        this.updateLocationAndSize(this.furniture, this.getAngle(), false);
    }

    void deletePieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
        int n = this.furniture.indexOf(homePieceOfFurniture);
        if (n != -1) {
            if (this.furniture.size() > 1) {
                homePieceOfFurniture.setLevel(null);
                homePieceOfFurniture.removePropertyChangeListener(this.furnitureListener);
                this.furniture = new ArrayList<HomePieceOfFurniture>(this.furniture);
                this.furniture.remove(n);
                this.updateLocationAndSize(this.furniture, this.getAngle(), false);
            } else {
                throw new IllegalStateException("Group can't be empty");
            }
        }
    }

    @Override
    public String getCatalogId() {
        return super.getCatalogId();
    }

    @Override
    public String getInformation() {
        return super.getInformation();
    }

    @Override
    public boolean isMovable() {
        return super.isMovable();
    }

    @Override
    public void setMovable(boolean bl) {
        super.setMovable(bl);
    }

    @Override
    public boolean isDoorOrWindow() {
        return this.doorOrWindow;
    }

    @Override
    public boolean isResizable() {
        return this.resizable;
    }

    @Override
    public boolean isDeformable() {
        return this.deformable;
    }

    @Override
    public boolean isTexturable() {
        return this.texturable;
    }

    @Override
    public boolean isHorizontallyRotatable() {
        return false;
    }

    @Override
    public float getWidth() {
        if (!this.resizable) {
            return this.fixedWidth;
        }
        return super.getWidth();
    }

    @Override
    public float getWidthInPlan() {
        return this.getWidth();
    }

    @Override
    public float getDepth() {
        if (!this.resizable) {
            return this.fixedDepth;
        }
        return super.getDepth();
    }

    @Override
    public float getDepthInPlan() {
        return this.getDepth();
    }

    @Override
    public float getHeight() {
        if (!this.resizable) {
            return this.fixedHeight;
        }
        return super.getHeight();
    }

    @Override
    public float getHeightInPlan() {
        return this.getHeight();
    }

    @Override
    public boolean isHorizontallyRotated() {
        if (super.isHorizontallyRotated()) {
            return true;
        }
        for (HomePieceOfFurniture homePieceOfFurniture : this.getFurniture()) {
            if (!homePieceOfFurniture.isHorizontallyRotated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public float getDropOnTopElevation() {
        return this.dropOnTopElevation;
    }

    @Override
    public Content getIcon() {
        return null;
    }

    @Override
    public void setIcon(Content content) {
        throw new IllegalStateException("Can't set icon of a group");
    }

    @Override
    public Content getPlanIcon() {
        return null;
    }

    @Override
    public void setPlanIcon(Content content) {
        throw new IllegalStateException("Can't set plan icon of a group");
    }

    @Override
    public Content getModel() {
        return null;
    }

    @Override
    public void setModel(Content content) {
        throw new IllegalStateException("Can't set model of a group");
    }

    @Override
    public Long getModelSize() {
        return null;
    }

    @Override
    public void setModelSize(Long l) {
        throw new IllegalStateException("Can't set model size of a group");
    }

    @Override
    public float[][] getModelRotation() {
        return IDENTITY_ROTATION;
    }

    @Override
    public void setModelRotation(float[][] fArray) {
        throw new IllegalStateException("Can't set model rotation of a group");
    }

    @Override
    public boolean isModelCenteredAtOrigin() {
        return true;
    }

    @Override
    public boolean isBackFaceShown() {
        return false;
    }

    @Override
    public void setBackFaceShown(boolean bl) {
        throw new IllegalStateException("Can't set back face shown attribute of a group");
    }

    @Override
    public Transformation[] getModelTransformations() {
        return null;
    }

    @Override
    public void setModelTransformations(Transformation[] transformationArray) {
        if (this.isDeformable()) {
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setModelTransformations(transformationArray);
            }
        }
    }

    @Override
    public float getPitch() {
        return 0.0f;
    }

    @Override
    public float getRoll() {
        return 0.0f;
    }

    @Override
    public String getStaircaseCutOutShape() {
        return null;
    }

    @Override
    public void setStaircaseCutOutShape(String string) {
        throw new IllegalStateException("Can't set staircase cut out shape of a group");
    }

    @Override
    public String getCreator() {
        return super.getCreator();
    }

    @Override
    public BigDecimal getPrice() {
        BigDecimal bigDecimal = null;
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            if (homePieceOfFurniture.getPrice() == null) continue;
            if (bigDecimal == null) {
                bigDecimal = homePieceOfFurniture.getPrice();
                continue;
            }
            bigDecimal = bigDecimal.add(homePieceOfFurniture.getPrice());
        }
        if (bigDecimal == null) {
            return super.getPrice();
        }
        return bigDecimal;
    }

    @Override
    public void setPrice(BigDecimal bigDecimal) {
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            if (homePieceOfFurniture.getPrice() == null) continue;
            throw new UnsupportedOperationException("Can't change the price of a group containing pieces with a price");
        }
        super.setPrice(bigDecimal);
    }

    @Override
    public BigDecimal getValueAddedTaxPercentage() {
        BigDecimal bigDecimal = this.furniture.get(0).getValueAddedTaxPercentage();
        if (bigDecimal != null) {
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                BigDecimal bigDecimal2 = homePieceOfFurniture.getValueAddedTaxPercentage();
                if (bigDecimal2 != null && bigDecimal2.equals(bigDecimal)) continue;
                return null;
            }
        }
        return bigDecimal;
    }

    @Override
    public String getCurrency() {
        return this.currency;
    }

    @Override
    public BigDecimal getValueAddedTax() {
        BigDecimal bigDecimal = null;
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            BigDecimal bigDecimal2 = homePieceOfFurniture.getValueAddedTax();
            if (bigDecimal2 == null) continue;
            if (bigDecimal == null) {
                bigDecimal = bigDecimal2;
                continue;
            }
            bigDecimal = bigDecimal.add(bigDecimal2);
        }
        return bigDecimal;
    }

    @Override
    public BigDecimal getPriceValueAddedTaxIncluded() {
        BigDecimal bigDecimal = null;
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            if (homePieceOfFurniture.getPrice() == null) continue;
            if (bigDecimal == null) {
                bigDecimal = homePieceOfFurniture.getPriceValueAddedTaxIncluded();
                continue;
            }
            bigDecimal = bigDecimal.add(homePieceOfFurniture.getPriceValueAddedTaxIncluded());
        }
        return bigDecimal;
    }

    @Override
    public Integer getColor() {
        return null;
    }

    @Override
    public void setColor(Integer n) {
        if (this.isTexturable()) {
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setColor(n);
            }
        }
    }

    @Override
    public HomeTexture getTexture() {
        return null;
    }

    @Override
    public void setTexture(HomeTexture homeTexture) {
        if (this.isTexturable()) {
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setTexture(homeTexture);
            }
        }
    }

    @Override
    public HomeMaterial[] getModelMaterials() {
        return null;
    }

    @Override
    public void setModelMaterials(HomeMaterial[] homeMaterialArray) {
        if (this.isTexturable()) {
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setModelMaterials(homeMaterialArray);
            }
        }
    }

    @Override
    public Float getShininess() {
        return null;
    }

    @Override
    public void setShininess(Float f) {
        if (this.isTexturable()) {
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.setShininess(f);
            }
        }
    }

    @Override
    public void setAngle(float f) {
        if (f != this.getAngle()) {
            float f2 = f - this.getAngle();
            double d = Math.cos(f2);
            double d2 = Math.sin(f2);
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.removePropertyChangeListener(this.furnitureListener);
                homePieceOfFurniture.setAngle(homePieceOfFurniture.getAngle() + f2);
                float f3 = this.getX() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d - (double)(homePieceOfFurniture.getY() - this.getY()) * d2);
                float f4 = this.getY() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d2 + (double)(homePieceOfFurniture.getY() - this.getY()) * d);
                homePieceOfFurniture.setX(f3);
                homePieceOfFurniture.setY(f4);
                homePieceOfFurniture.addPropertyChangeListener(this.furnitureListener);
            }
            super.setAngle(f);
        }
    }

    @Override
    public void setX(float f) {
        if (f != this.getX()) {
            float f2 = f - this.getX();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.removePropertyChangeListener(this.furnitureListener);
                homePieceOfFurniture.setX(homePieceOfFurniture.getX() + f2);
                homePieceOfFurniture.addPropertyChangeListener(this.furnitureListener);
            }
            super.setX(f);
        }
    }

    @Override
    public void setY(float f) {
        if (f != this.getY()) {
            float f2 = f - this.getY();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.removePropertyChangeListener(this.furnitureListener);
                homePieceOfFurniture.setY(homePieceOfFurniture.getY() + f2);
                homePieceOfFurniture.addPropertyChangeListener(this.furnitureListener);
            }
            super.setY(f);
        }
    }

    @Override
    public void setWidth(float f) {
        if (f != this.getWidth()) {
            float f2 = f / this.getWidth();
            float f3 = this.getAngle();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.removePropertyChangeListener(this.furnitureListener);
                float f4 = homePieceOfFurniture.getAngle() - f3;
                float f5 = homePieceOfFurniture.getWidth();
                float f6 = homePieceOfFurniture.getDepth();
                homePieceOfFurniture.setWidth(f5 + f5 * (f2 - 1.0f) * Math.abs((float)Math.cos(f4)));
                homePieceOfFurniture.setDepth(f6 + f6 * (f2 - 1.0f) * Math.abs((float)Math.sin(f4)));
                double d = Math.cos(f3);
                double d2 = Math.sin(f3);
                float f7 = this.getX() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d + (double)(homePieceOfFurniture.getY() - this.getY()) * d2);
                float f8 = this.getY() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * -d2 + (double)(homePieceOfFurniture.getY() - this.getY()) * d);
                f7 = this.getX() + (f7 - this.getX()) * f2;
                homePieceOfFurniture.setX(this.getX() + (float)((double)(f7 - this.getX()) * d - (double)(f8 - this.getY()) * d2));
                homePieceOfFurniture.setY(this.getY() + (float)((double)(f7 - this.getX()) * d2 + (double)(f8 - this.getY()) * d));
                homePieceOfFurniture.addPropertyChangeListener(this.furnitureListener);
            }
            super.setWidth(f);
        }
    }

    @Override
    public void setDepth(float f) {
        if (f != this.getDepth()) {
            float f2 = f / this.getDepth();
            float f3 = this.getAngle();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.removePropertyChangeListener(this.furnitureListener);
                float f4 = homePieceOfFurniture.getAngle() - f3;
                float f5 = homePieceOfFurniture.getWidth();
                float f6 = homePieceOfFurniture.getDepth();
                homePieceOfFurniture.setWidth(f5 + f5 * (f2 - 1.0f) * Math.abs((float)Math.sin(f4)));
                homePieceOfFurniture.setDepth(f6 + f6 * (f2 - 1.0f) * Math.abs((float)Math.cos(f4)));
                double d = Math.cos(f3);
                double d2 = Math.sin(f3);
                float f7 = this.getX() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d + (double)(homePieceOfFurniture.getY() - this.getY()) * d2);
                float f8 = this.getY() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * -d2 + (double)(homePieceOfFurniture.getY() - this.getY()) * d);
                f8 = this.getY() + (f8 - this.getY()) * f2;
                homePieceOfFurniture.setX(this.getX() + (float)((double)(f7 - this.getX()) * d - (double)(f8 - this.getY()) * d2));
                homePieceOfFurniture.setY(this.getY() + (float)((double)(f7 - this.getX()) * d2 + (double)(f8 - this.getY()) * d));
                homePieceOfFurniture.addPropertyChangeListener(this.furnitureListener);
            }
            super.setDepth(f);
        }
    }

    @Override
    public void setHeight(float f) {
        if (f != this.getHeight()) {
            float f2 = f / this.getHeight();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.removePropertyChangeListener(this.furnitureListener);
                homePieceOfFurniture.setHeight(homePieceOfFurniture.getHeight() * f2);
                homePieceOfFurniture.setElevation(this.getElevation() + (homePieceOfFurniture.getElevation() - this.getElevation()) * f2);
                homePieceOfFurniture.addPropertyChangeListener(this.furnitureListener);
            }
            super.setHeight(f);
        }
    }

    @Override
    public void scale(float f) {
        float f2 = this.getAngle();
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            homePieceOfFurniture.removePropertyChangeListener(this.furnitureListener);
            homePieceOfFurniture.setWidth(homePieceOfFurniture.getWidth() * f);
            homePieceOfFurniture.setDepth(homePieceOfFurniture.getDepth() * f);
            homePieceOfFurniture.setHeight(homePieceOfFurniture.getHeight() * f);
            double d = Math.cos(f2);
            double d2 = Math.sin(f2);
            float f3 = this.getX() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d + (double)(homePieceOfFurniture.getY() - this.getY()) * d2);
            float f4 = this.getY() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * -d2 + (double)(homePieceOfFurniture.getY() - this.getY()) * d);
            f3 = this.getX() + (f3 - this.getX()) * f;
            f4 = this.getY() + (f4 - this.getY()) * f;
            homePieceOfFurniture.setX(this.getX() + (float)((double)(f3 - this.getX()) * d - (double)(f4 - this.getY()) * d2));
            homePieceOfFurniture.setY(this.getY() + (float)((double)(f3 - this.getX()) * d2 + (double)(f4 - this.getY()) * d));
            homePieceOfFurniture.setElevation(this.getElevation() + (homePieceOfFurniture.getElevation() - this.getElevation()) * f);
            homePieceOfFurniture.addPropertyChangeListener(this.furnitureListener);
        }
        super.setWidth(this.getWidth() * f);
        super.setDepth(this.getDepth() * f);
        super.setHeight(this.getHeight() * f);
    }

    @Override
    public void setElevation(float f) {
        if (f != this.getElevation()) {
            float f2 = f - this.getElevation();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.removePropertyChangeListener(this.furnitureListener);
                homePieceOfFurniture.setElevation(homePieceOfFurniture.getElevation() + f2);
                homePieceOfFurniture.addPropertyChangeListener(this.furnitureListener);
            }
            super.setElevation(f);
        }
    }

    @Override
    public void setModelMirrored(boolean bl) {
        if (bl != this.isModelMirrored()) {
            float f = this.getAngle();
            for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
                homePieceOfFurniture.removePropertyChangeListener(this.furnitureListener);
                homePieceOfFurniture.setModelMirrored(!homePieceOfFurniture.isModelMirrored());
                double d = Math.cos(f);
                double d2 = Math.sin(f);
                float f2 = this.getX() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * d + (double)(homePieceOfFurniture.getY() - this.getY()) * d2);
                float f3 = this.getY() + (float)((double)(homePieceOfFurniture.getX() - this.getX()) * -d2 + (double)(homePieceOfFurniture.getY() - this.getY()) * d);
                f2 = this.getX() - (f2 - this.getX());
                homePieceOfFurniture.setX(this.getX() + (float)((double)(f2 - this.getX()) * d - (double)(f3 - this.getY()) * d2));
                homePieceOfFurniture.setY(this.getY() + (float)((double)(f2 - this.getX()) * d2 + (double)(f3 - this.getY()) * d));
                homePieceOfFurniture.addPropertyChangeListener(this.furnitureListener);
            }
            super.setModelMirrored(bl);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            homePieceOfFurniture.setVisible(bl);
        }
        super.setVisible(bl);
    }

    @Override
    public void setLevel(Level level) {
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            homePieceOfFurniture.setLevel(level);
        }
        super.setLevel(level);
    }

    @Override
    public boolean intersectsRectangle(float f, float f2, float f3, float f4) {
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            if (!homePieceOfFurniture.intersectsRectangle(f, f2, f3, f4)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsPoint(float f, float f2, float f3) {
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            if (!homePieceOfFurniture.containsPoint(f, f2, f3)) continue;
            return true;
        }
        return false;
    }

    @Override
    public HomeObject duplicate() {
        HomeFurnitureGroup homeFurnitureGroup = (HomeFurnitureGroup)super.duplicate();
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(homeFurnitureGroup.furniture.size());
        for (HomePieceOfFurniture homePieceOfFurniture : homeFurnitureGroup.furniture) {
            homePieceOfFurniture.removePropertyChangeListener(homeFurnitureGroup.furnitureListener);
            HomePieceOfFurniture homePieceOfFurniture2 = (HomePieceOfFurniture)homePieceOfFurniture.duplicate();
            arrayList.add(homePieceOfFurniture2);
            homePieceOfFurniture2.addPropertyChangeListener(homeFurnitureGroup.furnitureListener);
        }
        homeFurnitureGroup.furniture = Collections.unmodifiableList(arrayList);
        return homeFurnitureGroup;
    }

    @Override
    public HomeFurnitureGroup clone() {
        HomeFurnitureGroup homeFurnitureGroup = (HomeFurnitureGroup)super.clone();
        homeFurnitureGroup.furniture = new ArrayList<HomePieceOfFurniture>(this.furniture.size());
        for (HomePieceOfFurniture homePieceOfFurniture : this.furniture) {
            homeFurnitureGroup.furniture.add(homePieceOfFurniture.clone());
        }
        homeFurnitureGroup.furniture = Collections.unmodifiableList(homeFurnitureGroup.furniture);
        homeFurnitureGroup.addFurnitureListener();
        return homeFurnitureGroup;
    }

    private static class LocationAndSizeChangeListener
    implements PropertyChangeListener {
        private WeakReference<HomeFurnitureGroup> group;

        public LocationAndSizeChangeListener(HomeFurnitureGroup homeFurnitureGroup) {
            this.group = new WeakReference<HomeFurnitureGroup>(homeFurnitureGroup);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            HomeFurnitureGroup homeFurnitureGroup = (HomeFurnitureGroup)this.group.get();
            if (homeFurnitureGroup == null) {
                ((HomePieceOfFurniture)propertyChangeEvent.getSource()).removePropertyChangeListener(this);
            } else if (HomePieceOfFurniture.Property.X.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.Y.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.ELEVATION.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.ANGLE.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.WIDTH_IN_PLAN.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.DEPTH_IN_PLAN.name().equals(propertyChangeEvent.getPropertyName()) || HomePieceOfFurniture.Property.HEIGHT_IN_PLAN.name().equals(propertyChangeEvent.getPropertyName())) {
                homeFurnitureGroup.updateLocationAndSize(homeFurnitureGroup.getFurniture(), homeFurnitureGroup.getAngle(), false);
            }
        }
    }
}

