/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.awt.geom.Path2D;

public class QuadRect {
    public double left;
    public double right;
    public double top;
    public double bottom;

    public QuadRect(double left, double top, double right, double bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }

    public QuadRect(QuadRect a) {
        this(a.left, a.top, a.right, a.bottom);
    }

    public QuadRect() {
    }

    public double width() {
        return this.right - this.left;
    }

    public double height() {
        return this.bottom - this.top;
    }

    public boolean contains(double left, double top, double right, double bottom) {
        return this.left < this.right && this.top < this.bottom && this.left <= left && this.top <= top && this.right >= right && this.bottom >= bottom;
    }

    public boolean contains(QuadRect box) {
        return this.contains(box.left, box.top, box.right, box.bottom);
    }

    public static boolean intersects(QuadRect a, QuadRect b) {
        return a.left < b.right && b.left < a.right && a.top < b.bottom && b.top < a.bottom;
    }

    public double centerX() {
        return (this.left + this.right) / 2.0;
    }

    public double centerY() {
        return (this.top + this.bottom) / 2.0;
    }

    public void offset(double dx, double dy) {
        this.left += dx;
        this.top += dy;
        this.right += dx;
        this.bottom += dy;
    }

    public void inset(double dx, double dy) {
        this.left += dx;
        this.top += dy;
        this.right -= dx;
        this.bottom -= dy;
    }

    public String toString() {
        return "QuadRect [left=" + this.left + ", right=" + this.right + ", top=" + this.top + ", bottom=" + this.bottom + "]";
    }

    public Path2D toPath2D() {
        Path2D.Double ret = new Path2D.Double();
        ret.moveTo(this.left, this.top);
        ret.lineTo(this.left, this.bottom);
        ret.lineTo(this.right, this.bottom);
        ret.lineTo(this.right, this.top);
        ret.lineTo(this.left, this.top);
        return ret;
    }
}

