/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.beans;

import io.micronaut.core.beans.BeanIntrospection;
import io.micronaut.core.beans.BeanIntrospectionMap;
import io.micronaut.core.beans.BeanIntrospector;
import io.micronaut.core.beans.ReflectionBeanMap;
import io.micronaut.core.util.ArgumentUtils;
import java.util.Map;
import javax.annotation.Nonnull;

public interface BeanMap<T>
extends Map<String, Object> {
    @Nonnull
    public Class<T> getBeanType();

    @Nonnull
    public static <B> BeanMap<B> of(@Nonnull B bean) {
        ArgumentUtils.requireNonNull("bean", bean);
        return BeanIntrospector.SHARED.findIntrospection(bean.getClass()).map(i -> new BeanIntrospectionMap<Object>((BeanIntrospection<Object>)i, bean)).orElseGet(() -> new ReflectionBeanMap<Object>(bean));
    }
}

