/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import javax.management.Attribute;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.management.openmbean.CompositeData;
import org.apache.catalina.mbeans.MBeanDumper;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class JMXProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String[] NO_PARAMETERS = new String[0];
    private static final StringManager sm = StringManager.getManager(JMXProxyServlet.class);
    protected transient MBeanServer mBeanServer = null;
    protected transient Registry registry;

    public void init() throws ServletException {
        this.registry = Registry.getRegistry(null, null);
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        httpServletResponse.setContentType("text/plain;charset=utf-8");
        httpServletResponse.setHeader("X-Content-Type-Options", "nosniff");
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (this.mBeanServer == null) {
            printWriter.println("Error - No mbean server");
            return;
        }
        String string = httpServletRequest.getParameter("set");
        if (string != null) {
            String string2 = httpServletRequest.getParameter("att");
            String string3 = httpServletRequest.getParameter("val");
            this.setAttribute(printWriter, string, string2, string3);
            return;
        }
        string = httpServletRequest.getParameter("get");
        if (string != null) {
            String string4 = httpServletRequest.getParameter("att");
            this.getAttribute(printWriter, string, string4, httpServletRequest.getParameter("key"));
            return;
        }
        string = httpServletRequest.getParameter("invoke");
        if (string != null) {
            String string5 = httpServletRequest.getParameter("op");
            String[] stringArray = this.getInvokeParameters(httpServletRequest.getParameter("ps"));
            this.invokeOperation(printWriter, string, string5, stringArray);
            return;
        }
        string = httpServletRequest.getParameter("qry");
        if (string == null) {
            string = "*:*";
        }
        this.listBeans(printWriter, string);
    }

    public void getAttribute(PrintWriter printWriter, String string, String string2, String string3) {
        try {
            ObjectName objectName = new ObjectName(string);
            Object object = this.mBeanServer.getAttribute(objectName, string2);
            if (null != string3 && object instanceof CompositeData) {
                object = ((CompositeData)object).get(string3);
            }
            String string4 = object != null ? object.toString() : "<null>";
            printWriter.print("OK - Attribute get '");
            printWriter.print(string);
            printWriter.print("' - ");
            printWriter.print(string2);
            if (null != string3) {
                printWriter.print(" - key '");
                printWriter.print(string3);
                printWriter.print("'");
            }
            printWriter.print(" = ");
            printWriter.println(MBeanDumper.escape(string4));
        }
        catch (Exception exception) {
            printWriter.println("Error - " + exception.toString());
            exception.printStackTrace(printWriter);
        }
    }

    public void setAttribute(PrintWriter printWriter, String string, String string2, String string3) {
        try {
            this.setAttributeInternal(string, string2, string3);
            printWriter.println("OK - Attribute set");
        }
        catch (Exception exception) {
            printWriter.println("Error - " + exception.toString());
            exception.printStackTrace(printWriter);
        }
    }

    public void listBeans(PrintWriter printWriter, String string) {
        Set<ObjectName> set = null;
        try {
            set = this.mBeanServer.queryNames(new ObjectName(string), null);
            printWriter.println("OK - Number of results: " + set.size());
            printWriter.println();
        }
        catch (Exception exception) {
            printWriter.println("Error - " + exception.toString());
            exception.printStackTrace(printWriter);
            return;
        }
        String string2 = MBeanDumper.dumpBeans(this.mBeanServer, set);
        printWriter.print(string2);
    }

    public boolean isSupported(String string) {
        return true;
    }

    private void invokeOperation(PrintWriter printWriter, String string, String string2, String[] stringArray) {
        try {
            Object object = this.invokeOperationInternal(string, string2, stringArray);
            if (object != null) {
                printWriter.println("OK - Operation " + string2 + " returned:");
                this.output("", printWriter, object);
            } else {
                printWriter.println("OK - Operation " + string2 + " without return value");
            }
        }
        catch (Exception exception) {
            printWriter.println("Error - " + exception.toString());
            exception.printStackTrace(printWriter);
        }
    }

    private String[] getInvokeParameters(String string) {
        if (string == null) {
            return NO_PARAMETERS;
        }
        return string.split(",");
    }

    private void setAttributeInternal(String string, String string2, String string3) throws OperationsException, MBeanException, ReflectionException {
        ObjectName objectName = new ObjectName(string);
        String string4 = this.registry.getType(objectName, string2);
        Object object = this.registry.convertValue(string4, string3);
        this.mBeanServer.setAttribute(objectName, new Attribute(string2, object));
    }

    private Object invokeOperationInternal(String string, String string2, String[] stringArray) throws OperationsException, MBeanException, ReflectionException {
        ObjectName objectName = new ObjectName(string);
        int n = null == stringArray ? 0 : stringArray.length;
        MBeanOperationInfo mBeanOperationInfo = this.registry.getMethodInfo(objectName, string2, n);
        if (null == mBeanOperationInfo) {
            MBeanInfo mBeanInfo = null;
            try {
                mBeanInfo = this.registry.getMBeanServer().getMBeanInfo(objectName);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw instanceNotFoundException;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(sm.getString("jmxProxyServlet.noBeanFound", new Object[]{string}), exception);
            }
            throw new IllegalArgumentException(sm.getString("jmxProxyServlet.noOperationOnBean", new Object[]{string2, n, string, mBeanInfo.getClassName()}));
        }
        MBeanParameterInfo[] mBeanParameterInfoArray = mBeanOperationInfo.getSignature();
        String[] stringArray2 = new String[mBeanParameterInfoArray.length];
        Object[] objectArray = new Object[mBeanParameterInfoArray.length];
        for (int i = 0; i < mBeanParameterInfoArray.length; ++i) {
            MBeanParameterInfo mBeanParameterInfo = mBeanParameterInfoArray[i];
            stringArray2[i] = mBeanParameterInfo.getType();
            objectArray[i] = this.registry.convertValue(mBeanParameterInfo.getType(), stringArray[i]);
        }
        return this.mBeanServer.invoke(objectName, string2, objectArray, stringArray2);
    }

    private void output(String string, PrintWriter printWriter, Object object) {
        if (object instanceof Object[]) {
            for (Object object2 : (Object[])object) {
                this.output("  " + string, printWriter, object2);
            }
        } else {
            String string2 = object != null ? object.toString() : "<null>";
            printWriter.println(string + string2);
        }
    }
}

