/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.bbox;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.MemoryTileCache;
import org.openstreetmap.gui.jmapviewer.OsmTileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource;
import org.openstreetmap.josm.data.Version;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.ImageryLayerInfo;
import org.openstreetmap.josm.data.imagery.TMSCachedTileLoader;
import org.openstreetmap.josm.data.imagery.TileLoaderFactory;
import org.openstreetmap.josm.data.preferences.StringProperty;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.layer.AbstractCachedTileSourceLayer;
import org.openstreetmap.josm.gui.layer.ImageryLayer;
import org.openstreetmap.josm.gui.layer.TMSLayer;
import org.openstreetmap.josm.tools.Logging;

public class JosmMapViewer
extends JMapViewer {
    protected final transient TileLoader cachedLoader;
    protected final transient OsmTileLoader uncachedLoader;

    static List<TileSource> imageryInfosToTileSources(List<ImageryInfo> imageryInfos) {
        ArrayList<TileSource> sources = new ArrayList<TileSource>();
        for (ImageryInfo info : imageryInfos) {
            try {
                AbstractTMSTileSource source = TMSLayer.getTileSourceStatic(info);
                if (source == null) continue;
                sources.add(source);
            }
            catch (IllegalArgumentException ex) {
                Logging.trace(ex);
                Logging.warn(ex.getMessage());
                if (ex.getMessage() == null || ex.getMessage().isEmpty()) continue;
                new Notification(ex.getMessage()).setIcon(2).show();
            }
        }
        return sources;
    }

    public JosmMapViewer() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", Version.getInstance().getFullAgentString());
        TileLoaderFactory cachedLoaderFactory = AbstractCachedTileSourceLayer.getTileLoaderFactory("TMS", TMSCachedTileLoader.class);
        this.cachedLoader = cachedLoaderFactory != null ? cachedLoaderFactory.makeTileLoader(this, headers, TimeUnit.HOURS.toSeconds(1L)) : null;
        this.uncachedLoader = new OsmTileLoader(this);
        this.uncachedLoader.headers.putAll(headers);
        this.setFileCacheEnabled(true);
    }

    public final void setFileCacheEnabled(boolean enabled) {
        if (enabled && this.cachedLoader != null) {
            this.setTileLoader(this.cachedLoader);
        } else {
            this.setTileLoader(this.uncachedLoader);
        }
    }

    public final void setMaxTilesInMemory(int tiles) {
        ((MemoryTileCache)this.getTileCache()).setCacheSize(tiles);
    }

    public static class CurrentLayersTileSourceProvider
    extends AbstractImageryInfoBasedTileSourceProvider {
        @Override
        public List<ImageryInfo> getImageryInfos() {
            return MainApplication.getLayerManager().getLayers().stream().filter(layer -> layer instanceof ImageryLayer).map(layer -> ((ImageryLayer)layer).getInfo()).collect(Collectors.toList());
        }
    }

    public static class TMSTileSourceProvider
    extends AbstractImageryInfoBasedTileSourceProvider {
        @Override
        public List<ImageryInfo> getImageryInfos() {
            return ImageryLayerInfo.instance.getLayers();
        }
    }

    public static class DefaultOsmTileSourceProvider
    implements TileSourceProvider {
        protected static final StringProperty DEFAULT_OSM_TILE_URL = new StringProperty("default.osm.tile.source.url", "https://{switch:a,b,c}.tile.openstreetmap.org/{zoom}/{x}/{y}.png");

        @Override
        public List<TileSource> getTileSources() {
            List<TileSource> result = JosmMapViewer.imageryInfosToTileSources(ImageryLayerInfo.instance.getLayers().stream().filter(l -> l.getUrl().equals(DEFAULT_OSM_TILE_URL.get())).collect(Collectors.toList()));
            if (result.isEmpty()) {
                result.add(new OsmTileSource.Mapnik());
            }
            return result;
        }

        public static TileSource get() {
            return new DefaultOsmTileSourceProvider().getTileSources().get(0);
        }
    }

    public static abstract class AbstractImageryInfoBasedTileSourceProvider
    implements TileSourceProvider {
        public abstract List<ImageryInfo> getImageryInfos();

        @Override
        public List<TileSource> getTileSources() {
            if (!TMSLayer.PROP_ADD_TO_SLIPPYMAP_CHOOSER.get().booleanValue()) {
                return Collections.emptyList();
            }
            return JosmMapViewer.imageryInfosToTileSources(this.getImageryInfos());
        }
    }

    @FunctionalInterface
    public static interface TileSourceProvider {
        public List<TileSource> getTileSources();
    }
}

