/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.conflict.pair.tags;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.table.DefaultTableModel;
import org.openstreetmap.josm.command.conflict.TagConflictResolveCommand;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.conflict.pair.MergeDecisionType;
import org.openstreetmap.josm.gui.conflict.pair.tags.TagMergeItem;

public class TagMergeModel
extends DefaultTableModel {
    public static final String PROP_NUM_UNDECIDED_TAGS = TagMergeModel.class.getName() + ".numUndecidedTags";
    private final transient List<TagMergeItem> tagMergeItems = new ArrayList<TagMergeItem>();
    private final transient Set<PropertyChangeListener> listeners = new HashSet<PropertyChangeListener>();
    private int numUndecidedTags;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            if (listener == null) {
                return;
            }
            if (this.listeners.contains(listener)) {
                return;
            }
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            if (listener == null) {
                return;
            }
            if (!this.listeners.contains(listener)) {
                return;
            }
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNumUndecidedTagsChanged(int oldValue, int newValue) {
        PropertyChangeEvent evt = new PropertyChangeEvent(this, PROP_NUM_UNDECIDED_TAGS, oldValue, newValue);
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            for (PropertyChangeListener l : this.listeners) {
                l.propertyChange(evt);
            }
        }
    }

    protected void refreshNumUndecidedTags() {
        int oldValue = this.numUndecidedTags;
        this.numUndecidedTags = this.getNumUnresolvedConflicts();
        this.fireNumUndecidedTagsChanged(oldValue, this.numUndecidedTags);
    }

    public void populate(OsmPrimitive my, OsmPrimitive their) {
        this.tagMergeItems.clear();
        Set keys = Stream.concat(my.keys(), their.keys()).collect(Collectors.toSet());
        for (String key : keys) {
            String myValue = my.get(key);
            String theirValue = their.get(key);
            if (myValue != null && theirValue != null && myValue.equals(theirValue)) continue;
            this.tagMergeItems.add(new TagMergeItem(key, my, their));
        }
        this.fireTableDataChanged();
        this.refreshNumUndecidedTags();
    }

    public void addItem(TagMergeItem item) {
        if (item != null) {
            this.tagMergeItems.add(item);
            this.fireTableDataChanged();
            this.refreshNumUndecidedTags();
        }
    }

    protected void rememberDecision(int row, MergeDecisionType decision) {
        TagMergeItem item = this.tagMergeItems.get(row);
        item.decide(decision);
    }

    public void decide(int row, MergeDecisionType decision) {
        this.rememberDecision(row, decision);
        this.fireTableRowsUpdated(row, row);
        this.refreshNumUndecidedTags();
    }

    public void decide(int[] rows, MergeDecisionType decision) {
        if (rows == null || rows.length == 0) {
            return;
        }
        for (int row : rows) {
            this.rememberDecision(row, decision);
        }
        this.fireTableDataChanged();
        this.refreshNumUndecidedTags();
    }

    @Override
    public int getRowCount() {
        return this.tagMergeItems == null ? 0 : this.tagMergeItems.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.tagMergeItems.get(row);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public TagConflictResolveCommand buildResolveCommand(Conflict<? extends OsmPrimitive> conflict) {
        return new TagConflictResolveCommand(conflict, new ArrayList<TagMergeItem>(this.tagMergeItems));
    }

    public boolean isResolvedCompletely() {
        return this.tagMergeItems.stream().noneMatch(item -> item.getMergeDecision() == MergeDecisionType.UNDECIDED);
    }

    public void decideRemaining(MergeDecisionType decision) {
        for (TagMergeItem item : this.tagMergeItems) {
            if (item.getMergeDecision() != MergeDecisionType.UNDECIDED) continue;
            item.decide(decision);
        }
    }

    public int getNumResolvedConflicts() {
        return (int)this.tagMergeItems.stream().filter(item -> item.getMergeDecision() != MergeDecisionType.UNDECIDED).count();
    }

    public int getNumUnresolvedConflicts() {
        return (int)this.tagMergeItems.stream().filter(item -> item.getMergeDecision() == MergeDecisionType.UNDECIDED).count();
    }

    public int getFirstUndecided(int startIndex) {
        return IntStream.range(startIndex, this.tagMergeItems.size()).filter(i -> this.tagMergeItems.get(i).getMergeDecision() == MergeDecisionType.UNDECIDED).findFirst().orElse(-1);
    }
}

