/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.math;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.math.AsciiMath;
import net.sourceforge.plantuml.math.LatexBuilder;
import net.sourceforge.plantuml.math.ScientificEquation;
import net.sourceforge.plantuml.security.ImageIO;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.MutableImage;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UImageSvg;

public class ScientificEquationSafe {
    private final ScientificEquation equation;
    private final String formula;
    private ImageData dimSvg;

    private ScientificEquationSafe(String formula, ScientificEquation equation) {
        this.formula = formula;
        this.equation = equation;
    }

    public static ScientificEquationSafe fromAsciiMath(String formula) {
        try {
            return new ScientificEquationSafe(formula, new AsciiMath(formula));
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.info("Error parsing " + formula);
            return new ScientificEquationSafe(formula, null);
        }
    }

    public static ScientificEquationSafe fromLatex(String formula) {
        try {
            return new ScientificEquationSafe(formula, new LatexBuilder(formula));
        }
        catch (Exception e) {
            e.printStackTrace();
            Log.info("Error parsing " + formula);
            return new ScientificEquationSafe(formula, null);
        }
    }

    public UImageSvg getSvg(double scale, Color foregroundColor, Color backgroundColor) {
        if (this.equation != null) {
            try {
                UImageSvg svg = this.equation.getSvg(scale, foregroundColor, backgroundColor);
                this.dimSvg = new ImageDataSimple(this.equation.getDimension());
                return svg;
            }
            catch (Exception e) {
                this.printTrace(e);
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.dimSvg = ImageBuilder.plainImageBuilder(this.getRollback(), new FileFormatOption(FileFormat.SVG)).write(baos);
        }
        catch (IOException e1) {
            return null;
        }
        return new UImageSvg(new String(baos.toByteArray()), scale);
    }

    public MutableImage getImage(Color foregroundColor, Color backgroundColor) {
        if (this.equation != null) {
            try {
                return this.equation.getImage(foregroundColor, backgroundColor);
            }
            catch (Exception e) {
                this.printTrace(e);
            }
        }
        try {
            byte[] bytes = ImageBuilder.plainPngBuilder(this.getRollback()).writeByteArray();
            return new PixelImage(ImageIO.read(new ByteArrayInputStream(bytes)), AffineTransformType.TYPE_BILINEAR);
        }
        catch (IOException e1) {
            return null;
        }
    }

    private void printTrace(Exception e) {
        System.err.println("formula=" + this.formula);
        if (this.equation != null) {
            System.err.println("Latex=" + this.equation.getSource());
        }
        e.printStackTrace();
    }

    private TextBlockBackcolored getRollback() {
        return GraphicStrings.createBlackOnWhiteMonospaced(Arrays.asList(this.formula));
    }

    public ImageData export(OutputStream os, FileFormatOption fileFormat, float scale, Color foregroundColor, Color backgroundColor) throws IOException {
        if (fileFormat.getFileFormat() == FileFormat.PNG) {
            BufferedImage image = this.getImage(foregroundColor, backgroundColor).withScale(scale).getImage();
            ImageIO.write((RenderedImage)image, "png", os);
            return new ImageDataSimple(image.getWidth(), image.getHeight());
        }
        if (fileFormat.getFileFormat() == FileFormat.SVG) {
            os.write(this.getSvg(1.0, foregroundColor, backgroundColor).getSvg(true).getBytes());
            return this.dimSvg;
        }
        if (fileFormat.getFileFormat() == FileFormat.EPS) {
            BufferedImage image = this.getImage(foregroundColor, backgroundColor).withScale(scale).getImage();
            EpsGraphics out = new EpsGraphics();
            out.drawImage(image, 0.0, 0.0);
            out.close();
            os.write(out.getEPSCode().getBytes());
            return new ImageDataSimple(image.getWidth(), image.getHeight());
        }
        throw new UnsupportedOperationException();
    }

    public final String getFormula() {
        return this.formula;
    }
}

