/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.Principal;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.connector.Request;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.codec.binary.Base64;

public class BasicAuthenticator
extends AuthenticatorBase {
    protected static final String info = "org.apache.catalina.authenticator.BasicAuthenticator/1.0";
    private Charset charset = B2CConverter.ISO_8859_1;
    private String charsetString = null;

    @Override
    public String getInfo() {
        return info;
    }

    public String getCharset() {
        return this.charsetString;
    }

    public void setCharset(String string) {
        if (string == null || string.isEmpty()) {
            this.charset = B2CConverter.ISO_8859_1;
        } else if ("UTF-8".equalsIgnoreCase(string)) {
            this.charset = B2CConverter.UTF_8;
        } else {
            throw new IllegalArgumentException(sm.getString("basicAuthenticator.invalidCharset"));
        }
        this.charsetString = string;
    }

    @Override
    public boolean authenticate(Request request, HttpServletResponse httpServletResponse, LoginConfig loginConfig) throws IOException {
        Object object;
        if (this.checkForCachedAuthentication(request, httpServletResponse, true)) {
            return true;
        }
        String string = null;
        String string2 = null;
        MessageBytes messageBytes = request.getCoyoteRequest().getMimeHeaders().getValue("authorization");
        if (messageBytes != null) {
            Object object2;
            messageBytes.toBytes();
            object = messageBytes.getByteChunk();
            if (object.startsWithIgnoreCase("basic ", 0)) {
                object.setOffset(object.getOffset() + 6);
                object2 = Base64.decodeBase64((byte[])object.getBuffer(), (int)object.getOffset(), (int)object.getLength());
                int n = -1;
                for (int i = 0; i < ((Object)object2).length; ++i) {
                    if (object2[i] != 58) continue;
                    n = i;
                    break;
                }
                if (n < 0) {
                    string = new String((byte[])object2, this.charset);
                } else {
                    string = new String((byte[])object2, 0, n, this.charset);
                    string2 = new String((byte[])object2, n + 1, ((Object)object2).length - n - 1, this.charset);
                }
                object.setOffset(object.getOffset() - 6);
            }
            if ((object2 = this.context.getRealm().authenticate(string, string2)) != null) {
                this.register(request, httpServletResponse, (Principal)object2, "BASIC", string, string2);
                return true;
            }
        }
        object = new StringBuilder(16);
        ((StringBuilder)object).append("Basic realm=\"");
        if (loginConfig.getRealmName() == null) {
            ((StringBuilder)object).append("Authentication required");
        } else {
            ((StringBuilder)object).append(loginConfig.getRealmName());
        }
        ((StringBuilder)object).append('\"');
        if (this.charsetString != null && !this.charsetString.isEmpty()) {
            ((StringBuilder)object).append(", charset=");
            ((StringBuilder)object).append(this.charsetString);
        }
        httpServletResponse.setHeader("WWW-Authenticate", ((StringBuilder)object).toString());
        httpServletResponse.sendError(401);
        return false;
    }

    @Override
    protected String getAuthMethod() {
        return "BASIC";
    }
}

