/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ErrorState;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.ajp.AbstractAjpProcessor;
import org.apache.coyote.ajp.AjpMessage;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class AjpNioProcessor
extends AbstractAjpProcessor<NioChannel> {
    private static final Log log = LogFactory.getLog(AjpNioProcessor.class);
    protected NioSelectorPool pool;

    @Override
    protected Log getLog() {
        return log;
    }

    public AjpNioProcessor(int n, NioEndpoint nioEndpoint) {
        super(n, nioEndpoint);
        this.response.setOutputBuffer(new AbstractAjpProcessor.SocketOutputBuffer());
        this.pool = nioEndpoint.getSelectorPool();
    }

    @Override
    public AbstractEndpoint.Handler.SocketState process(SocketWrapper<NioChannel> socketWrapper) throws IOException {
        RequestInfo requestInfo = this.request.getRequestProcessor();
        requestInfo.setStage(1);
        this.socketWrapper = socketWrapper;
        long l = this.endpoint.getSoTimeout();
        boolean bl = false;
        while (!this.getErrorState().isError() && !this.endpoint.isPaused()) {
            try {
                byte by;
                int n = this.readMessage(this.requestHeaderMessage, false);
                if (n == 0) break;
                if (this.keepAliveTimeout > 0) {
                    socketWrapper.setTimeout(l);
                }
                if ((by = this.requestHeaderMessage.getByte()) == 10) {
                    if (this.endpoint.isPaused()) {
                        this.recycle(true);
                        break;
                    }
                    bl = true;
                    try {
                        this.output(pongMessageArray, 0, pongMessageArray.length);
                    }
                    catch (IOException iOException) {
                        this.setErrorState(ErrorState.CLOSE_NOW, null);
                    }
                    this.recycle(false);
                    continue;
                }
                if (by != 2) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Unexpected message: " + by));
                    }
                    this.setErrorState(ErrorState.CLOSE_NOW, null);
                    this.recycle(true);
                    break;
                }
                this.request.setStartTime(System.currentTimeMillis());
            }
            catch (IOException iOException) {
                this.setErrorState(ErrorState.CLOSE_NOW, iOException);
                break;
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
                log.debug((Object)sm.getString("ajpprocessor.header.error"), throwable);
                this.response.setStatus(400);
                this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                this.getAdapter().log(this.request, this.response, 0L);
            }
            if (!this.getErrorState().isError()) {
                requestInfo.setStage(2);
                try {
                    this.prepareRequest();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    log.debug((Object)sm.getString("ajpprocessor.request.prepare"), throwable);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            if (!this.getErrorState().isError() && !bl && this.endpoint.isPaused()) {
                this.response.setStatus(503);
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                this.getAdapter().log(this.request, this.response, 0L);
            }
            bl = false;
            if (!this.getErrorState().isError()) {
                try {
                    requestInfo.setStage(3);
                    this.adapter.service(this.request, this.response);
                }
                catch (InterruptedIOException interruptedIOException) {
                    this.setErrorState(ErrorState.CLOSE_NOW, interruptedIOException);
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    log.error((Object)sm.getString("ajpprocessor.request.process"), throwable);
                    this.response.setStatus(500);
                    this.setErrorState(ErrorState.CLOSE_CLEAN, throwable);
                    this.getAdapter().log(this.request, this.response, 0L);
                }
            }
            if (this.isAsync() && !this.getErrorState().isError()) break;
            if (!this.finished && this.getErrorState().isIoAllowed()) {
                try {
                    this.finish();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    this.setErrorState(ErrorState.CLOSE_NOW, throwable);
                }
            }
            if (this.getErrorState().isError()) {
                this.response.setStatus(500);
            }
            this.request.updateCounters();
            requestInfo.setStage(6);
            if (this.keepAliveTimeout > 0) {
                socketWrapper.setTimeout(this.keepAliveTimeout);
            }
            this.recycle(false);
        }
        requestInfo.setStage(7);
        if (!this.getErrorState().isError() && !this.endpoint.isPaused()) {
            if (this.isAsync()) {
                return AbstractEndpoint.Handler.SocketState.LONG;
            }
            return AbstractEndpoint.Handler.SocketState.OPEN;
        }
        return AbstractEndpoint.Handler.SocketState.CLOSED;
    }

    @Override
    protected void actionInternal(ActionCode actionCode, Object object) {
        switch (actionCode) {
            case ASYNC_COMPLETE: {
                if (!this.asyncStateMachine.asyncComplete()) break;
                ((NioEndpoint)this.endpoint).processSocket((NioChannel)this.socketWrapper.getSocket(), SocketStatus.OPEN_READ, false);
                break;
            }
            case ASYNC_SETTIMEOUT: {
                if (object == null) {
                    return;
                }
                long l = (Long)object;
                NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)((NioChannel)this.socketWrapper.getSocket()).getAttachment();
                keyAttachment.setTimeout(l);
                break;
            }
            case ASYNC_DISPATCH: {
                if (!this.asyncStateMachine.asyncDispatch()) break;
                ((NioEndpoint)this.endpoint).processSocket((NioChannel)this.socketWrapper.getSocket(), SocketStatus.OPEN_READ, true);
            }
        }
    }

    @Override
    protected void resetTimeouts() {
        NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)((NioChannel)this.socketWrapper.getSocket()).getAttachment();
        if (!this.getErrorState().isError() && keyAttachment != null && this.asyncStateMachine.isAsyncDispatching()) {
            long l = this.endpoint.getSoTimeout();
            if (this.keepAliveTimeout > 0) {
                keyAttachment.setTimeout(this.keepAliveTimeout);
            } else {
                keyAttachment.setTimeout(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void output(byte[] byArray, int n, int n2) throws IOException {
        NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)((NioChannel)this.socketWrapper.getSocket()).getAttachment();
        if (keyAttachment == null) {
            throw new IOException("Key must be cancelled");
        }
        ByteBuffer byteBuffer = ((NioChannel)this.socketWrapper.getSocket()).getBufHandler().getWriteBuffer();
        int n3 = 0;
        for (int i = 0; i < n2; i += n3) {
            int n4 = Math.min(n2 - i, byteBuffer.remaining());
            byteBuffer.put(byArray, n + i, n4);
            byteBuffer.flip();
            long l = keyAttachment.getWriteTimeout();
            Selector selector = null;
            try {
                selector = this.pool.get();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                n3 = this.pool.write(byteBuffer, (NioChannel)this.socketWrapper.getSocket(), selector, l, true);
                continue;
            }
            finally {
                byteBuffer.clear();
                if (selector != null) {
                    this.pool.put(selector);
                }
            }
        }
    }

    protected int read(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        int n3;
        int n4 = 0;
        boolean bl2 = bl;
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = this.readSocket(byArray, n3 + n, n2 - n3, bl2);
            if (n4 > 0) {
            } else {
                if (n4 == 0 && !bl2) break;
                throw new IOException(sm.getString("ajpprocessor.failedread"));
            }
            bl2 = true;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readSocket(byte[] byArray, int n, int n2, boolean bl) throws IOException {
        int n3 = 0;
        ByteBuffer byteBuffer = ((NioChannel)this.socketWrapper.getSocket()).getBufHandler().getReadBuffer();
        byteBuffer.clear();
        if (n2 < byteBuffer.capacity()) {
            byteBuffer.limit(n2);
        }
        if (bl) {
            Selector selector = null;
            try {
                selector = this.pool.get();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)((NioChannel)this.socketWrapper.getSocket()).getAttachment();
                if (keyAttachment == null) {
                    throw new IOException("Key must be cancelled.");
                }
                n3 = this.pool.read(byteBuffer, (NioChannel)this.socketWrapper.getSocket(), selector, keyAttachment.getTimeout());
            }
            catch (EOFException eOFException) {
                n3 = -1;
            }
            finally {
                if (selector != null) {
                    this.pool.put(selector);
                }
            }
        } else {
            n3 = ((NioChannel)this.socketWrapper.getSocket()).read(byteBuffer);
        }
        if (n3 > 0) {
            byteBuffer.flip();
            byteBuffer.limit(n3);
            byteBuffer.get(byArray, n, n3);
            return n3;
        }
        if (n3 == -1) {
            throw new EOFException(sm.getString("iib.eof.error"));
        }
        return 0;
    }

    @Override
    public boolean receive() throws IOException {
        this.first = false;
        this.bodyMessage.reset();
        this.readMessage(this.bodyMessage, true);
        if (this.bodyMessage.getLen() == 0) {
            return false;
        }
        int n = this.bodyMessage.peekInt();
        if (n == 0) {
            return false;
        }
        this.bodyMessage.getBodyBytes(this.bodyBytes);
        this.empty = false;
        return true;
    }

    protected int readMessage(AjpMessage ajpMessage, boolean bl) throws IOException {
        int n;
        byte[] byArray = ajpMessage.getBuffer();
        int n2 = this.read(byArray, 0, n = ajpMessage.getHeaderLength(), bl);
        if (n2 == 0) {
            return 0;
        }
        int n3 = ajpMessage.processHeader(true);
        if (n3 < 0) {
            throw new IOException(sm.getString("ajpmessage.invalidLength", new Object[]{n3}));
        }
        if (n3 == 0) {
            return n2;
        }
        if (n3 > byArray.length) {
            String string = sm.getString("ajpprocessor.header.tooLong", new Object[]{n3, byArray.length});
            this.getLog().error((Object)string);
            throw new IllegalArgumentException(string);
        }
        return n2 += this.read(byArray, n, n3, true);
    }
}

