/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.AbstractChunk;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.CookieSupport;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.ServerCookie;
import org.apache.tomcat.util.log.UserDataHelper;
import org.apache.tomcat.util.res.StringManager;

public final class Cookies {
    private static final Log log = LogFactory.getLog(Cookies.class);
    private static final UserDataHelper userDataLog = new UserDataHelper(log);
    static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.http");
    public static final int INITIAL_SIZE = 4;
    ServerCookie[] scookies = new ServerCookie[4];
    int cookieCount = 0;
    private int limit = 200;
    boolean unprocessed = true;
    MimeHeaders headers;

    public Cookies(MimeHeaders mimeHeaders) {
        this.headers = mimeHeaders;
    }

    public void setLimit(int n) {
        this.limit = n;
        if (n > -1 && this.scookies.length > n && this.cookieCount <= n) {
            ServerCookie[] serverCookieArray = new ServerCookie[n];
            System.arraycopy(this.scookies, 0, serverCookieArray, 0, this.cookieCount);
            this.scookies = serverCookieArray;
        }
    }

    public void recycle() {
        for (int i = 0; i < this.cookieCount; ++i) {
            if (this.scookies[i] == null) continue;
            this.scookies[i].recycle();
        }
        this.cookieCount = 0;
        this.unprocessed = true;
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("=== Cookies ===");
        int n = this.getCookieCount();
        for (int i = 0; i < n; ++i) {
            printWriter.println(this.getCookie(i).toString());
        }
        return stringWriter.toString();
    }

    public ServerCookie getCookie(int n) {
        if (this.unprocessed) {
            this.getCookieCount();
        }
        return this.scookies[n];
    }

    public int getCookieCount() {
        if (this.unprocessed) {
            this.unprocessed = false;
            this.processCookies(this.headers);
        }
        return this.cookieCount;
    }

    private ServerCookie addCookie() {
        ServerCookie serverCookie;
        if (this.limit > -1 && this.cookieCount >= this.limit) {
            throw new IllegalArgumentException(sm.getString("cookies.maxCountFail", new Object[]{this.limit}));
        }
        if (this.cookieCount >= this.scookies.length) {
            int n = this.limit > -1 ? Math.min(2 * this.cookieCount, this.limit) : 2 * this.cookieCount;
            ServerCookie[] serverCookieArray = new ServerCookie[n];
            System.arraycopy(this.scookies, 0, serverCookieArray, 0, this.cookieCount);
            this.scookies = serverCookieArray;
        }
        if ((serverCookie = this.scookies[this.cookieCount]) == null) {
            this.scookies[this.cookieCount] = serverCookie = new ServerCookie();
        }
        ++this.cookieCount;
        return serverCookie;
    }

    public void processCookies(MimeHeaders mimeHeaders) {
        if (mimeHeaders == null) {
            return;
        }
        int n = 0;
        while (n >= 0 && (n = mimeHeaders.findHeader("Cookie", n)) >= 0) {
            Serializable serializable;
            MessageBytes messageBytes = mimeHeaders.getValue(n);
            if (messageBytes == null || messageBytes.isNull()) {
                ++n;
                continue;
            }
            if (messageBytes.getType() != 2) {
                serializable = new Exception();
                log.warn((Object)"Cookies: Parsing cookie as String. Expected bytes.", (Throwable)serializable);
                messageBytes.toBytes();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cookies: Parsing b[]: " + messageBytes.toString()));
            }
            serializable = messageBytes.getByteChunk();
            if (CookieSupport.PRESERVE_COOKIE_HEADER) {
                int n2 = ((AbstractChunk)serializable).getLength();
                if (n2 > 0) {
                    byte[] byArray = new byte[n2];
                    System.arraycopy(((ByteChunk)serializable).getBytes(), ((AbstractChunk)serializable).getOffset(), byArray, 0, n2);
                    this.processCookieHeader(byArray, 0, n2);
                }
            } else {
                this.processCookieHeader(((ByteChunk)serializable).getBytes(), ((AbstractChunk)serializable).getOffset(), ((AbstractChunk)serializable).getLength());
            }
            ++n;
        }
    }

    private static boolean equals(String string, byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (byArray == null || n3 != string.length()) {
            return false;
        }
        int n4 = n;
        for (int i = 0; i < n3; ++i) {
            if (byArray[n4++] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static final boolean isWhiteSpace(byte by) {
        return by == 32 || by == 9 || by == 10 || by == 13 || by == 12;
    }

    private static void unescapeDoubleQuotes(ByteChunk byteChunk) {
        int n;
        if (byteChunk == null || byteChunk.getLength() == 0 || byteChunk.indexOf('\"', 0) == -1) {
            return;
        }
        int n2 = byteChunk.getEnd();
        int n3 = n;
        byte[] byArray = byteChunk.getBuffer();
        for (n = byteChunk.getStart(); n < n2; ++n) {
            if (byArray[n] == 92 && n < n2 && byArray[n + 1] == 34) {
                ++n;
            }
            byArray[n3] = byArray[n];
            ++n3;
        }
        byteChunk.setEnd(n3);
    }

    /*
     * Unable to fully structure code
     */
    protected final void processCookieHeader(byte[] var1_1, int var2_2, int var3_3) {
        if (var3_3 <= 0 || var1_1 == null) {
            return;
        }
        var4_4 = var2_2 + var3_3;
        var5_5 = var2_2;
        var6_6 = 0;
        var7_7 = 0;
        var8_8 = 0;
        var9_9 = 0;
        var10_10 = 0;
        var11_11 = null;
        while (var5_5 < var4_4) {
            block33: {
                block32: {
                    var12_12 = false;
                    var13_13 = false;
                    while (var5_5 < var4_4 && (CookieSupport.isHttpSeparator((char)var1_1[var5_5]) && !CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 || CookieSupport.isV0Separator((char)var1_1[var5_5]) || Cookies.isWhiteSpace(var1_1[var5_5]))) {
                        ++var5_5;
                    }
                    if (var5_5 >= var4_4) {
                        return;
                    }
                    if (var1_1[var5_5] == 36) {
                        var12_12 = true;
                    }
                    var8_8 = var6_6 = ++var5_5;
                    var9_9 = var6_6;
                    for (var5_5 = var7_7 = Cookies.getTokenEndPosition(var1_1, var5_5, var4_4, var10_10, true); var5_5 < var4_4 && Cookies.isWhiteSpace(var1_1[var5_5]); ++var5_5) {
                    }
                    if (var5_5 >= var4_4 - 1 || var1_1[var5_5] != 61) break block32;
                    while (++var5_5 < var4_4 && Cookies.isWhiteSpace(var1_1[var5_5])) {
                    }
                    if (var5_5 >= var4_4) {
                        return;
                    }
                    switch (var1_1[var5_5]) {
                        case 34: {
                            var13_13 = true;
                            var8_8 = var5_5 + 1;
                            var5_5 = var9_9 = Cookies.getQuotedValueEndPosition(var1_1, var8_8, var4_4);
                            if (var5_5 >= var4_4) {
                                return;
                            }
                            break block33;
                        }
                        case 44: 
                        case 59: {
                            var9_9 = -1;
                            var8_8 = -1;
                            break block33;
                        }
                        default: {
                            if ((var10_10 != 0 || CookieSupport.isV0Separator((char)var1_1[var5_5]) || !CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0) && CookieSupport.isHttpSeparator((char)var1_1[var5_5]) && (var1_1[var5_5] != 61 || !CookieSupport.ALLOW_EQUALS_IN_VALUE)) ** GOTO lbl47
                            var8_8 = var5_5;
                            var5_5 = var9_9 = Cookies.getTokenEndPosition(var1_1, var8_8, var4_4, var10_10, false);
                            break block33;
lbl47:
                            // 1 sources

                            var14_14 = Cookies.userDataLog.getNextMode();
                            if (var14_14 != null) {
                                var15_15 = Cookies.sm.getString("cookies.invalidCookieToken");
                                switch (1.$SwitchMap$org$apache$tomcat$util$log$UserDataHelper$Mode[var14_14.ordinal()]) {
                                    case 1: {
                                        var15_15 = var15_15 + Cookies.sm.getString("cookies.fallToDebug");
                                    }
                                    case 2: {
                                        Cookies.log.info((Object)var15_15);
                                        break;
                                    }
                                    case 3: {
                                        Cookies.log.debug((Object)var15_15);
                                    }
                                }
                            }
                            while (var5_5 < var4_4 && var1_1[var5_5] != 59 && var1_1[var5_5] != 44) {
                                ++var5_5;
                            }
                            ++var5_5;
                            var11_11 = null;
                            break;
                        }
                    }
                    continue;
                }
                var9_9 = -1;
                var8_8 = -1;
                var5_5 = var7_7;
            }
            while (var5_5 < var4_4 && Cookies.isWhiteSpace(var1_1[var5_5])) {
                ++var5_5;
            }
            while (var5_5 < var4_4 && var1_1[var5_5] != 59 && var1_1[var5_5] != 44) {
                ++var5_5;
            }
            ++var5_5;
            if (var12_12) {
                var12_12 = false;
                if (Cookies.equals("Version", var1_1, var6_6, var7_7) && var11_11 == null) {
                    if (var1_1[var8_8] != 49 || var9_9 != var8_8 + 1) continue;
                    var10_10 = 1;
                    continue;
                }
                if (var11_11 == null) continue;
                if (Cookies.equals("Domain", var1_1, var6_6, var7_7)) {
                    var11_11.getDomain().setBytes(var1_1, var8_8, var9_9 - var8_8);
                    continue;
                }
                if (Cookies.equals("Path", var1_1, var6_6, var7_7)) {
                    var11_11.getPath().setBytes(var1_1, var8_8, var9_9 - var8_8);
                    continue;
                }
                if (Cookies.equals("Port", var1_1, var6_6, var7_7) || Cookies.equals("CommentURL", var1_1, var6_6, var7_7) || (var14_14 = Cookies.userDataLog.getNextMode()) == null) continue;
                var15_15 = Cookies.sm.getString("cookies.invalidSpecial");
                switch (1.$SwitchMap$org$apache$tomcat$util$log$UserDataHelper$Mode[var14_14.ordinal()]) {
                    case 1: {
                        var15_15 = var15_15 + Cookies.sm.getString("cookies.fallToDebug");
                    }
                    case 2: {
                        Cookies.log.info((Object)var15_15);
                        break;
                    }
                    case 3: {
                        Cookies.log.debug((Object)var15_15);
                    }
                }
                continue;
            }
            if (var8_8 == -1 && !CookieSupport.ALLOW_NAME_ONLY) continue;
            var11_11 = this.addCookie();
            var11_11.setVersion(var10_10);
            var11_11.getName().setBytes(var1_1, var6_6, var7_7 - var6_6);
            if (var8_8 != -1) {
                var11_11.getValue().setBytes(var1_1, var8_8, var9_9 - var8_8);
                if (!var13_13) continue;
                Cookies.unescapeDoubleQuotes(var11_11.getValue().getByteChunk());
                continue;
            }
            var11_11.getValue().setString("");
        }
    }

    private static final int getTokenEndPosition(byte[] byArray, int n, int n2, int n3, boolean bl) {
        int n4;
        for (n4 = n; n4 < n2 && (!CookieSupport.isHttpSeparator((char)byArray[n4]) || n3 == 0 && CookieSupport.ALLOW_HTTP_SEPARATORS_IN_V0 && byArray[n4] != 61 && !CookieSupport.isV0Separator((char)byArray[n4]) || !bl && byArray[n4] == 61 && CookieSupport.ALLOW_EQUALS_IN_VALUE); ++n4) {
        }
        if (n4 > n2) {
            return n2;
        }
        return n4;
    }

    private static final int getQuotedValueEndPosition(byte[] byArray, int n, int n2) {
        int n3 = n;
        while (n3 < n2) {
            if (byArray[n3] == 34) {
                return n3;
            }
            if (byArray[n3] == 92 && n3 < n2 - 1) {
                n3 += 2;
                continue;
            }
            ++n3;
        }
        return n2;
    }
}

