/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.membership.MemberImpl;

public class Membership
implements Cloneable {
    protected static final MemberImpl[] EMPTY_MEMBERS = new MemberImpl[0];
    private Object membersLock = new Object();
    protected MemberImpl local;
    protected HashMap<MemberImpl, MbrEntry> map = new HashMap();
    protected MemberImpl[] members = EMPTY_MEMBERS;
    protected Comparator<Member> memberComparator = new MemberComparator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Membership clone() {
        Object object = this.membersLock;
        synchronized (object) {
            HashMap hashMap;
            Membership membership;
            try {
                membership = (Membership)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
            membership.map = hashMap = (HashMap)this.map.clone();
            membership.members = (MemberImpl[])this.members.clone();
            membership.membersLock = new Object();
            return membership;
        }
    }

    public Membership(MemberImpl memberImpl, boolean bl) {
        this.local = memberImpl;
        if (bl) {
            this.addMember(memberImpl);
        }
    }

    public Membership(MemberImpl memberImpl) {
        this(memberImpl, false);
    }

    public Membership(MemberImpl memberImpl, Comparator<Member> comparator) {
        this(memberImpl, comparator, false);
    }

    public Membership(MemberImpl memberImpl, Comparator<Member> comparator, boolean bl) {
        this(memberImpl, bl);
        this.memberComparator = comparator;
    }

    public synchronized void reset() {
        this.map.clear();
        this.members = EMPTY_MEMBERS;
    }

    public synchronized boolean memberAlive(MemberImpl memberImpl) {
        boolean bl = false;
        if (memberImpl.equals(this.local)) {
            return bl;
        }
        MbrEntry mbrEntry = this.map.get(memberImpl);
        if (mbrEntry == null) {
            mbrEntry = this.addMember(memberImpl);
            bl = true;
        } else {
            MemberImpl memberImpl2 = mbrEntry.getMember();
            if (memberImpl2.getMemberAliveTime() != memberImpl.getMemberAliveTime()) {
                memberImpl2.setMemberAliveTime(memberImpl.getMemberAliveTime());
                memberImpl2.setPayload(memberImpl.getPayload());
                memberImpl2.setCommand(memberImpl.getCommand());
                Arrays.sort(this.members, this.memberComparator);
            }
        }
        mbrEntry.accessed();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MbrEntry addMember(MemberImpl memberImpl) {
        Object object = this.membersLock;
        synchronized (object) {
            MbrEntry mbrEntry = new MbrEntry(memberImpl);
            if (!this.map.containsKey(memberImpl)) {
                this.map.put(memberImpl, mbrEntry);
                MemberImpl[] memberImplArray = new MemberImpl[this.members.length + 1];
                for (int i = 0; i < this.members.length; ++i) {
                    memberImplArray[i] = this.members[i];
                }
                memberImplArray[this.members.length] = memberImpl;
                this.members = memberImplArray;
                Arrays.sort(this.members, this.memberComparator);
            }
            return mbrEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(MemberImpl memberImpl) {
        this.map.remove(memberImpl);
        Object object = this.membersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i] != memberImpl && !this.members[i].equals(memberImpl)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            MemberImpl[] memberImplArray = new MemberImpl[this.members.length - 1];
            int n2 = 0;
            for (int i = 0; i < this.members.length; ++i) {
                if (i == n) continue;
                memberImplArray[n2++] = this.members[i];
            }
            this.members = memberImplArray;
        }
    }

    public synchronized MemberImpl[] expire(long l) {
        if (!this.hasMembers()) {
            return EMPTY_MEMBERS;
        }
        ArrayList<MemberImpl> arrayList = null;
        for (MbrEntry memberImplArray : this.map.values()) {
            if (!memberImplArray.hasExpired(l)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<MemberImpl>();
            }
            arrayList.add(memberImplArray.getMember());
        }
        if (arrayList != null) {
            MemberImpl[] memberImplArray = new MemberImpl[arrayList.size()];
            arrayList.toArray(memberImplArray);
            for (MemberImpl memberImpl : memberImplArray) {
                this.removeMember(memberImpl);
            }
            return memberImplArray;
        }
        return EMPTY_MEMBERS;
    }

    public boolean hasMembers() {
        return this.members.length > 0;
    }

    public Member getMember(Member member) {
        MemberImpl[] memberImplArray = this.members;
        if (memberImplArray.length > 0) {
            for (MemberImpl memberImpl : memberImplArray) {
                if (!((Object)memberImpl).equals(member)) continue;
                return memberImpl;
            }
        }
        return null;
    }

    public boolean contains(Member member) {
        return this.getMember(member) != null;
    }

    public MemberImpl[] getMembers() {
        if (this.hasMembers()) {
            return this.members;
        }
        return EMPTY_MEMBERS;
    }

    protected synchronized MbrEntry[] getMemberEntries() {
        MbrEntry[] mbrEntryArray = new MbrEntry[this.map.size()];
        Iterator<Map.Entry<MemberImpl, MbrEntry>> iterator = this.map.entrySet().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            mbrEntryArray[n++] = iterator.next().getValue();
        }
        return mbrEntryArray;
    }

    protected static class MbrEntry {
        protected MemberImpl mbr;
        protected long lastHeardFrom;

        public MbrEntry(MemberImpl memberImpl) {
            this.mbr = memberImpl;
        }

        public void accessed() {
            this.lastHeardFrom = System.currentTimeMillis();
        }

        public MemberImpl getMember() {
            return this.mbr;
        }

        public boolean hasExpired(long l) {
            long l2 = System.currentTimeMillis() - this.lastHeardFrom;
            return l2 > l;
        }
    }

    private static class MemberComparator
    implements Comparator<Member>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private MemberComparator() {
        }

        @Override
        public int compare(Member member, Member member2) {
            long l = member2.getMemberAliveTime() - member.getMemberAliveTime();
            if (l < 0L) {
                return -1;
            }
            if (l == 0L) {
                return 0;
            }
            return 1;
        }
    }
}

