﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appintegrations/AppIntegrationsService_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace AppIntegrationsService
{
namespace Model
{

  /**
   * <p>The Amazon AppIntegrations APIs are in preview release and are subject to
   * change.</p> <p>The event filter.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/EventFilter">AWS
   * API Reference</a></p>
   */
  class AWS_APPINTEGRATIONSSERVICE_API EventFilter
  {
  public:
    EventFilter();
    EventFilter(Aws::Utils::Json::JsonView jsonValue);
    EventFilter& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>The source of the events.</p>
     */
    inline const Aws::String& GetSource() const{ return m_source; }

    /**
     * <p>The source of the events.</p>
     */
    inline bool SourceHasBeenSet() const { return m_sourceHasBeenSet; }

    /**
     * <p>The source of the events.</p>
     */
    inline void SetSource(const Aws::String& value) { m_sourceHasBeenSet = true; m_source = value; }

    /**
     * <p>The source of the events.</p>
     */
    inline void SetSource(Aws::String&& value) { m_sourceHasBeenSet = true; m_source = std::move(value); }

    /**
     * <p>The source of the events.</p>
     */
    inline void SetSource(const char* value) { m_sourceHasBeenSet = true; m_source.assign(value); }

    /**
     * <p>The source of the events.</p>
     */
    inline EventFilter& WithSource(const Aws::String& value) { SetSource(value); return *this;}

    /**
     * <p>The source of the events.</p>
     */
    inline EventFilter& WithSource(Aws::String&& value) { SetSource(std::move(value)); return *this;}

    /**
     * <p>The source of the events.</p>
     */
    inline EventFilter& WithSource(const char* value) { SetSource(value); return *this;}

  private:

    Aws::String m_source;
    bool m_sourceHasBeenSet;
  };

} // namespace Model
} // namespace AppIntegrationsService
} // namespace Aws
