﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cognito-idp/CognitoIdentityProvider_EXPORTS.h>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace CognitoIdentityProvider
{
namespace Model
{

  /**
   * <p>The type used for enabling SMS MFA at the user level. Phone numbers don't
   * need to be verified to be used for SMS MFA. If an MFA type is enabled for a
   * user, the user will be prompted for MFA during all sign in attempts, unless
   * device tracking is turned on and the device has been trusted. If you would like
   * MFA to be applied selectively based on the assessed risk level of sign in
   * attempts, disable MFA for users and turn on Adaptive Authentication for the user
   * pool.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/SMSMfaSettingsType">AWS
   * API Reference</a></p>
   */
  class AWS_COGNITOIDENTITYPROVIDER_API SMSMfaSettingsType
  {
  public:
    SMSMfaSettingsType();
    SMSMfaSettingsType(Aws::Utils::Json::JsonView jsonValue);
    SMSMfaSettingsType& operator=(Aws::Utils::Json::JsonView jsonValue);
    Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>Specifies whether SMS text message MFA is enabled. If an MFA type is enabled
     * for a user, the user will be prompted for MFA during all sign in attempts,
     * unless device tracking is turned on and the device has been trusted.</p>
     */
    inline bool GetEnabled() const{ return m_enabled; }

    /**
     * <p>Specifies whether SMS text message MFA is enabled. If an MFA type is enabled
     * for a user, the user will be prompted for MFA during all sign in attempts,
     * unless device tracking is turned on and the device has been trusted.</p>
     */
    inline bool EnabledHasBeenSet() const { return m_enabledHasBeenSet; }

    /**
     * <p>Specifies whether SMS text message MFA is enabled. If an MFA type is enabled
     * for a user, the user will be prompted for MFA during all sign in attempts,
     * unless device tracking is turned on and the device has been trusted.</p>
     */
    inline void SetEnabled(bool value) { m_enabledHasBeenSet = true; m_enabled = value; }

    /**
     * <p>Specifies whether SMS text message MFA is enabled. If an MFA type is enabled
     * for a user, the user will be prompted for MFA during all sign in attempts,
     * unless device tracking is turned on and the device has been trusted.</p>
     */
    inline SMSMfaSettingsType& WithEnabled(bool value) { SetEnabled(value); return *this;}


    /**
     * <p>Specifies whether SMS is the preferred MFA method.</p>
     */
    inline bool GetPreferredMfa() const{ return m_preferredMfa; }

    /**
     * <p>Specifies whether SMS is the preferred MFA method.</p>
     */
    inline bool PreferredMfaHasBeenSet() const { return m_preferredMfaHasBeenSet; }

    /**
     * <p>Specifies whether SMS is the preferred MFA method.</p>
     */
    inline void SetPreferredMfa(bool value) { m_preferredMfaHasBeenSet = true; m_preferredMfa = value; }

    /**
     * <p>Specifies whether SMS is the preferred MFA method.</p>
     */
    inline SMSMfaSettingsType& WithPreferredMfa(bool value) { SetPreferredMfa(value); return *this;}

  private:

    bool m_enabled;
    bool m_enabledHasBeenSet;

    bool m_preferredMfa;
    bool m_preferredMfaHasBeenSet;
  };

} // namespace Model
} // namespace CognitoIdentityProvider
} // namespace Aws
